/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.conversations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.vonage.client.Jsonable;
import com.vonage.client.JsonableBaseObject;
import com.vonage.client.common.ChannelType;
import com.vonage.client.users.channels.Channel;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public class MemberChannel
extends JsonableBaseObject {
    String id;
    ChannelType type;
    Channel from;
    Channel to;
    Map<String, ?> headers;

    protected MemberChannel() {
    }

    MemberChannel(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.from = builder.from;
        this.to = builder.to;
        this.headers = builder.headers;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public ChannelType getType() {
        return this.type;
    }

    @JsonProperty(value="from")
    public Channel getFrom() {
        return this.from;
    }

    @JsonProperty(value="to")
    public Channel getTo() {
        return this.to;
    }

    @JsonProperty(value="headers")
    public Map<String, ?> getHeaders() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChannelType type;
        private Channel from;
        private Channel to;
        private Map<String, ?> headers;

        Builder() {
        }

        public Builder type(ChannelType type) {
            this.type = type;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder from(Channel from) {
            this.from = from;
            return this;
        }

        public Builder to(Channel to) {
            this.to = to;
            return this;
        }

        public Builder headers(Map<String, ?> headers) {
            this.headers = headers;
            return this;
        }

        public MemberChannel build() {
            return new MemberChannel(this);
        }
    }

    static class Deserializer
    extends StdDeserializer<MemberChannel> {
        private MemberChannel mc;

        protected Deserializer() {
            super(MemberChannel.class);
        }

        public MemberChannel deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return this.deserialize(p, ctxt, new MemberChannel());
        }

        public MemberChannel deserialize(JsonParser p, DeserializationContext ctxt, MemberChannel intoValue) throws IOException {
            this.mc = Objects.requireNonNull(intoValue);
            JsonNode rootNode = (JsonNode)p.readValueAsTree();
            JsonNode typeNode = rootNode.get("type");
            JsonNode idNode = rootNode.get("id");
            JsonNode headersNode = rootNode.get("headers");
            if (typeNode != null) {
                this.mc.type = ChannelType.fromString(typeNode.asText());
            }
            if (idNode != null) {
                this.mc.id = idNode.asText();
            }
            if (headersNode != null) {
                this.mc.headers = (Map)new ObjectMapper().convertValue((Object)headersNode, new TypeReference<Map<String, ?>>(){});
            }
            this.mc.from = this.inferConcreteChannel(rootNode.get("from"));
            this.mc.to = this.inferConcreteChannel(rootNode.get("to"));
            return this.mc;
        }

        private Channel inferConcreteChannel(JsonNode node) {
            if (node == null || !node.isObject()) {
                return null;
            }
            JsonNode typeNode = node.get("type");
            ChannelType fromType = typeNode != null ? ChannelType.fromString(typeNode.asText()) : this.mc.type;
            Class<? extends Channel> concreteClass = Channel.getConcreteClass(fromType);
            if (concreteClass == null) {
                throw new IllegalStateException("Unmapped class for type " + (Object)((Object)fromType));
            }
            return Jsonable.fromJson(node.toString(), concreteClass);
        }
    }
}

