/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.vonage.client.voice.ncco.Endpoint;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PhoneEndpoint
implements Endpoint {
    private static final String TYPE = "phone";
    private String number;
    private String dtmfAnswer;
    private OnAnswer onAnswer;

    private PhoneEndpoint(Builder builder) {
        this.number = builder.number;
        this.dtmfAnswer = builder.dtmfAnswer;
        this.onAnswer = builder.onAnswerUrl != null ? new OnAnswer(builder.onAnswerUrl, builder.onAnswerRingback) : null;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getNumber() {
        return this.number;
    }

    public String getDtmfAnswer() {
        return this.dtmfAnswer;
    }

    public OnAnswer getOnAnswer() {
        return this.onAnswer;
    }

    public static Builder builder(String number) {
        return new Builder(number);
    }

    public static class Builder {
        private String number;
        private String dtmfAnswer = null;
        private String onAnswerUrl = null;
        private String onAnswerRingback = null;

        public Builder(String number) {
            this.number = number;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder dtmfAnswer(String dtmfAnswer) {
            this.dtmfAnswer = dtmfAnswer;
            return this;
        }

        public Builder onAnswer(String url) {
            this.onAnswerUrl = url;
            return this;
        }

        public Builder onAnswer(String url, String ringback) {
            this.onAnswerUrl = url;
            this.onAnswerRingback = ringback;
            return this;
        }

        public PhoneEndpoint build() {
            return new PhoneEndpoint(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private class OnAnswer {
        private String url;
        private String ringback;

        private OnAnswer(String url) {
            this.url = url;
        }

        private OnAnswer(String url, String ringback) {
            this(url);
            this.ringback = ringback;
        }

        public String getUrl() {
            return this.url;
        }

        public String getRingback() {
            return this.ringback;
        }
    }
}

