/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageBadRequestException;
import com.vonage.client.VonageClientException;
import com.vonage.client.application.Application;
import com.vonage.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.util.EntityUtils;

class CreateApplicationMethod
extends AbstractMethod<Application, Application> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/applications";

    CreateApplicationMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(Application application) throws UnsupportedEncodingException {
        return RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getVersionedApiBaseUri("v2") + PATH)).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(application.toJson()));
    }

    @Override
    public Application parseResponse(HttpResponse response) throws IOException, VonageClientException {
        if (response.getStatusLine().getStatusCode() != 201) {
            throw new VonageBadRequestException(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        return Application.fromJson(new BasicResponseHandler().handleResponse(response));
    }
}

