/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class LoaderService
extends StatefulService {
    public static final long MAINTENANCE_INTERVAL_MICROS = 30000000L;
    public static final String FILESYSTEM_DEFAULT_GROUP = "default";
    public static final String FILESYSTEM_DEFAULT_PATH = "services";

    public LoaderService() {
        super(LoaderServiceState.class);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
    }

    public void handleStart(Operation op) {
        if (op.hasBody()) {
            LoaderServiceState s = (LoaderServiceState)((Object)op.getBody(LoaderServiceState.class));
            if (s.loaderType == null) {
                s.loaderType = LoaderType.FILESYSTEM;
            }
            this.logFine("Initial path is %s", new Object[]{s.path});
        }
        super.setMaintenanceIntervalMicros(30000000L);
        op.complete();
    }

    public void handlePatch(Operation patch) {
        LoaderServiceState currentState = (LoaderServiceState)this.getState(patch);
        LoaderServiceState patchBody = (LoaderServiceState)this.getBody(patch);
        if (patchBody.path != null) {
            currentState.path = patchBody.path;
        }
        currentState.loaderType = patchBody.loaderType != null ? patchBody.loaderType : LoaderType.FILESYSTEM;
        if (patchBody.servicePackages != null) {
            currentState.servicePackages = patchBody.servicePackages;
        }
        patch.setBody((Object)currentState).complete();
    }

    public void handlePut(Operation put) {
        LoaderServiceState newState = (LoaderServiceState)((Object)put.getBody(LoaderServiceState.class));
        if (newState.loaderType == null) {
            newState.loaderType = LoaderType.FILESYSTEM;
        }
        this.setState(put, newState);
        put.setBody((Object)newState).complete();
    }

    public void handlePost(Operation op) {
        this.logFine("Post called", new Object[0]);
        if (!op.hasBody()) {
            op.fail((Throwable)new IllegalArgumentException("body is required"));
            return;
        }
        LoaderServiceState localState = (LoaderServiceState)this.getState(op);
        if (localState == null || localState.loaderType == null || localState.path == null) {
            op.fail((Throwable)new IllegalStateException("Service state is null or invalid"));
            return;
        }
        op.setStatusCode(202).complete();
        this.loadServices(localState);
    }

    public void handleMaintenance(Operation op) {
        this.logFine("Maintenance called", new Object[0]);
        this.sendRequest(Operation.createGet((URI)this.getUri()).setCompletion((o, e) -> this.performMaintenance(op, o, e)));
    }

    private void performMaintenance(Operation maint, Operation get, Throwable getEx) {
        if (getEx != null) {
            this.logWarning("Failure getting state: %s", new Object[]{getEx.toString()});
            maint.complete();
            return;
        }
        if (!get.hasBody()) {
            maint.complete();
            return;
        }
        if (this.getHost().isStopping()) {
            maint.complete();
            return;
        }
        LoaderServiceState localState = (LoaderServiceState)((Object)get.getBody(LoaderServiceState.class));
        if (localState == null || localState.loaderType == null || localState.path == null) {
            maint.complete();
            return;
        }
        this.loadServices(localState);
        maint.complete();
    }

    private void loadServices(LoaderServiceState localState) {
        Map<String, LoaderServiceInfo> discoveredPackages = null;
        switch (localState.loaderType) {
            case FILESYSTEM: {
                try {
                    discoveredPackages = this.loadFromFileSystem(localState);
                }
                catch (Exception e) {
                    this.logWarning("Failed to load packages from path %s, %s.", new Object[]{localState.path, Utils.toString((Throwable)e)});
                }
                break;
            }
            default: {
                this.logWarning("Unknown loader type: %s", new Object[]{localState.loaderType});
            }
        }
        if (discoveredPackages != null) {
            LoaderServiceState newState = new LoaderServiceState();
            newState.servicePackages = discoveredPackages;
            Operation patch = Operation.createPatch((URI)this.getUri()).setBody((Object)newState);
            this.sendRequest(patch);
        }
    }

    private Map<String, LoaderServiceInfo> loadFromFileSystem(LoaderServiceState state) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Map<String, LoaderServiceInfo> services;
        File libDir = new File(state.path);
        if (!libDir.isAbsolute()) {
            libDir = new File(new File(this.getHost().getStorageSandbox()), state.path);
        }
        if (!libDir.exists()) {
            if (!libDir.mkdirs()) {
                this.logFine("Failed to pre-create the Loader path directory %s", new Object[]{libDir});
                return null;
            }
        } else if (!libDir.isDirectory()) {
            this.logFine("Loader path %s is not a directory.", new Object[]{libDir.getAbsolutePath()});
            return null;
        }
        if ((services = this.discoverServices(libDir, state.servicePackages)) != null) {
            this.startDiscoveredServices(services, state);
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDiscoveredServices(Map<String, LoaderServiceInfo> services, LoaderServiceState state) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.logFine("Updating the class loader with new libraries", new Object[0]);
        URL[] urls = new URL[services.size()];
        int i = 0;
        for (String servicePackage : services.keySet()) {
            try {
                urls[i++] = new URI(servicePackage).toURL();
            }
            catch (MalformedURLException | URISyntaxException e) {
                this.logWarning("Failed to convert path to URL", new Object[]{Utils.toString((Throwable)e)});
            }
        }
        URLClassLoader cl = null;
        try {
            cl = new URLClassLoader(urls);
            for (LoaderServiceInfo packageInfo : services.values()) {
                this.logFine("Processing package %s", new Object[]{packageInfo.name});
                Iterator<String> iterator = packageInfo.serviceClasses.keySet().iterator();
                while (iterator.hasNext()) {
                    String serviceClass = iterator.next();
                    Class<?> clazz = cl.loadClass(serviceClass);
                    if (this.isValidDynamicService(clazz)) {
                        Service service = this.startDynamicService(clazz);
                        packageInfo.serviceClasses.put(serviceClass, service.getSelfLink());
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
        finally {
            if (cl != null) {
                try {
                    cl.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Service startDynamicService(Class<?> clazz) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Service service = (Service)clazz.newInstance();
        URI link = null;
        if (this.getSelfOrFactoryLink(clazz).getName().equals("SELF_LINK")) {
            link = UriUtils.buildUri((ServiceHost)this.getHost(), service.getClass());
            this.getHost().startService(Operation.createPost((URI)link), service);
        } else {
            link = UriUtils.buildFactoryUri((ServiceHost)this.getHost(), service.getClass());
            this.getHost().startFactory(service);
        }
        this.logInfo("Started service " + link, new Object[0]);
        return service;
    }

    private boolean isValidDynamicService(Class<?> clazz) throws IllegalArgumentException, IllegalAccessException {
        return Service.class.isAssignableFrom(clazz) && this.getSelfOrFactoryLink(clazz) != null;
    }

    private Field getSelfOrFactoryLink(Class<?> clazz) throws IllegalArgumentException, IllegalAccessException {
        try {
            Field link = clazz.getField("SELF_LINK");
            this.logFine("Class %s self link %s", new Object[]{clazz, link.get(null)});
            return link;
        }
        catch (NoSuchFieldException e) {
            try {
                Field link = clazz.getField("FACTORY_LINK");
                this.logFine("Class %s factory link %s", new Object[]{clazz, link.get(null)});
                return link;
            }
            catch (NoSuchFieldException e2) {
                this.logFine("Self link fields wasn't found in %s", new Object[]{clazz});
                return null;
            }
        }
    }

    private Map<String, LoaderServiceInfo> discoverServices(File libDir, Map<String, LoaderServiceInfo> existingPackages) {
        this.logFine("Checking for updates in " + libDir.toURI(), new Object[0]);
        HashMap<String, LoaderServiceInfo> discoveredPackages = new HashMap<String, LoaderServiceInfo>();
        boolean updated = false;
        File[] files = libDir.listFiles();
        if (files == null) {
            return null;
        }
        block11: for (File file : files) {
            long lastModified;
            if (!file.getName().endsWith(".jar")) continue;
            this.logFine("Found jar file %s", new Object[]{file.toURI()});
            LoaderServiceInfo packageInfo = existingPackages.get(file.toURI().toString());
            if (packageInfo != null && (lastModified = file.lastModified()) == packageInfo.fileUpdateTimeMillis) {
                discoveredPackages.put(file.toURI().toString(), packageInfo);
                continue;
            }
            try (JarInputStream jar = new JarInputStream(new FileInputStream(file));){
                while (true) {
                    JarEntry e;
                    if ((e = jar.getNextJarEntry()) == null) {
                        continue block11;
                    }
                    String name = e.getName();
                    if (!this.isValidServiceClassName(name)) continue;
                    this.logFine("Found service class %s", new Object[]{name});
                    String className = name.replaceAll("\\.class$", "").replaceAll("/", ".");
                    if (packageInfo == null) {
                        packageInfo = new LoaderServiceInfo();
                    }
                    packageInfo.name = file.getName();
                    packageInfo.fileUpdateTimeMillis = file.lastModified();
                    updated |= null == packageInfo.serviceClasses.put(className, null);
                    discoveredPackages.put(file.toURI().toString(), packageInfo);
                }
            }
            catch (IOException e) {
                this.logWarning("Problem loading package %s, Exception %s", new Object[]{file.getName(), Utils.toString((Throwable)e)});
            }
        }
        if (updated) {
            return discoveredPackages;
        }
        return null;
    }

    private boolean isValidServiceClassName(String name) {
        return name.endsWith("Factory.class") || name.endsWith("Service.class");
    }

    public static class LoaderServiceState
    extends ServiceDocument {
        public LoaderType loaderType;
        public String path;
        public Map<String, LoaderServiceInfo> servicePackages;
    }

    public static class LoaderServiceInfo {
        public String name;
        public Long fileUpdateTimeMillis;
        public Map<String, String> serviceClasses = new HashMap<String, String>();
    }

    public static enum LoaderType {
        FILESYSTEM;

    }
}

