/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.BroadcastQueryPageService;
import com.vmware.xenon.services.common.ExampleService;
import com.vmware.xenon.services.common.NodeGroupBroadcastResponse;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.QueryTaskUtils;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class QueryTaskService
extends StatefulService {
    private static final long DEFAULT_EXPIRATION_SECONDS = 600L;
    private static final Integer DEFAULT_RESULT_LIMIT = Integer.MAX_VALUE;
    private ServiceDocumentQueryResult results;

    public QueryTaskService() {
        super(QueryTask.class);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation startPost) {
        if (!startPost.hasBody()) {
            startPost.fail(new IllegalArgumentException("Body is required"));
            return;
        }
        QueryTask initState = startPost.getBody(QueryTask.class);
        if (initState.taskInfo == null) {
            initState.taskInfo = new TaskState();
        } else if (TaskState.isFinished(initState.taskInfo)) {
            startPost.complete();
            return;
        }
        if (!this.validateState(initState, startPost)) {
            return;
        }
        if (initState.documentExpirationTimeMicros == 0L) {
            initState.documentExpirationTimeMicros = Utils.fromNowMicrosUtc(TimeUnit.SECONDS.toMicros(600L));
        }
        initState.taskInfo.stage = TaskState.TaskStage.CREATED;
        if (!initState.taskInfo.isDirect) {
            startPost.setStatusCode(202).complete();
            QueryTask patchBody = new QueryTask();
            patchBody.taskInfo = new TaskState();
            patchBody.taskInfo.stage = TaskState.TaskStage.STARTED;
            patchBody.querySpec = initState.querySpec;
            this.sendRequest(Operation.createPatch(this.getUri()).setBody(patchBody));
        } else if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.BROADCAST)) {
            this.createAndSendBroadcastQuery(initState, startPost);
        } else {
            this.forwardQueryToDocumentIndexService(initState, startPost);
        }
    }

    private boolean validateState(QueryTask initState, Operation startPost) {
        String errFmt;
        if (initState.querySpec == null) {
            startPost.fail(new IllegalArgumentException("querySpec is required"));
            return false;
        }
        if (initState.querySpec.query == null) {
            startPost.fail(new IllegalArgumentException("querySpec.query is required"));
            return false;
        }
        if (initState.querySpec.options == null || initState.querySpec.options.isEmpty()) {
            return true;
        }
        if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
            errFmt = (Object)((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT) + " is not compatible with %s";
            if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
                startPost.fail(new IllegalArgumentException(String.format(errFmt, new Object[]{QueryTask.QuerySpecification.QueryOption.COUNT})));
                return false;
            }
        }
        if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT)) {
            errFmt = (Object)((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT) + " is not compatible with %s";
            if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
                startPost.fail(new IllegalArgumentException(String.format(errFmt, new Object[]{QueryTask.QuerySpecification.QueryOption.COUNT})));
                return false;
            }
        }
        if (startPost.isRemote() && initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT)) {
            errFmt = "%s is not allowed for remote clients.";
            startPost.fail(new IllegalArgumentException(String.format("%s is not allowed for remote clients.", new Object[]{QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT})));
            return false;
        }
        if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT) && (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.OWNER_SELECTION) || initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BUILTIN_CONTENT_ONLY) || initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT))) {
            errFmt = "%s is not compatible with %s / %s / %s";
            startPost.fail(new IllegalArgumentException(String.format("%s is not compatible with %s / %s / %s", new Object[]{QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT, QueryTask.QuerySpecification.QueryOption.OWNER_SELECTION, QueryTask.QuerySpecification.QueryOption.EXPAND_BUILTIN_CONTENT_ONLY, QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT})));
            return false;
        }
        if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_LINKS) && !initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.SELECT_LINKS)) {
            startPost.fail(new IllegalArgumentException("Must be combined with " + (Object)((Object)QueryTask.QuerySpecification.QueryOption.SELECT_LINKS)));
            return false;
        }
        if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.GROUP_BY)) {
            errFmt = (Object)((Object)QueryTask.QuerySpecification.QueryOption.GROUP_BY) + " is not compatible with %s";
            if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
                startPost.fail(new IllegalArgumentException(String.format(errFmt, new Object[]{QueryTask.QuerySpecification.QueryOption.COUNT})));
                return false;
            }
            if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.CONTINUOUS)) {
                startPost.fail(new IllegalArgumentException(String.format(errFmt, new Object[]{QueryTask.QuerySpecification.QueryOption.CONTINUOUS})));
                return false;
            }
            if (initState.querySpec.groupByTerm == null) {
                startPost.fail(new IllegalArgumentException("querySpec.groupByTerm is required with " + (Object)((Object)QueryTask.QuerySpecification.QueryOption.GROUP_BY)));
                return false;
            }
            if (initState.querySpec.sortTerm == null) {
                startPost.fail(new IllegalArgumentException("querySpec.sortTerm is required with " + (Object)((Object)QueryTask.QuerySpecification.QueryOption.GROUP_BY)));
                return false;
            }
        }
        if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.SELECT_LINKS)) {
            errFmt = (Object)((Object)QueryTask.QuerySpecification.QueryOption.SELECT_LINKS) + " is not compatible with %s";
            if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
                startPost.fail(new IllegalArgumentException(String.format(errFmt, new Object[]{QueryTask.QuerySpecification.QueryOption.COUNT})));
                return false;
            }
            if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.CONTINUOUS)) {
                startPost.fail(new IllegalArgumentException(String.format(errFmt, new Object[]{QueryTask.QuerySpecification.QueryOption.CONTINUOUS})));
                return false;
            }
            if (initState.querySpec.linkTerms == null || initState.querySpec.linkTerms.isEmpty()) {
                startPost.fail(new IllegalArgumentException("querySpec.linkTerms must have at least one entry"));
                return false;
            }
        }
        if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_SELECTED_FIELDS)) {
            errFmt = (Object)((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_SELECTED_FIELDS) + " is not compatible with %s";
            if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT)) {
                startPost.fail(new IllegalArgumentException(String.format(errFmt, new Object[]{QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT})));
                return false;
            }
            if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT)) {
                startPost.fail(new IllegalArgumentException(String.format(errFmt, new Object[]{QueryTask.QuerySpecification.QueryOption.EXPAND_BINARY_CONTENT})));
                return false;
            }
            if (initState.querySpec.selectTerms == null || initState.querySpec.selectTerms.isEmpty()) {
                startPost.fail(new IllegalArgumentException("querySpec.fieldTerms must have at least one entry"));
                return false;
            }
        }
        if (initState.taskInfo.isDirect && initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.CONTINUOUS)) {
            startPost.fail(new IllegalArgumentException("direct query task is not compatible with " + (Object)((Object)QueryTask.QuerySpecification.QueryOption.CONTINUOUS)));
            return false;
        }
        if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.BROADCAST) && initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.SORT) && initState.querySpec.sortTerm != null && !Objects.equals(initState.querySpec.sortTerm.propertyName, "documentSelfLink")) {
            startPost.fail(new IllegalArgumentException((Object)((Object)QueryTask.QuerySpecification.QueryOption.BROADCAST) + " only supports sorting on [" + "documentSelfLink" + "]"));
            return false;
        }
        if (initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.TIME_SNAPSHOT) && initState.querySpec.timeSnapshotBoundaryMicros == null) {
            startPost.fail(new IllegalArgumentException((Object)((Object)QueryTask.QuerySpecification.QueryOption.TIME_SNAPSHOT) + " will return latest versions of documents only if querySpec.timeSnapshotBoundaryMicros is provided"));
            return false;
        }
        if (!initState.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.TIME_SNAPSHOT) && initState.querySpec.timeSnapshotBoundaryMicros != null) {
            startPost.fail(new IllegalArgumentException("Either enable " + (Object)((Object)QueryTask.QuerySpecification.QueryOption.TIME_SNAPSHOT) + " for retreiving latest versions of documents, for the given querySpec.timeSnapshotBoundaryMicros or do not provide querySpec.timeSnapshotBoundaryMicros"));
            return false;
        }
        return true;
    }

    private void createAndSendBroadcastQuery(QueryTask origQueryTask, Operation startPost) {
        QueryTask queryTask = Utils.clone(origQueryTask);
        queryTask.setDirect(true);
        queryTask.querySpec.options.remove((Object)QueryTask.QuerySpecification.QueryOption.BROADCAST);
        if (!queryTask.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.SORT)) {
            queryTask.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.SORT);
            queryTask.querySpec.sortOrder = QueryTask.QuerySpecification.SortOrder.ASC;
            queryTask.querySpec.sortTerm = new QueryTask.QueryTerm();
            queryTask.querySpec.sortTerm.propertyType = ServiceDocumentDescription.TypeName.STRING;
            queryTask.querySpec.sortTerm.propertyName = "documentSelfLink";
        }
        URI localQueryTaskFactoryUri = UriUtils.buildUri(this.getHost(), ServiceUriPaths.CORE_LOCAL_QUERY_TASKS);
        URI forwardingService = UriUtils.buildBroadcastRequestUri(localQueryTaskFactoryUri, queryTask.nodeSelectorLink);
        Operation op = Operation.createPost(forwardingService).setBody(queryTask).setReferer(this.getUri()).setConnectionSharing(true).setCompletion((o, e) -> {
            if (e != null) {
                this.failTask(e, startPost, null);
                return;
            }
            NodeGroupBroadcastResponse rsp = o.getBody(NodeGroupBroadcastResponse.class);
            if (!rsp.failures.isEmpty()) {
                if ((long)rsp.jsonResponses.size() < rsp.membershipQuorum) {
                    this.failTask(new IllegalStateException("Failures received: " + Utils.toJsonHtml(rsp)), startPost, null);
                    return;
                }
                this.logWarning("task will proceed, received %d responses (for quorum size %d)even though %d errors were received: %s", rsp.jsonResponses.size(), rsp.membershipQuorum, rsp.failures.size(), rsp.failures.keySet());
            }
            this.collectBroadcastQueryResults(rsp.jsonResponses, queryTask);
            queryTask.taskInfo.stage = TaskState.TaskStage.FINISHED;
            if (startPost != null) {
                startPost.setBodyNoCloning(queryTask).complete();
            } else {
                this.sendRequest(Operation.createPatch(this.getUri()).setBodyNoCloning(queryTask));
            }
        });
        this.getHost().sendRequest(op);
    }

    private void collectBroadcastQueryResults(Map<URI, String> jsonResponses, QueryTask queryTask) {
        boolean isPaginatedQuery;
        long startTimeNanos = System.nanoTime();
        ArrayList<ServiceDocumentQueryResult> queryResults = new ArrayList<ServiceDocumentQueryResult>();
        for (Map.Entry<URI, String> entry : jsonResponses.entrySet()) {
            QueryTask rsp = Utils.fromJson(entry.getValue(), QueryTask.class);
            queryResults.add(rsp.results);
        }
        boolean bl = isPaginatedQuery = queryTask.querySpec.resultLimit != null && queryTask.querySpec.resultLimit < Integer.MAX_VALUE && !queryTask.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS);
        if (!isPaginatedQuery) {
            boolean isAscOrder = queryTask.querySpec.sortOrder == null || queryTask.querySpec.sortOrder == QueryTask.QuerySpecification.SortOrder.ASC;
            queryTask.results = QueryTaskUtils.mergeQueryResults(queryResults, isAscOrder, queryTask.querySpec.options);
        } else {
            URI broadcastPageServiceUri = UriUtils.buildUri(this.getHost(), UriUtils.buildUriPath("/core", "broadcast-query-page", String.valueOf(Utils.getNowMicrosUtc())));
            URI forwarderUri = UriUtils.buildForwardToPeerUri(broadcastPageServiceUri, this.getHost().getId(), "/core/node-selectors/default", EnumSet.noneOf(Service.ServiceOption.class));
            ServiceDocument postBody = new ServiceDocument();
            postBody.documentSelfLink = broadcastPageServiceUri.getPath();
            postBody.documentExpirationTimeMicros = queryTask.documentExpirationTimeMicros;
            Operation startPost = Operation.createPost(broadcastPageServiceUri).setBody(postBody).setCompletion((o, e) -> {
                if (e != null) {
                    this.failTask(e, o, null);
                }
            });
            List<String> nextPageLinks = queryResults.stream().filter(r -> r.nextPageLink != null).map(r -> r.nextPageLink).collect(Collectors.toList());
            queryTask.results = new ServiceDocumentQueryResult();
            queryTask.results.documentCount = 0L;
            if (!nextPageLinks.isEmpty()) {
                queryTask.results.nextPageLink = forwarderUri.getPath() + "?" + forwarderUri.getQuery();
                this.getHost().startService(startPost, new BroadcastQueryPageService(queryTask.querySpec, nextPageLinks, queryTask.documentExpirationTimeMicros));
            } else {
                queryTask.results.nextPageLink = null;
            }
        }
        if (queryResults.size() > 0) {
            long timeElapsed = System.nanoTime() - startTimeNanos;
            queryTask.taskInfo.durationMicros = (timeElapsed /= 1000L) + (Long)Collections.max(queryResults.stream().map(r -> r.queryTimeMicros).collect(Collectors.toList()));
        }
    }

    @Override
    public void handleGet(Operation get) {
        QueryTask currentState = (QueryTask)Utils.clone(this.getState(get));
        ServiceDocumentQueryResult r = this.results;
        if (r == null || currentState == null) {
            get.setBodyNoCloning(currentState).complete();
            return;
        }
        currentState.results = new ServiceDocumentQueryResult();
        r.copyTo(currentState.results);
        this.resetQuerySpecNativeContext(currentState);
        if (r.documentLinks != null) {
            currentState.results.documentLinks = new ArrayList<String>(r.documentLinks);
        }
        if (r.documents != null) {
            currentState.results.documents = new HashMap<String, Object>(r.documents);
        }
        if (r.selectedLinksPerDocument != null) {
            currentState.results.selectedLinksPerDocument = new HashMap<String, Map<String, String>>(r.selectedLinksPerDocument);
        }
        if (r.selectedLinks != null) {
            currentState.results.selectedLinks = new HashSet<String>(r.selectedLinks);
        }
        if (r.selectedDocuments != null) {
            currentState.results.selectedDocuments = new HashMap<String, Object>(r.selectedDocuments);
        }
        if (r.nextPageLinksPerGroup != null) {
            currentState.results.nextPageLinksPerGroup = new TreeMap<String, String>(r.nextPageLinksPerGroup);
        }
        if (r.continuousResults != null) {
            ServiceDocumentQueryResult.ContinuousResult continuousResult = new ServiceDocumentQueryResult.ContinuousResult();
            continuousResult.documentCountAdded = r.continuousResults.documentCountAdded;
            continuousResult.documentCountUpdated = r.continuousResults.documentCountUpdated;
            continuousResult.documentCountDeleted = r.continuousResults.documentCountDeleted;
            currentState.results.continuousResults = continuousResult;
        }
        get.setBodyNoCloning(currentState).complete();
    }

    private void resetQuerySpecNativeContext(QueryTask currentState) {
        currentState.querySpec.context.nativePage = null;
        currentState.querySpec.context.nativeQuery = null;
        currentState.querySpec.context.nativeSort = null;
        currentState.querySpec.context.nativeSearcher = null;
    }

    @Override
    public void handlePatch(Operation patch) {
        if (patch.isFromReplication()) {
            patch.complete();
            return;
        }
        QueryTask state = (QueryTask)this.getState(patch);
        if (state == null) {
            patch.fail(new IllegalStateException("service state missing"));
            return;
        }
        QueryTask patchBody = patch.getBody(QueryTask.class);
        TaskState newTaskState = patchBody.taskInfo;
        this.results = patchBody.results;
        if (newTaskState == null) {
            patch.fail(new IllegalArgumentException("taskInfo is required"));
            return;
        }
        if (newTaskState.stage == null) {
            patch.fail(new IllegalArgumentException("stage is required"));
            return;
        }
        if (state.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.CONTINUOUS) && this.handlePatchForContinuousQuery(state, patchBody, patch)) {
            return;
        }
        if (newTaskState.stage.ordinal() <= state.taskInfo.stage.ordinal()) {
            patch.fail(new IllegalArgumentException("new stage must be greater than current"));
            return;
        }
        state.taskInfo = newTaskState;
        if (newTaskState.stage == TaskState.TaskStage.STARTED) {
            patch.setStatusCode(202);
        } else if (newTaskState.stage == TaskState.TaskStage.FAILED || newTaskState.stage == TaskState.TaskStage.CANCELLED) {
            if (newTaskState.failure == null) {
                patch.fail(new IllegalArgumentException("failure must be specified"));
                return;
            }
            this.logWarning("query failed: %s", newTaskState.failure.message);
        }
        patch.complete();
        if (newTaskState.stage == TaskState.TaskStage.STARTED) {
            if (patchBody.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.BROADCAST)) {
                this.createAndSendBroadcastQuery(patchBody, null);
            } else {
                this.forwardQueryToDocumentIndexService(state, null);
            }
        }
    }

    private boolean handlePatchForContinuousQuery(QueryTask state, QueryTask patchBody, Operation patch) {
        switch (state.taskInfo.stage) {
            case STARTED: {
                break;
            }
            default: {
                return false;
            }
        }
        switch (patchBody.taskInfo.stage) {
            case CREATED: {
                return false;
            }
            case STARTED: {
                if (patchBody.results.continuousResults == null) {
                    patchBody.results.continuousResults = new ServiceDocumentQueryResult.ContinuousResult();
                }
                if (state.results == null) {
                    state.results = patchBody.results;
                    if (state.results.documentCount != null) break;
                    state.results.documentCount = 0L;
                    break;
                }
                if (this.results.documents == null) break;
                this.results.documents.values().stream().forEach(doc -> {
                    ServiceDocument serviceDocument = (ServiceDocument)doc;
                    if (serviceDocument.documentUpdateAction.equals(Service.Action.DELETE.name())) {
                        Object object = state.results;
                        ((ServiceDocumentQueryResult)object).documentCount = ((ServiceDocumentQueryResult)object).documentCount - 1L;
                        object = state.results.continuousResults;
                        ((ServiceDocumentQueryResult.ContinuousResult)object).documentCountDeleted = ((ServiceDocumentQueryResult.ContinuousResult)object).documentCountDeleted + 1L;
                    } else if (serviceDocument.documentUpdateAction.equals(Service.Action.POST.name()) && serviceDocument.documentVersion == 0L) {
                        Object object = state.results;
                        ((ServiceDocumentQueryResult)object).documentCount = ((ServiceDocumentQueryResult)object).documentCount + 1L;
                        object = state.results.continuousResults;
                        ((ServiceDocumentQueryResult.ContinuousResult)object).documentCountAdded = ((ServiceDocumentQueryResult.ContinuousResult)object).documentCountAdded + 1L;
                    } else if (serviceDocument.documentUpdateAction.equals(Service.Action.PATCH.name()) || serviceDocument.documentUpdateAction.equals(Service.Action.PUT.name())) {
                        ServiceDocumentQueryResult.ContinuousResult continuousResult = state.results.continuousResults;
                        continuousResult.documentCountUpdated = continuousResult.documentCountUpdated + 1L;
                    }
                });
                if (state.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
                    state.results.documents = null;
                    state.results.documentLinks = null;
                    this.results.documents.clear();
                    this.results.documentLinks.clear();
                    this.results.documentCount = state.results.documentCount;
                    this.results.continuousResults = state.results.continuousResults;
                }
                patchBody.results.continuousResults = state.results.continuousResults;
                break;
            }
            case CANCELLED: 
            case FAILED: 
            case FINISHED: {
                this.cancelContinuousQueryOnIndex(state);
                break;
            }
        }
        if (state.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
            patch.setBodyNoCloning(state).complete();
        } else {
            if (patchBody.results.continuousResults == null) {
                patchBody.results.continuousResults = new ServiceDocumentQueryResult.ContinuousResult();
            }
            patch.complete();
        }
        return true;
    }

    private void forwardQueryToDocumentIndexService(QueryTask task, Operation directOp) {
        try {
            if (task.querySpec.resultLimit == null) {
                task.querySpec.resultLimit = DEFAULT_RESULT_LIMIT;
            }
            Operation localPatch = Operation.createPatch(this, task.indexLink).setBodyNoCloning(task).setCompletion((o, e) -> {
                if (e == null) {
                    task.results = (ServiceDocumentQueryResult)o.getBodyRaw();
                }
                this.handleQueryCompletion(task, e, directOp);
            });
            this.sendRequest(localPatch);
        }
        catch (Throwable e2) {
            this.handleQueryCompletion(task, e2, directOp);
        }
    }

    private void scheduleTaskExpiration(QueryTask task) {
        if (task.taskInfo.isDirect) {
            this.getHost().stopService(this);
            return;
        }
        if (this.getHost().isStopping()) {
            return;
        }
        Operation delete = Operation.createDelete(this.getUri()).setBody(new ServiceDocument());
        long delta = task.documentExpirationTimeMicros - Utils.getSystemNowMicrosUtc();
        delta = Math.max(1L, delta);
        this.getHost().scheduleCore(() -> {
            if (task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.CONTINUOUS)) {
                this.cancelContinuousQueryOnIndex(task);
            }
            this.sendRequest(delete);
        }, delta, TimeUnit.MICROSECONDS);
    }

    private void cancelContinuousQueryOnIndex(QueryTask task) {
        QueryTask body = new QueryTask();
        body.documentSelfLink = task.documentSelfLink;
        body.taskInfo.stage = TaskState.TaskStage.CANCELLED;
        body.querySpec = task.querySpec;
        body.documentKind = task.documentKind;
        Operation cancelActiveQueryPatch = Operation.createPatch(this, task.indexLink).setBodyNoCloning(body);
        this.sendRequest(cancelActiveQueryPatch);
    }

    private void failTask(Throwable e, Operation directOp, Operation.CompletionHandler c) {
        QueryTask t = new QueryTask();
        t.taskInfo.stage = TaskState.TaskStage.FAILED;
        t.taskInfo.failure = Utils.toServiceErrorResponse(e);
        if (directOp != null) {
            directOp.setBody(t).fail(e);
            return;
        }
        this.sendRequest(Operation.createPatch(this.getUri()).setBody(t).setCompletion(c));
    }

    private boolean handleQueryRetry(QueryTask task, Operation directOp) {
        if (task.querySpec.expectedResultCount == null) {
            return false;
        }
        if (task.results.documentCount >= task.querySpec.expectedResultCount) {
            return false;
        }
        long exp = task.documentExpirationTimeMicros - this.getHost().getMaintenanceIntervalMicros();
        if (exp < Utils.getSystemNowMicrosUtc()) {
            this.failTask(new TimeoutException(), directOp, (o, e) -> this.scheduleTaskExpiration(task));
            return true;
        }
        this.getHost().scheduleCore(() -> this.forwardQueryToDocumentIndexService(task, directOp), this.getMaintenanceIntervalMicros(), TimeUnit.MICROSECONDS);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueryCompletion(QueryTask task, Throwable e, Operation directOp) {
        boolean scheduleExpiration = true;
        try {
            task.querySpec.context.nativeQuery = null;
            if (e != null) {
                this.failTask(e, directOp, null);
                return;
            }
            if (this.handleQueryRetry(task, directOp)) {
                scheduleExpiration = false;
                return;
            }
            if (task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.CONTINUOUS)) {
                task.taskInfo.stage = TaskState.TaskStage.STARTED;
            } else {
                this.results = task.results;
                task.taskInfo.stage = TaskState.TaskStage.FINISHED;
                task.taskInfo.durationMicros = task.results.queryTimeMicros;
            }
            if (task.documentOwner == null) {
                task.documentOwner = this.getHost().getId();
            }
            boolean bl = scheduleExpiration = !task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_LINKS);
            if (directOp != null) {
                this.resetQuerySpecNativeContext(task);
                if (!task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_LINKS)) {
                    directOp.setBodyNoCloning(task).complete();
                    return;
                }
                directOp.nestCompletion((o, ex) -> {
                    directOp.setStatusCode(o.getStatusCode()).setBodyNoCloning(o.getBodyRaw()).complete();
                    this.scheduleTaskExpiration(task);
                });
                QueryTaskUtils.expandLinks(this.getHost(), task, directOp);
            } else {
                if (!task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.EXPAND_LINKS)) {
                    this.sendRequest(Operation.createPatch(this.getUri()).setBodyNoCloning(task));
                    return;
                }
                Operation.CompletionHandler c = (o, ex) -> {
                    this.scheduleTaskExpiration(task);
                    if (ex != null) {
                        this.failTask(ex, null, null);
                        return;
                    }
                    this.sendRequest(Operation.createPatch(this.getUri()).setBodyNoCloning(task));
                };
                Operation dummyOp = Operation.createGet(this.getHost().getUri()).setCompletion(c).setReferer(this.getUri());
                QueryTaskUtils.expandLinks(this.getHost(), task, dummyOp);
            }
        }
        finally {
            if (scheduleExpiration) {
                this.scheduleTaskExpiration(task);
            }
        }
    }

    @Override
    public ServiceDocument getDocumentTemplate() {
        ServiceDocument td = super.getDocumentTemplate();
        QueryTask template = (QueryTask)td;
        QueryTask.QuerySpecification q = new QueryTask.QuerySpecification();
        QueryTask.Query kindClause = new QueryTask.Query().setTermPropertyName("documentKind").setTermMatchValue(Utils.buildKind(ExampleService.ExampleServiceState.class));
        QueryTask.Query nameClause = new QueryTask.Query();
        nameClause.setTermPropertyName("name").setTermMatchValue("query-target").setTermMatchType(QueryTask.QueryTerm.MatchType.PHRASE);
        q.query.addBooleanClause(kindClause).addBooleanClause(nameClause);
        template.querySpec = q;
        QueryTask exampleTask = new QueryTask();
        template.indexLink = exampleTask.indexLink;
        return template;
    }
}

