/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.Utils;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class NodeGroupBroadcastResult {
    public long availableNodeCount;
    public long unavailableNodeCount;
    public long totalNodeCount;
    public long membershipQuorum;
    public Set<PeerNodeResult> allResponses = new HashSet<PeerNodeResult>();
    public Set<PeerNodeResult> successResponses = new HashSet<PeerNodeResult>();
    public Set<PeerNodeResult> failureResponses = new HashSet<PeerNodeResult>();
    public Set<ServiceErrorResponse> failureErrorResponses = new HashSet<ServiceErrorResponse>();

    public boolean hasSuccess() {
        return !this.successResponses.isEmpty();
    }

    public boolean hasFailure() {
        return !this.failureResponses.isEmpty();
    }

    public boolean isMajoritySuccess() {
        return this.membershipQuorum <= (long)this.successResponses.size();
    }

    public boolean isMajorityFailure() {
        return this.membershipQuorum <= (long)this.failureResponses.size();
    }

    public boolean isAllSuccess() {
        return this.failureResponses.isEmpty();
    }

    public boolean isAllFailure() {
        return this.successResponses.isEmpty();
    }

    public <T> Set<T> getSuccessesAs(Class<T> type) {
        return this.successResponses.stream().map(singleResponse -> singleResponse.castBodyTo(type)).collect(Collectors.toSet());
    }

    public static class PeerNodeResult {
        public URI requestUri;
        public String hostId;
        public URI nodeGroupUri;
        public String json;
        public ServiceErrorResponse errorResponse;

        public boolean isSuccess() {
            return this.json != null;
        }

        public boolean isFailure() {
            return this.errorResponse != null;
        }

        public <T> T castBodyTo(Class<T> bodyType) {
            return Utils.fromJson(this.json, bodyType);
        }
    }
}

