/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.services.common.QueryTask;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

final class LuceneQueryConverter {
    private LuceneQueryConverter() {
    }

    static Query convertToLuceneQuery(QueryTask.Query query, QueryTask.QuerySpecification.QueryRuntimeContext context) {
        if (query.occurance == null) {
            query.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
        }
        if (query.booleanClauses != null) {
            if (query.term != null) {
                throw new IllegalArgumentException("term and booleanClauses are mutually exclusive");
            }
            return LuceneQueryConverter.convertToLuceneBooleanQuery(query, context);
        }
        if (query.term == null) {
            throw new IllegalArgumentException("One of term, booleanClauses must be provided");
        }
        QueryTask.QueryTerm term = query.term;
        LuceneQueryConverter.validateTerm(term);
        if (term.matchType == null) {
            term.matchType = QueryTask.QueryTerm.MatchType.TERM;
        }
        if (context != null && query.occurance != QueryTask.Query.Occurance.MUST_NOT_OCCUR && "documentKind".equals(term.propertyName)) {
            if (context.kindScope == null) {
                context.kindScope = new HashSet<String>();
            }
            context.kindScope.add(term.matchValue);
        }
        if (query.term.range != null) {
            return LuceneQueryConverter.convertToLuceneNumericRangeQuery(query);
        }
        if (query.term.matchType == QueryTask.QueryTerm.MatchType.WILDCARD) {
            return LuceneQueryConverter.convertToLuceneWildcardTermQuery(query);
        }
        if (query.term.matchType == QueryTask.QueryTerm.MatchType.PHRASE) {
            return LuceneQueryConverter.convertToLucenePhraseQuery(query);
        }
        if (query.term.matchType == QueryTask.QueryTerm.MatchType.PREFIX) {
            return LuceneQueryConverter.convertToLucenePrefixQuery(query);
        }
        return LuceneQueryConverter.convertToLuceneSingleTermQuery(query);
    }

    static Query convertToLuceneSingleTermQuery(QueryTask.Query query) {
        return new TermQuery(LuceneQueryConverter.convertToLuceneTerm(query.term));
    }

    static Query convertToLucenePhraseQuery(QueryTask.Query query) {
        String[] tokens = query.term.matchValue.split("\\W");
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        for (String token : tokens) {
            builder.add(new Term(query.term.propertyName, token));
        }
        return builder.build();
    }

    static Query convertToLucenePrefixQuery(QueryTask.Query query) {
        return new PrefixQuery(LuceneQueryConverter.convertToLuceneTerm(query.term));
    }

    static Query convertToLuceneWildcardTermQuery(QueryTask.Query query) {
        return new WildcardQuery(LuceneQueryConverter.convertToLuceneTerm(query.term));
    }

    static Query convertToLuceneNumericRangeQuery(QueryTask.Query query) {
        QueryTask.QueryTerm term = query.term;
        term.range.validate();
        if (term.range.type == ServiceDocumentDescription.TypeName.LONG) {
            return LuceneQueryConverter.createLongRangeQuery(term.propertyName, term.range);
        }
        if (term.range.type == ServiceDocumentDescription.TypeName.DOUBLE) {
            return LuceneQueryConverter.createDoubleRangeQuery(term.propertyName, term.range);
        }
        if (term.range.type == ServiceDocumentDescription.TypeName.DATE) {
            return LuceneQueryConverter.createLongRangeQuery(term.propertyName, term.range);
        }
        throw new IllegalArgumentException("Type is not supported:" + (Object)((Object)term.range.type));
    }

    static Query convertToLuceneBooleanQuery(QueryTask.Query query, QueryTask.QuerySpecification.QueryRuntimeContext context) {
        BooleanQuery.Builder parentQuery = new BooleanQuery.Builder();
        for (QueryTask.Query q : query.booleanClauses) {
            LuceneQueryConverter.buildBooleanQuery(parentQuery, q, context);
        }
        return parentQuery.build();
    }

    static void buildBooleanQuery(BooleanQuery.Builder parent, QueryTask.Query clause, QueryTask.QuerySpecification.QueryRuntimeContext context) {
        Query lq = LuceneQueryConverter.convertToLuceneQuery(clause, context);
        BooleanClause bc = new BooleanClause(lq, LuceneQueryConverter.convertToLuceneOccur(clause.occurance));
        parent.add(bc);
    }

    static BooleanClause.Occur convertToLuceneOccur(QueryTask.Query.Occurance occurance) {
        if (occurance == null) {
            return BooleanClause.Occur.MUST;
        }
        switch (occurance) {
            case MUST_NOT_OCCUR: {
                return BooleanClause.Occur.MUST_NOT;
            }
            case MUST_OCCUR: {
                return BooleanClause.Occur.MUST;
            }
            case SHOULD_OCCUR: {
                return BooleanClause.Occur.SHOULD;
            }
        }
        return BooleanClause.Occur.MUST;
    }

    static Term convertToLuceneTerm(QueryTask.QueryTerm term) {
        return new Term(term.propertyName, term.matchValue);
    }

    static void validateTerm(QueryTask.QueryTerm term) {
        if (term.range == null && term.matchValue == null) {
            throw new IllegalArgumentException("One of term.matchValue, term.range is required");
        }
        if (term.range != null && term.matchValue != null) {
            throw new IllegalArgumentException("term.matchValue and term.range are exclusive of each other");
        }
        if (term.propertyName == null) {
            throw new IllegalArgumentException("term.propertyName is required");
        }
    }

    static SortField.Type convertToLuceneType(ServiceDocumentDescription.TypeName typeName) {
        if (typeName == null) {
            return SortField.Type.STRING;
        }
        switch (typeName) {
            case STRING: {
                return SortField.Type.STRING;
            }
            case DOUBLE: {
                return SortField.Type.DOUBLE;
            }
            case LONG: {
                return SortField.Type.LONG;
            }
        }
        return SortField.Type.STRING;
    }

    static Sort convertToLuceneSort(QueryTask.QuerySpecification querySpecification, boolean isGroupSort) {
        List<QueryTask.QueryTerm> additionalSortTerms;
        QueryTask.QuerySpecification.SortOrder sortOrder;
        QueryTask.QueryTerm sortTerm = isGroupSort ? querySpecification.groupSortTerm : querySpecification.sortTerm;
        QueryTask.QuerySpecification.SortOrder sortOrder2 = sortOrder = isGroupSort ? querySpecification.groupSortOrder : querySpecification.sortOrder;
        if (querySpecification.options.contains((Object)QueryTask.QuerySpecification.QueryOption.TOP_RESULTS) && (querySpecification.resultLimit <= 0 || querySpecification.resultLimit == Integer.MAX_VALUE)) {
            throw new IllegalArgumentException("resultLimit should be a positive integer less than MAX_VALUE");
        }
        if (sortOrder == null) {
            if (isGroupSort) {
                querySpecification.groupSortOrder = QueryTask.QuerySpecification.SortOrder.ASC;
            } else {
                querySpecification.sortOrder = QueryTask.QuerySpecification.SortOrder.ASC;
            }
        }
        sortTerm.sortOrder = sortOrder;
        List<QueryTask.QueryTerm> list = additionalSortTerms = isGroupSort ? querySpecification.additionalGroupSortTerms : querySpecification.additionalSortTerms;
        if (additionalSortTerms == null) {
            return new Sort(LuceneQueryConverter.convertToLuceneSortField(sortTerm));
        }
        SortField[] sortFields = new SortField[additionalSortTerms.size() + 1];
        sortFields[0] = LuceneQueryConverter.convertToLuceneSortField(sortTerm);
        for (int index = 1; index < sortFields.length; ++index) {
            sortFields[index] = LuceneQueryConverter.convertToLuceneSortField(additionalSortTerms.get(index - 1));
        }
        return new Sort(sortFields);
    }

    private static SortField convertToLuceneSortField(QueryTask.QueryTerm sortTerm) {
        SortedNumericSortField sortField;
        LuceneQueryConverter.validateSortTerm(sortTerm);
        if (sortTerm.sortOrder == null) {
            sortTerm.sortOrder = QueryTask.QuerySpecification.SortOrder.ASC;
        }
        boolean order = sortTerm.sortOrder != QueryTask.QuerySpecification.SortOrder.ASC;
        SortField.Type type = LuceneQueryConverter.convertToLuceneType(sortTerm.propertyType);
        switch (type) {
            case LONG: 
            case DOUBLE: {
                sortField = new SortedNumericSortField(sortTerm.propertyName, type, order);
                break;
            }
            default: {
                sortField = new SortField(sortTerm.propertyName, type, order);
            }
        }
        return sortField;
    }

    static void validateSortTerm(QueryTask.QueryTerm term) {
        if (term.propertyType == null) {
            throw new IllegalArgumentException("term.propertyType is required");
        }
        if (term.propertyName == null) {
            throw new IllegalArgumentException("term.propertyName is required");
        }
    }

    private static Query createLongRangeQuery(String propertyName, QueryTask.NumericRange<?> range) {
        Long min = range.min == null ? Long.MIN_VALUE : ((Number)range.min).longValue();
        Long max = range.max == null ? Long.MAX_VALUE : ((Number)range.max).longValue();
        if (!range.isMinInclusive) {
            min = Math.addExact(min, 1L);
        }
        if (!range.isMaxInclusive) {
            max = Math.addExact(max, -1L);
        }
        return LongPoint.newRangeQuery((String)propertyName, (long)min, (long)max);
    }

    private static Query createDoubleRangeQuery(String propertyName, QueryTask.NumericRange<?> range) {
        Double min = range.min == null ? Double.NEGATIVE_INFINITY : ((Number)range.min).doubleValue();
        Double max = range.max == null ? Double.POSITIVE_INFINITY : ((Number)range.max).doubleValue();
        if (!range.isMinInclusive) {
            min = Math.nextUp(min);
        }
        if (!range.isMaxInclusive) {
            max = Math.nextDown(max);
        }
        return DoublePoint.newRangeQuery((String)propertyName, (double)min, (double)max);
    }
}

