/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FileUtils;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.Utils;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;

public class LocalFileService
extends StatefulService {
    public static final String SERVICE_PREFIX = "/local-files";

    public LocalFileService() {
        super(LocalFileServiceState.class);
    }

    @Override
    public void handleStart(Operation start) {
        if (!start.hasBody()) {
            start.fail(new IllegalStateException("no body given"));
            return;
        }
        LocalFileServiceState state = start.getBody(LocalFileServiceState.class);
        if (state.localFileUri == null) {
            start.fail(new IllegalStateException("file scheme uri is required"));
            return;
        }
        start.complete();
    }

    @Override
    public void handlePut(final Operation put) {
        AsynchronousFileChannel channel;
        Path localFilePath;
        if (!put.hasBody()) {
            put.fail(new IllegalStateException("no data to write"));
            return;
        }
        LocalFileServiceState state = (LocalFileServiceState)this.getState(put);
        if (state.writeFinished) {
            put.fail(new IllegalStateException("writeFinished is set to true"));
            return;
        }
        if (!"file".equals(state.localFileUri.getScheme())) {
            put.fail(new IllegalStateException("file scheme uri is required"));
            return;
        }
        try {
            localFilePath = Paths.get(state.localFileUri);
        }
        catch (Exception e) {
            put.fail(e);
            return;
        }
        final Path path = localFilePath;
        String rangeString = put.getRequestHeader("content-range");
        try {
            channel = AsynchronousFileChannel.open(path, state.fileOptions, null, new FileAttribute[0]);
        }
        catch (IOException e) {
            put.fail(e);
            return;
        }
        try {
            final FileUtils.ContentRange r = new FileUtils.ContentRange(rangeString);
            ByteBuffer b = ByteBuffer.wrap((byte[])put.getBodyRaw());
            channel.write(b, r.start, put, new CompletionHandler<Integer, Operation>(){

                @Override
                public void completed(Integer bytesWritten, Operation op) {
                    try {
                        channel.close();
                        LocalFileService.this.logInfo("%s complete (bytes:%d range:%s-%s md5:%s)", path, bytesWritten, r.start, r.end, FileUtils.md5sum(path.toFile()));
                    }
                    catch (Exception e) {
                        put.fail(e);
                        return;
                    }
                    put.complete();
                }

                @Override
                public void failed(Throwable ex, Operation op) {
                    LocalFileService.this.logWarning("Backup Failed %s", Utils.toString(ex));
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    put.fail(ex);
                }
            });
        }
        catch (Exception e) {
            put.fail(e);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handleGet(final Operation get) {
        AsynchronousFileChannel channel;
        Path localFilePath;
        String rangeHeader = get.getRequestHeader("range");
        if (rangeHeader == null) {
            super.handleGet(get);
            return;
        }
        LocalFileServiceState state = (LocalFileServiceState)this.getState(get);
        if (!"file".equals(state.localFileUri.getScheme())) {
            get.fail(new IllegalStateException("file scheme uri is required"));
            return;
        }
        try {
            localFilePath = Paths.get(state.localFileUri);
        }
        catch (Exception e) {
            get.fail(e);
            return;
        }
        Path path = localFilePath;
        try {
            channel = AsynchronousFileChannel.open(path, StandardOpenOption.READ);
        }
        catch (Exception e) {
            get.fail(e);
            return;
        }
        try {
            FileUtils.ContentRange r = FileUtils.ContentRange.fromRangeHeader(rangeHeader, path.toFile().length());
            String contentRangeHeader = r.toContentRangeHeader();
            int idx = contentRangeHeader.indexOf(":");
            String name = contentRangeHeader.substring(0, idx);
            String value = contentRangeHeader.substring(idx + 1);
            get.addResponseHeader(name, value);
            final String contentType = FileUtils.getContentType(path.toUri());
            final ByteBuffer b = ByteBuffer.allocate((int)(r.end - r.start));
            channel.read(b, r.start, null, new CompletionHandler<Integer, Void>(){

                @Override
                public void completed(Integer result, Void v) {
                    if (contentType != null) {
                        get.setContentType(contentType);
                    }
                    b.flip();
                    get.setContentLength(b.limit());
                    get.setBodyNoCloning(b.array());
                    try {
                        channel.close();
                    }
                    catch (Exception e) {
                        get.fail(e);
                        return;
                    }
                    get.complete();
                }

                @Override
                public void failed(Throwable exe, Void v) {
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    get.fail(exe);
                }
            });
        }
        catch (Exception e) {
            get.fail(e);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handlePatch(Operation patch) {
        LocalFileServiceState currentTask = (LocalFileServiceState)this.getState(patch);
        LocalFileServiceState patchBody = (LocalFileServiceState)this.getBody(patch);
        Utils.mergeWithState(this.getStateDescription(), currentTask, patchBody);
        patch.complete();
    }

    public static class LocalFileServiceState
    extends ServiceDocument {
        public URI localFileUri;
        public Set<StandardOpenOption> fileOptions = new HashSet<StandardOpenOption>();
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public boolean writeFinished;
    }
}

