/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.GraphQueryTask;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.TaskService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class GraphQueryTaskService
extends TaskService<GraphQueryTask> {
    public static final String FACTORY_LINK = ServiceUriPaths.CORE_GRAPH_QUERIES;

    public GraphQueryTaskService() {
        super(GraphQueryTask.class);
        this.toggleOption(Service.ServiceOption.REPLICATION, true);
        this.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation post) {
        GraphQueryTask initialState = this.validateStartPost(post);
        if (initialState == null) {
            return;
        }
        this.initializeState(initialState, post);
        initialState.taskInfo.stage = TaskState.TaskStage.CREATED;
        post.setBody(initialState).setStatusCode(202).complete();
        this.sendSelfPatch(initialState, TaskState.TaskStage.STARTED, null);
    }

    @Override
    protected GraphQueryTask validateStartPost(Operation taskOperation) {
        GraphQueryTask task = (GraphQueryTask)super.validateStartPost(taskOperation);
        if (task == null) {
            return null;
        }
        if (!ServiceHost.isServiceCreate(taskOperation)) {
            return task;
        }
        if (task.currentDepth > 0) {
            taskOperation.fail(new IllegalArgumentException("Do not specify currentDepth: internal use only"));
            return null;
        }
        if (task.depthLimit < 2) {
            taskOperation.fail(new IllegalArgumentException("depthLimit must be a positive integer greater than one"));
            return null;
        }
        if (task.stages == null || task.stages.isEmpty()) {
            taskOperation.fail(new IllegalArgumentException("At least one stage is required"));
            return null;
        }
        if (task.stages.size() != task.depthLimit) {
            taskOperation.fail(new IllegalArgumentException("Number of stages must match depthLimit"));
            return null;
        }
        for (int i = 0; i < task.stages.size(); ++i) {
            QueryTask stage = task.stages.get(i);
            if (stage.querySpec == null || stage.querySpec.query == null) {
                taskOperation.fail(new IllegalArgumentException("Stage query specification is invalid: " + Utils.toJson(stage)));
                return null;
            }
            if (i != 0 || stage.results == null) {
                if (stage.querySpec.resultLimit == null) continue;
                taskOperation.fail(new IllegalArgumentException("Stage query specification resultLimit must be null: " + Utils.toJson(stage)));
                return null;
            }
            if (stage.results.nextPageLink == null && !GraphQueryTaskService.hasInlineResults(stage.results)) {
                taskOperation.fail(new IllegalArgumentException("First stage has results instance but no actual results: " + Utils.toJson(stage)));
                return null;
            }
            if (stage.results.nextPageLink != null && !stage.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.SELECT_LINKS)) {
                taskOperation.fail(new IllegalArgumentException("First stage has paginated results but does not specify option " + (Object)((Object)QueryTask.QuerySpecification.QueryOption.SELECT_LINKS) + " :" + Utils.toJson(stage)));
                return null;
            }
            if (stage.documentSelfLink != null) continue;
            taskOperation.fail(new IllegalArgumentException("First stage with results must have valid self link: " + Utils.toJson(stage)));
            return null;
        }
        return task;
    }

    @Override
    protected void initializeState(GraphQueryTask task, Operation taskOperation) {
        task.currentDepth = 0;
        task.resultLinks.clear();
        for (int i = 0; i < task.stages.size(); ++i) {
            QueryTask stageQueryTask = task.stages.get(i);
            stageQueryTask.taskInfo = new TaskState();
            stageQueryTask.taskInfo.isDirect = true;
            if (i < task.stages.size() - 1) {
                stageQueryTask.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.SELECT_LINKS);
            }
            if (task.tenantLinks != null && stageQueryTask.tenantLinks == null) {
                stageQueryTask.tenantLinks = new ArrayList<String>(task.tenantLinks);
            }
            if (i == 0) {
                if (GraphQueryTaskService.hasInlineResults(stageQueryTask.results)) {
                    this.logInfo("First stage has %d (page:%s) results, skipping query, moving to next stage", stageQueryTask.results.documentCount, stageQueryTask.results.nextPageLink);
                    task.resultLinks.add(stageQueryTask.documentSelfLink);
                    task.currentDepth = 1;
                    continue;
                }
                if (stageQueryTask.results == null) continue;
                this.logInfo("First stage result link %s, bypassing query execution will fetch results", stageQueryTask.results.nextPageLink);
                continue;
            }
            stageQueryTask.results = null;
        }
        super.initializeState(task, taskOperation);
    }

    @Override
    public void handlePatch(Operation patch) {
        GraphQueryTask body;
        GraphQueryTask currentState = (GraphQueryTask)this.getState(patch);
        if (!this.validateTransition(patch, currentState, body = (GraphQueryTask)this.getBody(patch))) {
            return;
        }
        this.updateState(currentState, body);
        patch.complete();
        switch (body.taskInfo.stage) {
            case STARTED: {
                this.startOrContinueGraphQuery(currentState);
                break;
            }
            case CANCELLED: {
                this.logInfo("Task canceled: not implemented, ignoring", new Object[0]);
                break;
            }
            case FINISHED: {
                this.logFine("Task finished successfully", new Object[0]);
                break;
            }
            case FAILED: {
                this.logWarning("Task failed: %s", body.failureMessage == null ? "No reason given" : body.failureMessage);
                break;
            }
        }
    }

    @Override
    protected void updateState(GraphQueryTask task, GraphQueryTask patchBody) {
        super.updateState(task, patchBody);
        task.stages = patchBody.stages;
        task.resultLinks = patchBody.resultLinks;
    }

    @Override
    protected boolean validateTransition(Operation patch, GraphQueryTask currentState, GraphQueryTask patchBody) {
        if (patchBody.taskInfo == null) {
            patch.fail(new IllegalArgumentException("Missing taskInfo"));
            return false;
        }
        if (patchBody.taskInfo.stage == null) {
            patch.fail(new IllegalArgumentException("Missing stage"));
            return false;
        }
        if (patchBody.taskInfo.stage == TaskState.TaskStage.CREATED) {
            patch.fail(new IllegalArgumentException("Did not expect to receive CREATED stage"));
            return false;
        }
        if (patchBody.taskInfo.stage == TaskState.TaskStage.STARTED && patchBody.currentDepth > currentState.stages.size() - 1) {
            patch.fail(new IllegalStateException("new currentDepth is must be a valid stage index: " + currentState.currentDepth));
            return false;
        }
        if (patchBody.currentDepth < currentState.currentDepth) {
            patch.fail(new IllegalStateException("new currentDepth is less or equal to existing depth:" + currentState.currentDepth));
            return false;
        }
        if (patchBody.stages.size() != currentState.stages.size()) {
            patch.fail(new IllegalStateException("Query stages can not be modified after task is created"));
            return false;
        }
        return true;
    }

    private void startOrContinueGraphQuery(GraphQueryTask currentState) {
        int previousStageIndex = Math.max(currentState.currentDepth - 1, 0);
        ServiceDocumentQueryResult lastResults = currentState.stages.get((int)previousStageIndex).results;
        int traversalSpecIndex = Math.min(currentState.stages.size() - 1, currentState.currentDepth);
        QueryTask task = currentState.stages.get(traversalSpecIndex);
        task.documentExpirationTimeMicros = currentState.documentExpirationTimeMicros;
        this.scopeNextStageQueryToSelectedLinks(lastResults, task);
        Operation getResultsOrStartQueryOp = null;
        if (currentState.currentDepth == 0 && lastResults != null) {
            this.logInfo("Fetching initial stage results from %s", lastResults.nextPageLink);
            getResultsOrStartQueryOp = Operation.createGet(this, lastResults.nextPageLink).setCompletion((o, e) -> this.handleQueryPageGetCompletion(currentState, o, e));
        } else {
            getResultsOrStartQueryOp = Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBodyNoCloning(task).setConnectionSharing(true).setCompletion((o, e) -> this.handleQueryStageCompletion(currentState, o, e));
        }
        this.sendRequest(getResultsOrStartQueryOp);
    }

    private void scopeNextStageQueryToSelectedLinks(ServiceDocumentQueryResult lastResults, QueryTask task) {
        if (!GraphQueryTaskService.hasInlineResults(lastResults)) {
            return;
        }
        this.logFine("Setting whitelist to %d links", lastResults.selectedLinks.size());
        task.querySpec.context.documentLinkWhiteList = lastResults.selectedLinks;
    }

    private boolean checkAndPatchToFinished(GraphQueryTask currentState, ServiceDocumentQueryResult lastResults) {
        if (lastResults == null) {
            return false;
        }
        if (currentState.currentDepth > currentState.depthLimit - 1) {
            this.finishTask(currentState);
            return true;
        }
        if (lastResults.documentCount == null || lastResults.documentCount == 0L) {
            this.finishTask(currentState);
            return true;
        }
        if ((lastResults.selectedLinks == null || lastResults.selectedLinks.isEmpty()) && currentState.currentDepth < currentState.depthLimit - 1) {
            this.finishTask(currentState);
            return true;
        }
        return false;
    }

    private void finishTask(GraphQueryTask currentState) {
        if (currentState.options.contains((Object)GraphQueryTask.GraphQueryOption.FILTER_STAGE_RESULTS)) {
            this.applyFilterOnStageResults(currentState);
        }
        this.sendSelfPatch(currentState, TaskState.TaskStage.FINISHED, null);
    }

    private void applyFilterOnStageResults(GraphQueryTask currentState) {
        for (int i = currentState.stages.size() - 1; i >= 1; --i) {
            QueryTask currentStage = currentState.stages.get(i);
            QueryTask previousStage = currentState.stages.get(i - 1);
            if (currentStage.results == null || previousStage.results == null) break;
            HashSet unusedLinks = new HashSet();
            HashSet unusedDocumentLinks = new HashSet();
            previousStage.results.selectedLinksPerDocument.entrySet().forEach(e -> {
                String documentLink = (String)e.getKey();
                Map propertyNameToLink = (Map)e.getValue();
                int unusedLinkCount = 0;
                for (String link : propertyNameToLink.values()) {
                    if (currentStage.results.documentLinks.contains(link)) continue;
                    unusedLinks.add(link);
                    ++unusedLinkCount;
                }
                if (unusedLinkCount == propertyNameToLink.size()) {
                    unusedDocumentLinks.add(documentLink);
                }
            });
            if (previousStage.results.documents != null) {
                unusedDocumentLinks.forEach(l -> previousStage.results.documents.remove(l));
            }
            previousStage.results.documentLinks.removeAll(unusedDocumentLinks);
            previousStage.results.selectedLinks.removeAll(unusedLinks);
            unusedDocumentLinks.forEach(l -> previousStage.results.selectedLinksPerDocument.remove(l));
            previousStage.results.documentCount = previousStage.results.documentLinks.size();
        }
    }

    private void handleQueryPageGetCompletion(GraphQueryTask currentState, Operation o, Throwable e) {
        if (e != null) {
            this.handleQueryStageCompletion(currentState, o, e);
            return;
        }
        QueryTask response = o.getBody(QueryTask.class);
        if (response.results == null) {
            this.handleQueryStageCompletion(currentState, o, new IllegalStateException("No results found for page in first stage results"));
            return;
        }
        if (response.results.selectedLinks == null || response.results.selectedLinks.isEmpty()) {
            this.sendSelfFailurePatch(currentState, "Paginated first stage response had no selected link results: " + Utils.toJsonHtml(response));
            return;
        }
        this.handleQueryStageCompletion(currentState, o, null);
    }

    private void handleQueryStageCompletion(GraphQueryTask currentState, Operation o, Throwable e) {
        if (e != null) {
            this.sendSelfFailurePatch(currentState, e.toString());
            return;
        }
        QueryTask response = o.getBody(QueryTask.class);
        currentState.resultLinks.add(response.documentSelfLink);
        int traversalSpecIndex = Math.min(currentState.stages.size() - 1, currentState.currentDepth);
        QueryTask stage = currentState.stages.get(traversalSpecIndex);
        stage.results = response.results;
        stage.documentSelfLink = response.documentSelfLink;
        stage.documentOwner = response.documentOwner;
        ++currentState.currentDepth;
        if (this.checkAndPatchToFinished(currentState, response.results)) {
            return;
        }
        this.sendSelfPatch(currentState, TaskState.TaskStage.STARTED, null);
    }

    private static boolean hasInlineResults(ServiceDocumentQueryResult results) {
        return results != null && results.documentCount != null && results.documentCount > 0L && results.selectedLinks != null && !results.selectedLinks.isEmpty();
    }
}

