/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.ExampleService;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.TaskFactoryService;
import com.vmware.xenon.services.common.TaskService;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ExampleTaskService
extends TaskService<ExampleTaskServiceState> {
    private static long DEFAULT_TASK_LIFETIME = 60L;
    public static final String FACTORY_LINK = "/core/example-tasks";

    public static FactoryService createFactory() {
        return TaskFactoryService.create(ExampleTaskService.class, Service.ServiceOption.IDEMPOTENT_POST, Service.ServiceOption.INSTRUMENTATION);
    }

    public ExampleTaskService() {
        super(ExampleTaskServiceState.class);
        this.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        this.toggleOption(Service.ServiceOption.REPLICATION, true);
        this.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        this.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation post) {
        ExampleTaskServiceState initialState = this.validateStartPost(post);
        if (initialState == null) {
            return;
        }
        this.initializeState(initialState, post);
        post.setStatusCode(202).complete();
        this.sendSelfPatch(initialState, TaskState.TaskStage.STARTED, null);
    }

    @Override
    protected ExampleTaskServiceState validateStartPost(Operation taskOperation) {
        ExampleTaskServiceState task = (ExampleTaskServiceState)super.validateStartPost(taskOperation);
        if (task == null) {
            return null;
        }
        if (ServiceHost.isServiceCreate(taskOperation)) {
            if (task.subStage != null) {
                taskOperation.fail(new IllegalArgumentException("Do not specify subStage: internal use only"));
                return null;
            }
            if (task.exampleQueryTask != null) {
                taskOperation.fail(new IllegalArgumentException("Do not specify exampleQueryTask: internal use only"));
                return null;
            }
        } else if (!TaskState.isInProgress(task.taskInfo)) {
            taskOperation.complete();
            return null;
        }
        if (task.taskLifetime != null && task.taskLifetime <= 0L) {
            taskOperation.fail(new IllegalArgumentException("taskLifetime must be positive"));
            return null;
        }
        return task;
    }

    @Override
    protected void initializeState(ExampleTaskServiceState task, Operation taskOperation) {
        task.subStage = SubStage.QUERY_EXAMPLES;
        if (task.taskLifetime != null) {
            task.documentExpirationTimeMicros = Utils.fromNowMicrosUtc(TimeUnit.SECONDS.toMicros(task.taskLifetime));
        } else if (task.documentExpirationTimeMicros != 0L) {
            task.documentExpirationTimeMicros = Utils.fromNowMicrosUtc(TimeUnit.SECONDS.toMicros(DEFAULT_TASK_LIFETIME));
        }
        super.initializeState(task, taskOperation);
    }

    @Override
    public void handlePatch(Operation patch) {
        ExampleTaskServiceState patchBody;
        ExampleTaskServiceState currentTask = (ExampleTaskServiceState)this.getState(patch);
        if (!this.validateTransition(patch, currentTask, patchBody = (ExampleTaskServiceState)this.getBody(patch))) {
            return;
        }
        this.updateState(currentTask, patchBody);
        patch.complete();
        switch (patchBody.taskInfo.stage) {
            case CREATED: {
                break;
            }
            case STARTED: {
                this.handleSubstage(patchBody);
                break;
            }
            case CANCELLED: {
                this.logInfo("Task canceled: not implemented, ignoring", new Object[0]);
                break;
            }
            case FINISHED: {
                this.logFine("Task finished successfully", new Object[0]);
                break;
            }
            case FAILED: {
                this.logWarning("Task failed: %s", patchBody.failureMessage == null ? "No reason given" : patchBody.failureMessage);
                break;
            }
            default: {
                this.logWarning("Unexpected stage: %s", new Object[]{patchBody.taskInfo.stage});
            }
        }
    }

    private void handleSubstage(ExampleTaskServiceState task) {
        switch (task.subStage) {
            case QUERY_EXAMPLES: {
                this.handleQueryExamples(task);
                break;
            }
            case DELETE_EXAMPLES: {
                this.handleDeleteExamples(task);
                break;
            }
            default: {
                this.logWarning("Unexpected sub stage: %s", new Object[]{task.subStage});
            }
        }
    }

    @Override
    protected boolean validateTransition(Operation patch, ExampleTaskServiceState currentTask, ExampleTaskServiceState patchBody) {
        super.validateTransition(patch, currentTask, patchBody);
        if (patchBody.taskInfo.stage == TaskState.TaskStage.STARTED && patchBody.subStage == null) {
            patch.fail(new IllegalArgumentException("Missing substage"));
            return false;
        }
        if (currentTask.taskInfo != null && currentTask.taskInfo.stage != null && currentTask.taskInfo.stage == TaskState.TaskStage.STARTED && patchBody.taskInfo.stage == TaskState.TaskStage.STARTED && currentTask.subStage.ordinal() > patchBody.subStage.ordinal()) {
            patch.fail(new IllegalArgumentException("Task substage cannot move backwards"));
            return false;
        }
        return true;
    }

    private void handleQueryExamples(ExampleTaskServiceState task) {
        QueryTask.Query.Builder builder = QueryTask.Query.Builder.create().addKindFieldClause(ExampleService.ExampleServiceState.class);
        if (task.customQueryClause != null) {
            builder.addClause(task.customQueryClause);
        }
        QueryTask.Query exampleDocumentQuery = builder.build();
        task.exampleQueryTask = QueryTask.Builder.createDirectTask().setQuery(exampleDocumentQuery).build();
        URI queryTaskUri = UriUtils.buildUri(this.getHost(), ServiceUriPaths.CORE_QUERY_TASKS);
        Operation queryRequest = Operation.createPost(queryTaskUri).setBody(task.exampleQueryTask).setCompletion((op, ex) -> {
            if (ex != null) {
                this.logWarning("Query failed, task will not finish: %s", ex.getMessage());
                return;
            }
            task.exampleQueryTask = op.getBody(QueryTask.class);
            this.sendSelfPatch(task, TaskState.TaskStage.STARTED, this.subStageSetter(SubStage.DELETE_EXAMPLES));
        });
        this.sendRequest(queryRequest);
    }

    private void handleDeleteExamples(ExampleTaskServiceState task) {
        if (task.exampleQueryTask.results == null) {
            this.sendSelfFailurePatch(task, "Query task service returned null results");
            return;
        }
        if (task.exampleQueryTask.results.documentLinks == null) {
            this.sendSelfFailurePatch(task, "Query task service returned null documentLinks");
            return;
        }
        if (task.exampleQueryTask.results.documentLinks.size() == 0) {
            this.logFine("No example service documents found, nothing to do", new Object[0]);
            this.sendSelfPatch(task, TaskState.TaskStage.FINISHED, null);
            return;
        }
        ArrayList<Operation> deleteOperations = new ArrayList<Operation>();
        for (String exampleService : task.exampleQueryTask.results.documentLinks) {
            URI exampleServiceUri = UriUtils.buildUri(this.getHost(), exampleService);
            Operation deleteOp = Operation.createDelete(exampleServiceUri);
            deleteOperations.add(deleteOp);
        }
        OperationJoin operationJoin = OperationJoin.create();
        operationJoin.setOperations(deleteOperations).setCompletion((ops, exs) -> {
            if (exs != null && !exs.isEmpty()) {
                this.sendSelfFailurePatch(task, String.format("%d deletes failed", exs.size()));
                return;
            }
            this.sendSelfPatch(task, TaskState.TaskStage.FINISHED, null);
        }).sendWith(this);
    }

    private Consumer<ExampleTaskServiceState> subStageSetter(SubStage subStage) {
        return taskState -> {
            taskState.subStage = subStage;
        };
    }

    public static class ExampleTaskServiceState
    extends TaskService.TaskServiceState {
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public Long taskLifetime;
        @ServiceDocument.UsageOption(option=ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL)
        public SubStage subStage;
        @ServiceDocument.PropertyOptions(usage={ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL, ServiceDocumentDescription.PropertyUsageOption.SERVICE_USE})
        public QueryTask exampleQueryTask;
        @ServiceDocument.PropertyOptions(usage={ServiceDocumentDescription.PropertyUsageOption.OPTIONAL})
        public QueryTask.Query customQueryClause;
    }

    public static enum SubStage {
        QUERY_EXAMPLES,
        DELETE_EXAMPLES;

    }
}

