/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import com.esotericsoftware.kryo.serializers.VersionFieldSerializer;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.serialization.BufferThreadLocal;
import com.vmware.xenon.common.serialization.ByteBufferSerializer;
import com.vmware.xenon.common.serialization.FieldNullifyingVersionFieldSerializer;
import com.vmware.xenon.common.serialization.InstantSerializer;
import com.vmware.xenon.common.serialization.OutputWithRoot;
import com.vmware.xenon.common.serialization.URISerializer;
import com.vmware.xenon.common.serialization.UUIDSerializer;
import com.vmware.xenon.common.serialization.ZoneIdSerializer;
import com.vmware.xenon.common.serialization.ZonedDateTimeSerializer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public final class KryoSerializers {
    private static final String PROPERTY_KRYO_HANDLE_BUILTIN_COLLECTIONS = "xenon.kryo.handleBuiltInCollections";
    private static boolean KRYO_HANDLE_BUILTIN_COLLECTIONS = true;
    private static final ThreadLocal<Kryo> kryoForObjectPerThread;
    private static final ThreadLocal<Kryo> kryoForDocumentPerThread;
    private static ThreadLocal<Kryo> kryoForObjectPerThreadCustom;
    private static ThreadLocal<Kryo> kryoForDocumentPerThreadCustom;
    public static final long THREAD_LOCAL_BUFFER_LIMIT_BYTES = 0x100000L;
    private static final int DEFAULT_BUFFER_SIZE_BYTES = 4096;
    private static final BufferThreadLocal bufferPerThread;

    private KryoSerializers() {
    }

    public static Kryo create(boolean isObjectSerializer) {
        Kryo k = new Kryo();
        k.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        k.setDefaultSerializer(VersionFieldSerializer.class);
        k.addDefaultSerializer(ZonedDateTime.class, (Serializer)ZonedDateTimeSerializer.INSTANCE);
        k.addDefaultSerializer(Instant.class, (Serializer)InstantSerializer.INSTANCE);
        k.addDefaultSerializer(ZoneId.class, (Serializer)ZoneIdSerializer.INSTANCE);
        k.addDefaultSerializer(UUID.class, (Serializer)UUIDSerializer.INSTANCE);
        k.addDefaultSerializer(URI.class, (Serializer)URISerializer.INSTANCE);
        k.addDefaultSerializer(ByteBuffer.class, ByteBufferSerializer.INSTANCE);
        if (KRYO_HANDLE_BUILTIN_COLLECTIONS) {
            KryoSerializers.configureJdkCollections(k);
        }
        if (!isObjectSerializer) {
            k.setReferences(false);
            k.setCopyReferences(false);
            k.setDefaultSerializer(FieldNullifyingVersionFieldSerializer.class);
        } else {
            k.setAutoReset(true);
        }
        return k;
    }

    private static void configureJdkCollections(Kryo kryo) {
        CollectionSerializer emptyOrSingletonSerializer = new CollectionSerializer(){

            protected Collection<?> create(Kryo kryo, Input input, Class<Collection> type) {
                return this.newCollection(type);
            }

            private Collection<?> newCollection(Class<Collection> origType) {
                if (NavigableSet.class.isAssignableFrom(origType)) {
                    return new TreeSet();
                }
                if (Set.class.isAssignableFrom(origType)) {
                    return new HashSet();
                }
                return new ArrayList(1);
            }

            protected Collection<?> createCopy(Kryo kryo, Collection original) {
                return this.newCollection(original.getClass());
            }
        };
        MapSerializer emptyOrSingletonMapSerializer = new MapSerializer(){

            protected Map<?, ?> create(Kryo kryo, Input input, Class<Map> type) {
                return this.newMap(type);
            }

            private Map<?, ?> newMap(Class<Map> origType) {
                if (NavigableMap.class.isAssignableFrom(origType)) {
                    return new TreeMap();
                }
                return new HashMap();
            }

            protected Map<?, ?> createCopy(Kryo kryo, Map original) {
                return this.newMap(original.getClass());
            }
        };
        kryo.addDefaultSerializer(Collections.EMPTY_LIST.getClass(), (Serializer)emptyOrSingletonSerializer);
        kryo.addDefaultSerializer(Collections.EMPTY_SET.getClass(), (Serializer)emptyOrSingletonSerializer);
        kryo.addDefaultSerializer(Collections.emptyNavigableSet().getClass(), (Serializer)emptyOrSingletonSerializer);
        kryo.addDefaultSerializer(Collections.EMPTY_MAP.getClass(), (Serializer)emptyOrSingletonMapSerializer);
        kryo.addDefaultSerializer(Collections.emptyNavigableMap().getClass(), (Serializer)emptyOrSingletonMapSerializer);
        kryo.addDefaultSerializer(Arrays.asList(new Object[0]).getClass(), (Serializer)emptyOrSingletonSerializer);
        kryo.addDefaultSerializer(Collections.singleton(kryo).getClass(), (Serializer)emptyOrSingletonSerializer);
        kryo.addDefaultSerializer(Collections.singletonList(kryo).getClass(), (Serializer)emptyOrSingletonSerializer);
        kryo.addDefaultSerializer(Collections.singletonMap("", kryo).getClass(), (Serializer)emptyOrSingletonMapSerializer);
    }

    public static void register(ThreadLocal<Kryo> kryoThreadLocal, boolean isDocumentSerializer) {
        if (isDocumentSerializer) {
            kryoForDocumentPerThreadCustom = kryoThreadLocal;
        } else {
            kryoForObjectPerThreadCustom = kryoThreadLocal;
        }
    }

    private static Kryo getKryoThreadLocalForDocuments() {
        ThreadLocal<Kryo> tl = kryoForDocumentPerThreadCustom;
        if (tl == null) {
            tl = kryoForDocumentPerThread;
        }
        return tl.get();
    }

    private static Kryo getKryoThreadLocalForObjects() {
        ThreadLocal<Kryo> tl = kryoForObjectPerThreadCustom;
        if (tl == null) {
            tl = kryoForObjectPerThread;
        }
        return tl.get();
    }

    public static Output serializeDocument(ServiceDocument o, int maxSize) {
        return KryoSerializers.serializeAsDocument(o, maxSize);
    }

    public static Output serializeAsDocument(Object o, int maxSize) {
        Kryo k = KryoSerializers.getKryoThreadLocalForDocuments();
        Output out = new Output(KryoSerializers.getBuffer(4096), maxSize);
        k.writeClassAndObject(out, o);
        return out;
    }

    public static Output serializeDocumentForIndexing(Object o, int maxSize) {
        Kryo k = KryoSerializers.getKryoThreadLocalForDocuments();
        byte[] buffer = KryoSerializers.getBuffer(4096);
        OutputWithRoot out = new OutputWithRoot(buffer, maxSize, o);
        k.writeClassAndObject((Output)out, o);
        return out;
    }

    public static int serializeObject(Object o, byte[] buffer, int position) {
        Kryo k = KryoSerializers.getKryoThreadLocalForObjects();
        Output out = new Output(buffer, buffer.length);
        out.setPosition(position);
        k.writeClassAndObject(out, o);
        return out.position();
    }

    public static ByteBuffer serializeObject(Object o, int maxSize) {
        Kryo k = KryoSerializers.getKryoThreadLocalForObjects();
        Output out = new Output(4096, maxSize);
        k.writeClassAndObject(out, o);
        return ByteBuffer.wrap(out.getBuffer(), 0, out.position());
    }

    public static <T> T clone(T t) {
        Kryo k = KryoSerializers.getKryoThreadLocalForDocuments();
        return (T)k.copy(t);
    }

    public static <T> T cloneObject(T t) {
        Kryo k = KryoSerializers.getKryoThreadLocalForObjects();
        Object clone = k.copy(t);
        k.reset();
        return (T)clone;
    }

    public static byte[] getBuffer(int capacity) {
        if ((long)capacity > 0x100000L) {
            return new byte[capacity];
        }
        byte[] buffer = (byte[])bufferPerThread.get();
        if (buffer.length < capacity || buffer.length > capacity * 10) {
            buffer = new byte[capacity];
            bufferPerThread.set(buffer);
        }
        return buffer;
    }

    public static Object deserializeObject(ByteBuffer bb) {
        return KryoSerializers.deserializeObject(bb.array(), bb.position(), bb.limit());
    }

    public static Object deserializeObject(byte[] bytes, int position, int length) {
        Kryo k = KryoSerializers.getKryoThreadLocalForObjects();
        Input in = new Input(bytes, position, length);
        return k.readClassAndObject(in);
    }

    public static Object deserializeDocument(byte[] bytes, int position, int length) {
        Kryo k = KryoSerializers.getKryoThreadLocalForDocuments();
        Input in = new Input(bytes, position, length);
        return k.readClassAndObject(in);
    }

    public static Object deserializeDocument(ByteBuffer bb) {
        return KryoSerializers.deserializeDocument(bb.array(), bb.position(), bb.limit());
    }

    static {
        String v = System.getProperty(PROPERTY_KRYO_HANDLE_BUILTIN_COLLECTIONS);
        if (v != null) {
            KRYO_HANDLE_BUILTIN_COLLECTIONS = Boolean.valueOf(v);
        }
        kryoForObjectPerThread = new KryoForObjectThreadLocal();
        kryoForDocumentPerThread = new KryoForDocumentThreadLocal();
        bufferPerThread = new BufferThreadLocal();
    }

    public static class KryoForDocumentThreadLocal
    extends ThreadLocal<Kryo> {
        @Override
        protected Kryo initialValue() {
            return KryoSerializers.create(false);
        }
    }

    public static class KryoForObjectThreadLocal
    extends ThreadLocal<Kryo> {
        @Override
        protected Kryo initialValue() {
            return KryoSerializers.create(true);
        }
    }
}

