/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.VersionFieldSerializer;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.serialization.OutputWithRoot;
import java.lang.reflect.Field;

public final class FieldNullifyingVersionFieldSerializer<T>
extends VersionFieldSerializer<T> {
    private static final String FIELD_TYPE_VERSION = "typeVersion";
    private int superTypeVersion;
    private int indexSelfLink = -1;
    private int indexKind = -1;
    private static final ServiceDocument TEMPLATE = new ServiceDocument();

    public FieldNullifyingVersionFieldSerializer(Kryo kryo, Class<?> type) {
        super(kryo, type);
        this.ignoreFields();
    }

    public FieldNullifyingVersionFieldSerializer(Kryo kryo, Class<?> type, boolean compatible) {
        super(kryo, type, compatible);
        this.ignoreFields();
    }

    private void ignoreFields() {
        try {
            Field versionField = VersionFieldSerializer.class.getDeclaredField(FIELD_TYPE_VERSION);
            versionField.setAccessible(true);
            this.superTypeVersion = (Integer)versionField.get((Object)this);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        FieldSerializer.CachedField[] fields = this.getFields();
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            Field theField = fields[i].getField();
            if (theField.getDeclaringClass() == ServiceDocument.class && theField.getName().equals("documentSelfLink")) {
                this.indexSelfLink = i;
                continue;
            }
            if (theField.getDeclaringClass() != ServiceDocument.class || !theField.getName().equals("documentKind")) continue;
            this.indexKind = i;
        }
    }

    public void write(Kryo kryo, Output _o, T object) {
        if (!(_o instanceof OutputWithRoot)) {
            super.write(kryo, _o, object);
            return;
        }
        OutputWithRoot output = (OutputWithRoot)_o;
        FieldSerializer.CachedField[] fields = this.getFields();
        output.writeVarInt(this.superTypeVersion, true);
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (output.getRoot() == object && (i == this.indexKind || i == this.indexSelfLink)) {
                fields[i].write((Output)output, (Object)TEMPLATE);
                continue;
            }
            fields[i].write((Output)output, object);
        }
    }
}

