/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.jwt;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.vmware.xenon.common.jwt.Algorithm;
import com.vmware.xenon.common.jwt.Constants;
import com.vmware.xenon.common.jwt.Header;
import com.vmware.xenon.common.jwt.Rfc7519Claims;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Base64;

public class Signer {
    protected Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
    private byte[] secret;
    protected Gson gson;

    public Signer(byte[] secret) {
        this(secret, new GsonBuilder().create());
    }

    public Signer(byte[] secret, Gson gson) {
        this.secret = Arrays.copyOf(secret, secret.length);
        this.gson = gson;
    }

    public <T extends Rfc7519Claims> String sign(T claims) throws GeneralSecurityException {
        return this.sign(claims, null);
    }

    public <T extends Rfc7519Claims> String sign(T claims, Algorithm algorithm) throws GeneralSecurityException {
        if (algorithm == null) {
            algorithm = Constants.DEFAULT_ALGORITHM;
        }
        Header header = new Header();
        header.algorithm = algorithm.name();
        header.type = "JWT";
        StringBuilder builder = new StringBuilder();
        builder.append(this.encode(header));
        builder.append('.');
        String encClaims = this.encode(claims);
        builder.append(encClaims);
        byte[] signature = algorithm.sign(builder.toString().getBytes(Constants.DEFAULT_CHARSET), this.secret);
        builder.append('.');
        builder.append(this.encode(signature));
        return builder.toString();
    }

    protected String encode(byte[] payload) {
        return new String(this.encoder.encode(payload), Constants.DEFAULT_CHARSET);
    }

    protected String encode(Object object) {
        String json = this.gson.toJson(object);
        return this.encode(json.getBytes(Constants.DEFAULT_CHARSET));
    }
}

