/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationQueue;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyHttpClientRequestInitializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public class NettyChannelPool {
    static ThreadLocal<NettyChannelGroupKey> lookupChannelKeyPerThread = new ThreadLocal<NettyChannelGroupKey>(){

        @Override
        public NettyChannelGroupKey initialValue() {
            return new NettyChannelGroupKey();
        }
    };
    public static final Logger LOGGER = Logger.getLogger(NettyChannelPool.class.getName());
    private static final long CHANNEL_EXPIRATION_MICROS = Long.getLong("xenon.NettyChannelPool.CHANNEL_EXPIRATION_MICROS", ServiceHost.ServiceHostState.DEFAULT_OPERATION_TIMEOUT_MICROS * 10L);
    private ExecutorService nettyExecutorService;
    private ExecutorService executor;
    private EventLoopGroup eventGroup;
    private String threadTag = NettyChannelPool.class.getSimpleName();
    private int threadCount;
    private boolean isHttp2Only = false;
    private Bootstrap bootStrap;
    private final Map<NettyChannelGroupKey, NettyChannelGroup> channelGroups = new ConcurrentSkipListMap<NettyChannelGroupKey, NettyChannelGroup>();
    private Map<String, Integer> connectionLimitsPerTag = new ConcurrentSkipListMap<String, Integer>();
    private SslContext http2SslContext;
    private SSLContext sslContext;
    private int requestPayloadSizeLimit;
    private int pendingRequestQueueLimit;

    static NettyChannelGroupKey buildLookupKey(String tag, String host, int port, boolean isHttp2) {
        NettyChannelGroupKey key = lookupChannelKeyPerThread.get();
        return key.set(tag, host, port, isHttp2);
    }

    public NettyChannelPool setThreadTag(String tag) {
        this.threadTag = tag;
        return this;
    }

    public NettyChannelPool setThreadCount(int count) {
        this.threadCount = count;
        return this;
    }

    public NettyChannelPool setExecutor(ExecutorService es) {
        this.executor = es;
        return this;
    }

    public NettyChannelPool setHttp2Only() {
        this.isHttp2Only = true;
        return this;
    }

    public boolean isHttp2Only() {
        return this.isHttp2Only;
    }

    public void start() {
        if (this.bootStrap != null) {
            return;
        }
        if (this.executor == null) {
            this.executor = this.nettyExecutorService = Executors.newFixedThreadPool(this.threadCount, r -> new Thread(r, this.threadTag));
        }
        this.eventGroup = new NioEventLoopGroup(this.threadCount, (Executor)this.executor);
        this.bootStrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.bootStrap.group(this.eventGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new NettyHttpClientRequestInitializer(this, this.isHttp2Only, this.requestPayloadSizeLimit));
    }

    public boolean isStarted() {
        return this.bootStrap != null;
    }

    public NettyChannelPool setConnectionLimitPerTag(String tag, int limit) {
        this.connectionLimitsPerTag.put(tag, limit);
        return this;
    }

    public int getConnectionLimitPerTag(String tag) {
        return this.connectionLimitsPerTag.getOrDefault(tag, ServiceClient.DEFAULT_CONNECTION_LIMIT_PER_TAG);
    }

    public NettyChannelPool setRequestPayloadSizeLimit(int requestPayloadSizeLimit) {
        this.requestPayloadSizeLimit = requestPayloadSizeLimit;
        return this;
    }

    public int getRequestPayloadSizeLimit() {
        return this.requestPayloadSizeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyChannelPool setPendingRequestQueueLimit(int limit) {
        this.pendingRequestQueueLimit = limit;
        Iterator<NettyChannelGroup> iterator = this.channelGroups.values().iterator();
        while (iterator.hasNext()) {
            NettyChannelGroup g;
            NettyChannelGroup nettyChannelGroup = g = iterator.next();
            synchronized (nettyChannelGroup) {
                g.pendingRequests.setLimit(limit);
            }
        }
        return this;
    }

    public int getPendingRequestQueueLimit() {
        return this.pendingRequestQueueLimit;
    }

    private NettyChannelGroup getChannelGroup(String tag, String host, int port) {
        NettyChannelGroupKey key = NettyChannelPool.buildLookupKey(tag, host, port, this.isHttp2Only);
        return this.getChannelGroup(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NettyChannelGroup getChannelGroup(NettyChannelGroupKey threadLocalKey) {
        NettyChannelGroup group;
        Map<NettyChannelGroupKey, NettyChannelGroup> map = this.channelGroups;
        synchronized (map) {
            group = this.channelGroups.get(threadLocalKey);
            if (group == null) {
                NettyChannelGroupKey clonedKey = new NettyChannelGroupKey(threadLocalKey);
                group = new NettyChannelGroup(clonedKey, this.pendingRequestQueueLimit);
                this.channelGroups.put(clonedKey, group);
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceClient.ConnectionPoolMetrics getConnectionTagInfo(String tag) {
        ServiceClient.ConnectionPoolMetrics tagInfo = null;
        for (NettyChannelGroup g : this.channelGroups.values()) {
            if (!tag.equals(g.key.connectionTag)) continue;
            if (tagInfo == null) {
                tagInfo = new ServiceClient.ConnectionPoolMetrics();
            }
            NettyChannelGroup nettyChannelGroup = g;
            synchronized (nettyChannelGroup) {
                tagInfo.pendingRequestCount += g.pendingRequests.size();
                tagInfo.inUseConnectionCount += g.inUseChannels.size();
                tagInfo.availableConnectionCount += g.availableChannels.size();
            }
        }
        return tagInfo;
    }

    public void connectOrReuse(NettyChannelGroupKey key, final Operation request) {
        if (request == null) {
            throw new IllegalArgumentException("request is required");
        }
        if (key == null) {
            request.fail(new IllegalArgumentException("connection key is required"));
            return;
        }
        try {
            final NettyChannelGroup group = this.getChannelGroup(key);
            final NettyChannelContext context = this.selectContext(request, group);
            if (context == null) {
                return;
            }
            if (context.getChannel() != null) {
                context.setOperation(request);
                request.toggleOption(Operation.OperationOption.SOCKET_ACTIVE, true);
                request.complete();
                return;
            }
            ChannelFuture connectFuture = this.bootStrap.connect(key.host, key.port);
            connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        Channel channel = future.channel();
                        if (NettyChannelPool.this.isHttp2Only) {
                            channel.attr(NettyChannelContext.CHANNEL_CONTEXT_KEY).set((Object)context);
                            channel.attr(NettyChannelContext.HTTP2_KEY).set((Object)true);
                            NettyChannelPool.this.waitForSettings(channel, context, request, group);
                        } else {
                            context.setOpenInProgress(false);
                            context.setChannel(channel).setOperation(request);
                            request.toggleOption(Operation.OperationOption.SOCKET_ACTIVE, true);
                            NettyChannelPool.this.sendAfterConnect(channel, context, request, null);
                        }
                    } else {
                        NettyChannelPool.this.returnOrClose(context, true);
                        request.setSocketContext(null);
                        NettyChannelPool.this.fail(request, future.cause());
                    }
                }
            });
        }
        catch (Throwable e) {
            this.fail(request, e);
        }
    }

    public int getHttp2ActiveContextCount(String tag, String host, int port) {
        if (!this.isHttp2Only) {
            throw new IllegalStateException("Internal error: can't get HTTP/2 information about HTTP/1 context");
        }
        NettyChannelGroup group = this.getChannelGroup(tag, host, port);
        return group.inUseChannels.size();
    }

    public NettyChannelContext getFirstValidHttp2Context(String tag, String host, int port) {
        if (!this.isHttp2Only) {
            throw new IllegalStateException("Internal error: can't get HTTP/2 information about HTTP/1 context");
        }
        NettyChannelGroup group = this.getChannelGroup(tag, host, port);
        NettyChannelContext context = this.selectHttp2Context(null, group, "");
        return context;
    }

    private NettyChannelContext selectContext(Operation op, NettyChannelGroup group) {
        if (this.isHttp2Only) {
            return this.selectHttp2Context(op, group, op.getUri().getPath());
        }
        return this.selectHttp11Context(op, group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NettyChannelContext selectHttp2Context(Operation request, NettyChannelGroup group, String link) {
        NettyChannelContext context = null;
        NettyChannelContext badContext = null;
        int limit = this.getConnectionLimitPerTag(group.getKey().connectionTag);
        NettyChannelGroup nettyChannelGroup = group;
        synchronized (nettyChannelGroup) {
            if (!group.inUseChannels.isEmpty()) {
                int index = Math.abs(link.hashCode() % group.inUseChannels.size());
                NettyChannelContext ctx = group.inUseChannels.get(index);
                if (ctx.isValid()) {
                    context = ctx;
                } else {
                    LOGGER.info(ctx.getLargestStreamId() + ":" + group.getKey());
                }
            }
            if (context != null && (context.isOpenInProgress() || !group.pendingRequests.isEmpty())) {
                if (request != null) {
                    this.queuePendingRequest(request, group);
                }
                return null;
            }
            int activeChannelCount = group.inUseChannels.size();
            if (context != null && context.hasActiveStreams() && activeChannelCount < limit) {
                context = null;
            } else if (context == null) {
                for (NettyChannelContext ctx : group.inUseChannels) {
                    if (!ctx.isValid()) continue;
                    context = ctx;
                    break;
                }
            }
            if (context != null && context.getChannel() != null && !context.getChannel().isOpen()) {
                badContext = context;
                context = null;
            }
            if (context == null) {
                context = new NettyChannelContext(group.getKey(), NettyChannelContext.Protocol.HTTP2);
                context.setOpenInProgress(true);
                group.inUseChannels.add(context);
            }
        }
        this.closeBadChannelContext(badContext);
        context.updateLastUseTime();
        return context;
    }

    private void queuePendingRequest(Operation request, NettyChannelGroup group) {
        if (group.pendingRequests.offer(request)) {
            return;
        }
        ForkJoinPool.commonPool().execute(() -> Operation.failLimitExceeded(request, -2147483639));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NettyChannelContext selectHttp11Context(Operation request, NettyChannelGroup group) {
        NettyChannelContext context;
        NettyChannelContext badContext = null;
        NettyChannelGroup nettyChannelGroup = group;
        synchronized (nettyChannelGroup) {
            context = group.availableChannels.poll();
            if (context == null) {
                int limit = this.getConnectionLimitPerTag(group.getKey().connectionTag);
                if (group.inUseChannels.size() >= limit) {
                    this.queuePendingRequest(request, group);
                    return null;
                }
                context = new NettyChannelContext(group.getKey(), NettyChannelContext.Protocol.HTTP11);
                context.setOpenInProgress(true);
            }
            if (context.getChannel() != null && !context.getChannel().isOpen()) {
                badContext = context;
                context = new NettyChannelContext(group.getKey(), NettyChannelContext.Protocol.HTTP11);
                context.setOpenInProgress(true);
            }
            group.inUseChannels.add(context);
        }
        this.closeBadChannelContext(badContext);
        context.updateLastUseTime();
        return context;
    }

    private void closeBadChannelContext(NettyChannelContext badContext) {
        if (badContext == null) {
            return;
        }
        Logger.getAnonymousLogger().info("replacing channel in bad state: " + badContext.toString());
        this.returnOrClose(badContext, true);
    }

    private void waitForSettings(Channel ch, final NettyChannelContext contextFinal, final Operation request, final NettyChannelGroup group) {
        ChannelPromise settingsPromise = (ChannelPromise)ch.attr(NettyChannelContext.SETTINGS_PROMISE_KEY).get();
        settingsPromise.addListener((GenericFutureListener)new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ArrayList<Operation> pendingOps = new ArrayList<Operation>();
                    NettyChannelGroup nettyChannelGroup = group;
                    synchronized (nettyChannelGroup) {
                        contextFinal.setOpenInProgress(false);
                        contextFinal.setChannel(future.channel()).setOperation(request);
                        request.toggleOption(Operation.OperationOption.SOCKET_ACTIVE, true);
                        group.pendingRequests.transferAll(pendingOps);
                    }
                    NettyChannelPool.this.sendAfterConnect(future.channel(), contextFinal, request, group);
                    for (Operation pendingOp : pendingOps) {
                        pendingOp.setSocketContext(contextFinal);
                        pendingOp.toggleOption(Operation.OperationOption.SOCKET_ACTIVE, true);
                        pendingOp.complete();
                    }
                } else {
                    NettyChannelPool.this.returnOrClose(contextFinal, true);
                    NettyChannelPool.this.fail(request, future.cause());
                }
            }
        });
    }

    private void sendAfterConnect(Channel ch, NettyChannelContext contextFinal, Operation request, NettyChannelGroup group) {
        if (request.getStatusCode() < 400) {
            request.complete();
        } else {
            request.fail(request.getStatusCode());
        }
    }

    private void fail(Operation request, Throwable e) {
        request.fail(e, 400);
    }

    public void returnOrClose(NettyChannelContext context, boolean isClose) {
        if (context == null) {
            return;
        }
        this.returnOrCloseDirect(context, isClose);
    }

    boolean isContextInUse(NettyChannelContext context) {
        if (context == null) {
            return false;
        }
        NettyChannelGroup group = this.channelGroups.get(context.getKey());
        return group != null && group.inUseChannels.contains(context);
    }

    private void returnOrCloseDirect(NettyChannelContext context, boolean isClose) {
        NettyChannelGroup group;
        Channel ch = context.getChannel();
        if (ch != null) {
            if (this.isHttp2Only) {
                isClose = isClose || !ch.isOpen() || !context.isValid();
            } else {
                boolean bl = isClose = isClose || !ch.isWritable() || !ch.isOpen();
            }
        }
        if ((group = this.channelGroups.get(context.getKey())) == null) {
            LOGGER.warning("Cound not find group for " + context.getKey());
            context.close();
            return;
        }
        this.returnOrCloseDirect(context, group, isClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnOrCloseDirect(NettyChannelContext context, NettyChannelGroup group, boolean isClose) {
        Operation pendingOp = null;
        NettyChannelGroup nettyChannelGroup = group;
        synchronized (nettyChannelGroup) {
            pendingOp = group.pendingRequests.poll();
            if (isClose) {
                group.inUseChannels.remove(context);
            } else if (!this.isHttp2Only && pendingOp == null && group.inUseChannels.remove(context)) {
                group.availableChannels.add(context);
            }
        }
        if (isClose) {
            context.close();
        }
        if (pendingOp == null) {
            return;
        }
        if (isClose) {
            this.connectOrReuse(context.getKey(), pendingOp);
        } else {
            context.setOperation(pendingOp);
            pendingOp.toggleOption(Operation.OperationOption.SOCKET_ACTIVE, true);
            pendingOp.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            Iterator<NettyChannelGroup> iterator = this.channelGroups.values().iterator();
            while (iterator.hasNext()) {
                NettyChannelGroup g;
                NettyChannelGroup nettyChannelGroup = g = iterator.next();
                synchronized (nettyChannelGroup) {
                    for (NettyChannelContext c : g.availableChannels) {
                        c.close(true);
                    }
                    for (NettyChannelContext c : g.inUseChannels) {
                        c.close(true);
                    }
                    g.availableChannels.clear();
                    g.inUseChannels.clear();
                }
            }
            this.eventGroup.shutdownGracefully();
            if (this.nettyExecutorService != null) {
                this.nettyExecutorService.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.bootStrap = null;
    }

    public void handleMaintenance(Operation op) {
        long now = Utils.getSystemNowMicrosUtc();
        if (this.isHttp2Only) {
            this.handleHttp2Maintenance(now);
        } else {
            this.handleHttp1Maintenance(now);
        }
        op.complete();
    }

    private void handleHttp1Maintenance(long now) {
        for (NettyChannelGroup g : this.channelGroups.values()) {
            this.logGroupStatus(g);
            this.closeIdleChannelContexts(g, false, now);
        }
    }

    private void handleHttp2Maintenance(long now) {
        for (NettyChannelGroup g : this.channelGroups.values()) {
            this.logGroupStatus(g);
            this.closeInvalidHttp2ChannelContexts(g, now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logGroupStatus(NettyChannelGroup g) {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        String s = null;
        NettyChannelGroup nettyChannelGroup = g;
        synchronized (nettyChannelGroup) {
            s = String.format("Maintenance on %s, pending: %d, available channels: %d", g.getKey(), g.pendingRequests.size(), g.availableChannels.size());
        }
        LOGGER.info(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIdleChannelContexts(NettyChannelGroup group, boolean forceClose, long now) {
        NettyChannelGroup nettyChannelGroup = group;
        synchronized (nettyChannelGroup) {
            Iterator it = group.availableChannels.iterator();
            while (it.hasNext()) {
                NettyChannelContext c = (NettyChannelContext)it.next();
                if (!forceClose) {
                    long delta = now - c.getLastUseTimeMicros();
                    if (delta < CHANNEL_EXPIRATION_MICROS) continue;
                    try {
                        if (c.getChannel() == null || !c.getChannel().isOpen()) {
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                it.remove();
                LOGGER.warning("Closing expired channel " + c.getKey());
                c.close();
            }
        }
        this.checkPendingOperations(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInvalidHttp2ChannelContexts(NettyChannelGroup group, long now) {
        NettyChannelGroup nettyChannelGroup = group;
        synchronized (nettyChannelGroup) {
            Iterator<NettyChannelContext> it = group.inUseChannels.iterator();
            while (it.hasNext()) {
                long delta;
                NettyChannelContext http2Channel = it.next();
                Channel channel = http2Channel.getChannel();
                if (channel == null || http2Channel.hasActiveStreams() || (delta = now - http2Channel.getLastUseTimeMicros()) < CHANNEL_EXPIRATION_MICROS && http2Channel.isValid()) continue;
                it.remove();
                http2Channel.close();
            }
        }
        this.checkPendingOperations(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPendingOperations(NettyChannelGroup group) {
        if (group.pendingRequests.isEmpty()) {
            return;
        }
        int searchLimit = 1000;
        int count = 0;
        int removedCount = 0;
        NettyChannelGroup nettyChannelGroup = group;
        synchronized (nettyChannelGroup) {
            Iterator<Operation> pendingOpIt = group.pendingRequests.iterator();
            while (pendingOpIt.hasNext() && ++count < 1000) {
                Operation pendingOp = pendingOpIt.next();
                if (pendingOp.getStatusCode() < 400) {
                    if (count <= 10) continue;
                    break;
                }
                pendingOpIt.remove();
                ++removedCount;
            }
        }
        if (removedCount == 0) {
            return;
        }
        LOGGER.warning(String.format("Pending %d, failed pending operations removed: %d", group.pendingRequests.size(), removedCount));
    }

    public void setHttp2SslContext(SslContext context) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this.http2SslContext = context;
    }

    public SslContext getHttp2SslContext() {
        return this.http2SslContext;
    }

    public void setSSLContext(SSLContext context) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this.sslContext = context;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public static class NettyChannelGroup {
        private NettyChannelGroupKey key;
        public Queue<NettyChannelContext> availableChannels = new ConcurrentLinkedQueue<NettyChannelContext>();
        public List<NettyChannelContext> inUseChannels = new ArrayList<NettyChannelContext>();
        public OperationQueue pendingRequests;

        public NettyChannelGroup(NettyChannelGroupKey key, int queueLimit) {
            this.key = key;
            this.pendingRequests = OperationQueue.createFifo(queueLimit);
        }

        public NettyChannelGroupKey getKey() {
            return this.key;
        }
    }

    public static class NettyChannelGroupKey
    implements Comparable<NettyChannelGroupKey> {
        private static final String NO_HOST = "";
        private String connectionTag;
        private String host;
        private int port;
        private int hashcode;

        public NettyChannelGroupKey() {
        }

        NettyChannelGroupKey(NettyChannelGroupKey other) {
            this.connectionTag = other.connectionTag;
            this.host = other.host;
            this.port = other.port;
        }

        public NettyChannelGroupKey set(String tag, String host, int port, boolean isHttp2) {
            if (tag == null) {
                tag = isHttp2 ? "xn-cnx-tag-http2-default" : "xn-cnx-tag-default";
            }
            this.connectionTag = tag;
            String string = this.host = host == null ? NO_HOST : host;
            if (port <= 0) {
                port = 80;
            }
            this.port = port;
            this.hashcode = 0;
            return this;
        }

        public String toString() {
            return this.connectionTag + ":" + this.host + ":" + this.port;
        }

        public int hashCode() {
            if (this.hashcode == 0) {
                this.hashcode = Objects.hash(this.connectionTag, this.host, this.port);
            }
            return this.hashcode;
        }

        @Override
        public int compareTo(NettyChannelGroupKey o) {
            int r = Integer.compare(this.port, o.port);
            if (r != 0) {
                return r;
            }
            r = this.connectionTag.compareTo(o.connectionTag);
            if (r != 0) {
                return r;
            }
            return this.host.compareTo(o.host);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NettyChannelGroupKey)) {
                return false;
            }
            NettyChannelGroupKey otherKey = (NettyChannelGroupKey)other;
            return this.compareTo(otherKey) == 0;
        }
    }
}

