/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.google.gson.JsonObject;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;

public final class QueryResultsProcessor {
    private final QueryTask task;
    private final ServiceDocumentQueryResult results;

    private QueryResultsProcessor(QueryTask task, ServiceDocumentQueryResult results) {
        this.task = task;
        this.results = results;
    }

    public static QueryResultsProcessor create(QueryTask task) {
        return new QueryResultsProcessor(task, task.results);
    }

    public static QueryResultsProcessor create(ServiceDocumentQueryResult results) {
        return new QueryResultsProcessor(null, results);
    }

    public static QueryResultsProcessor create(Operation op) {
        Object rawBody = op.getBodyRaw();
        if (rawBody instanceof QueryTask) {
            QueryTask qt = (QueryTask)rawBody;
            return new QueryResultsProcessor(qt, qt.results);
        }
        if (rawBody instanceof ServiceDocumentQueryResult) {
            ServiceDocumentQueryResult qr = (ServiceDocumentQueryResult)rawBody;
            return new QueryResultsProcessor(null, qr);
        }
        if (rawBody instanceof String || rawBody instanceof JsonObject) {
            QueryTask maybeTask = op.getBody(QueryTask.class);
            if (Objects.equals(maybeTask.documentKind, QueryTask.KIND)) {
                return new QueryResultsProcessor(maybeTask, maybeTask.results);
            }
            ServiceDocumentQueryResult results = op.getBody(ServiceDocumentQueryResult.class);
            return new QueryResultsProcessor(null, results);
        }
        throw new IllegalArgumentException("Cannot create QueryResultsProcessor from a " + op.getUri());
    }

    public QueryTask getQueryTask() {
        return this.task;
    }

    public boolean hasResults() {
        return this.results != null && this.results.documentCount != null && this.results.documentCount > 0L;
    }

    public <T extends ServiceDocument> Stream<T> streamDocuments(Class<T> type) {
        if (this.results == null || this.results.documents == null) {
            return Collections.emptyList().stream();
        }
        return this.results.documents.values().stream().map(o -> this.convert(type, o));
    }

    public ServiceDocumentQueryResult getQueryResult() {
        return this.results;
    }

    public <T extends ServiceDocument> T selectedDocument(String selfLink, Class<T> type) {
        if (this.results == null || this.results.selectedDocuments == null) {
            return null;
        }
        Object o = this.results.selectedDocuments.get(selfLink);
        return this.convert(type, o);
    }

    public <T extends ServiceDocument> T document(String selfLink, Class<T> type) {
        if (this.results == null || this.results.documents == null) {
            return null;
        }
        Object o = this.results.documents.get(selfLink);
        return this.convert(type, o);
    }

    public <T extends ServiceDocument> Iterable<T> selectedDocuments(Class<T> type) {
        if (this.results == null || this.results.selectedDocuments == null) {
            return Collections.emptyList();
        }
        Stream<ServiceDocument> stream = this.results.selectedDocuments.values().stream().map(o -> this.convert(type, o));
        return stream::iterator;
    }

    public Iterable<String> selectedLinks() {
        if (this.results == null || this.results.selectedLinks == null) {
            return Collections.emptyList();
        }
        return this.results.selectedLinks;
    }

    public Iterable<String> documentLinks() {
        if (this.results == null || this.results.documentLinks == null) {
            return Collections.emptyList();
        }
        return this.results.documentLinks;
    }

    public <T extends ServiceDocument> Iterable<T> documents(Class<T> type) {
        return this.streamDocuments(type)::iterator;
    }

    private <T extends ServiceDocument> T convert(Class<T> type, Object o) {
        if (o == null) {
            return null;
        }
        if (type.isInstance(o)) {
            return (T)((ServiceDocument)type.cast(o));
        }
        if (o instanceof String || o instanceof JsonObject) {
            return (T)((ServiceDocument)Utils.fromJson(o, type));
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to %s", o.getClass().getName(), type.getName()));
    }
}

