/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;

public final class OperationContext
implements Cloneable {
    private static final ThreadLocal<OperationContext> threadOperationContext = ThreadLocal.withInitial(OperationContext::new);
    Operation.AuthorizationContext authContext;
    String contextId;
    String transactionId;

    private OperationContext() {
    }

    public OperationContext clone() {
        try {
            return (OperationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    static OperationContext getOperationContextNoCloning() {
        return threadOperationContext.get();
    }

    public static void setContextId(String contextId) {
        OperationContext.threadOperationContext.get().contextId = contextId;
    }

    public static String getContextId() {
        return OperationContext.threadOperationContext.get().contextId;
    }

    static void setAuthorizationContext(Operation.AuthorizationContext ctx) {
        OperationContext.threadOperationContext.get().authContext = ctx;
    }

    public static void setTransactionId(String transactionId) {
        OperationContext.threadOperationContext.get().transactionId = transactionId;
    }

    public static String getTransactionId() {
        return OperationContext.threadOperationContext.get().transactionId;
    }

    public static Operation.AuthorizationContext getAuthorizationContext() {
        return OperationContext.threadOperationContext.get().authContext;
    }

    public static OperationContext getOperationContext() {
        return threadOperationContext.get().clone();
    }

    public static void setFrom(OperationContext opCtx) {
        OperationContext currentOpCtx = threadOperationContext.get();
        currentOpCtx.authContext = opCtx.authContext;
        currentOpCtx.transactionId = opCtx.transactionId;
        currentOpCtx.contextId = opCtx.contextId;
    }

    public static void setFrom(Operation op) {
        OperationContext currentOpCtx = threadOperationContext.get();
        currentOpCtx.authContext = op.getAuthorizationContext();
        currentOpCtx.transactionId = op.getTransactionId();
        currentOpCtx.contextId = op.getContextId();
    }

    public static void reset() {
        OperationContext opCtx = threadOperationContext.get();
        opCtx.authContext = null;
        opCtx.transactionId = null;
        opCtx.contextId = null;
    }

    public static void restoreOperationContext(OperationContext opCtx) {
        OperationContext currentOpCtx = threadOperationContext.get();
        currentOpCtx.authContext = opCtx.authContext;
        currentOpCtx.transactionId = opCtx.transactionId;
        currentOpCtx.contextId = opCtx.contextId;
    }
}

