/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;

public interface NodeSelectorService
extends Service {
    public static final String STAT_NAME_QUEUED_REQUEST_COUNT = "queuedRequestCount";
    public static final String STAT_NAME_LIMIT_EXCEEDED_FAILED_REQUEST_COUNT = "limitExceededFailedRequestCount";
    public static final String STAT_NAME_SYNCHRONIZATION_COUNT = "synchronizationCount";
    public static final Operation.OperationOption FORWARDING_OPERATION_OPTION = NodeSelectorService.getOperationOption("NodeSelectorService.FORWARDING_OPERATION_OPTION", Operation.OperationOption.CONNECTION_SHARING);
    public static final Operation.OperationOption REPLICATION_OPERATION_OPTION = NodeSelectorService.getOperationOption("NodeSelectorService.REPLICATION_OPERATION_OPTION", null);
    public static final int REPLICATION_TAG_CONNECTION_LIMIT = Integer.getInteger("xenon.NodeSelectorService.REPLICATION_TAG_CONNECTION_LIMIT", 32);
    public static final int SYNCHRONIZATION_TAG_CONNECTION_LIMIT = Integer.getInteger("xenon.NodeSelectorService.SYNCHRONIZATION_TAG_CONNECTION_LIMIT", 32);
    public static final int FORWARDING_TAG_CONNECTION_LIMIT = Integer.getInteger("xenon.NodeSelectorService.FORWARDING_TAG_CONNECTION_LIMIT", 32);

    public static Operation.OperationOption getOperationOption(String name, Operation.OperationOption defaultOpt) {
        String paramName = "xenon." + name;
        String paramValue = System.getProperty(paramName);
        if (Operation.OperationOption.CONNECTION_SHARING.name().equals(paramValue)) {
            return Operation.OperationOption.CONNECTION_SHARING;
        }
        return defaultOpt;
    }

    public String getNodeGroupPath();

    public void selectAndForward(Operation var1, SelectAndForwardRequest var2);

    public static class SelectOwnerResponse {
        public String key;
        public String ownerNodeId;
        public URI ownerNodeGroupReference;
        public boolean isLocalHostOwner;
        public int availableNodeCount;
        public Collection<NodeState> selectedNodes;
        public long membershipUpdateTimeMicros;

        public static URI buildUriToOwner(SelectOwnerResponse rsp, String path, String query) {
            return UriUtils.buildServiceUri(rsp.ownerNodeGroupReference.getScheme(), rsp.ownerNodeGroupReference.getHost(), rsp.ownerNodeGroupReference.getPort(), path, query, null);
        }

        public static URI buildUriToOwner(SelectOwnerResponse rsp, Operation op) {
            return UriUtils.buildServiceUri(rsp.ownerNodeGroupReference.getScheme(), rsp.ownerNodeGroupReference.getHost(), rsp.ownerNodeGroupReference.getPort(), op.getUri().getPath(), op.getUri().getQuery(), null);
        }
    }

    public static class SelectAndForwardRequest {
        public static final EnumSet<ForwardingOption> REPLICATION_OPTIONS = EnumSet.of(ForwardingOption.BROADCAST, ForwardingOption.REPLICATE);
        public static final EnumSet<ForwardingOption> UNICAST_OPTIONS = EnumSet.of(ForwardingOption.UNICAST);
        public static final EnumSet<ForwardingOption> BROADCAST_OPTIONS = EnumSet.of(ForwardingOption.BROADCAST);
        public static final EnumSet<ForwardingOption> BROADCAST_OPTIONS_EXCLUDE_ENTRY_NODE = EnumSet.of(ForwardingOption.BROADCAST, ForwardingOption.EXCLUDE_ENTRY_NODE);
        public String key;
        public String targetPath;
        public String targetQuery;
        public transient Operation associatedOp;
        public EnumSet<ForwardingOption> options;
        public EnumSet<Service.ServiceOption> serviceOptions;

        public static enum ForwardingOption {
            REPLICATE,
            BROADCAST,
            UNICAST,
            EXCLUDE_ENTRY_NODE;

        }
    }
}

