/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class DeferredResult<T> {
    private final CompletableFuture<T> completableFuture;

    public static <U> DeferredResult<U> completed(U value) {
        DeferredResult<U> deferred = new DeferredResult<U>();
        deferred.complete(value);
        return deferred;
    }

    public static <U> DeferredResult<U> failed(Throwable ex) {
        DeferredResult deferred = new DeferredResult();
        deferred.fail(ex);
        return deferred;
    }

    public static DeferredResult<Void> allOf(DeferredResult<?> ... deferredResults) {
        CompletableFuture[] cfs = Arrays.stream(deferredResults).map(d -> d.completableFuture).collect(Collectors.toList()).toArray(new CompletableFuture[deferredResults.length]);
        CompletableFuture<Void> cf = CompletableFuture.allOf(cfs);
        return new DeferredResult<Void>(cf);
    }

    public static <U> DeferredResult<List<U>> allOf(List<DeferredResult<U>> deferredResults) {
        List<CompletableFuture> futures = deferredResults.stream().map(d -> d.completableFuture).collect(Collectors.toList());
        CompletionStage cf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[deferredResults.size()])).thenApply((T ignore) -> {
            List results = futures.stream().map(f -> f.getNow(null)).collect(Collectors.toList());
            return results;
        });
        return new DeferredResult<List<U>>(cf);
    }

    public static DeferredResult<?> anyOf(DeferredResult<?> ... deferredResults) {
        CompletableFuture[] cfs = Arrays.stream(deferredResults).map(d -> d.completableFuture).collect(Collectors.toList()).toArray(new CompletableFuture[deferredResults.length]);
        CompletableFuture<Object> cf = CompletableFuture.anyOf(cfs);
        return new DeferredResult<Object>(cf);
    }

    public static <U> DeferredResult<U> anyOf(List<DeferredResult<U>> deferredResults) {
        List<CompletableFuture> futures = deferredResults.stream().map(d -> d.completableFuture).collect(Collectors.toList());
        CompletionStage cf = CompletableFuture.anyOf(futures.toArray(new CompletableFuture[deferredResults.size()])).thenApply((T obj) -> obj);
        return new DeferredResult(cf);
    }

    public DeferredResult() {
        this(new CompletableFuture());
    }

    public DeferredResult(CompletableFuture<T> completableFuture) {
        this.completableFuture = completableFuture;
    }

    protected <U> DeferredResult<U> wrap(CompletableFuture<U> completableFuture) {
        return new DeferredResult<U>(completableFuture);
    }

    public <U> DeferredResult<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.thenApply(fn));
    }

    public <U> DeferredResult<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.thenApplyAsync(fn, executor));
    }

    public DeferredResult<Void> thenAccept(Consumer<? super T> action) {
        return this.wrap((CompletableFuture)this.completableFuture.thenAccept((Consumer)action));
    }

    public DeferredResult<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.wrap((CompletableFuture)this.completableFuture.thenAcceptAsync((Consumer)action, executor));
    }

    public DeferredResult<Void> thenRun(Runnable action) {
        return this.wrap((CompletableFuture)this.completableFuture.thenRun(action));
    }

    public DeferredResult<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.wrap((CompletableFuture)this.completableFuture.thenRunAsync(action, executor));
    }

    public <U, V> DeferredResult<V> thenCombine(DeferredResult<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.thenCombine(other.toCompletionStage(), fn));
    }

    public <U, V> DeferredResult<V> thenCombineAsync(DeferredResult<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.thenCombineAsync(other.toCompletionStage(), fn, executor));
    }

    public <U> DeferredResult<Void> thenAcceptBoth(DeferredResult<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.thenAcceptBoth(other.toCompletionStage(), (BiConsumer)action));
    }

    public <U> DeferredResult<Void> thenAcceptBothAsync(DeferredResult<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.thenAcceptBothAsync(other.toCompletionStage(), (BiConsumer)action, executor));
    }

    public DeferredResult<Void> runAfterBoth(DeferredResult<?> other, Runnable action) {
        return this.wrap((CompletableFuture)this.completableFuture.runAfterBoth((CompletionStage)other.toCompletionStage(), action));
    }

    public DeferredResult<Void> runAfterBothAsync(DeferredResult<?> other, Runnable action, Executor executor) {
        return this.wrap((CompletableFuture)this.completableFuture.runAfterBothAsync((CompletionStage)other.toCompletionStage(), action, executor));
    }

    public <U> DeferredResult<U> applyToEither(DeferredResult<? extends T> other, Function<? super T, U> fn) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.applyToEither((CompletionStage)other.toCompletionStage(), fn));
    }

    public <U> DeferredResult<U> applyToEitherAsync(DeferredResult<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.applyToEitherAsync((CompletionStage)other.toCompletionStage(), fn, executor));
    }

    public DeferredResult<Void> acceptEither(DeferredResult<? extends T> other, Consumer<? super T> action) {
        return this.wrap((CompletableFuture)this.completableFuture.acceptEither((CompletionStage)other.toCompletionStage(), (Consumer)action));
    }

    public DeferredResult<Void> acceptEitherAsync(DeferredResult<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.wrap((CompletableFuture)this.completableFuture.acceptEitherAsync((CompletionStage)other.toCompletionStage(), (Consumer)action, executor));
    }

    public DeferredResult<Void> runAfterEither(DeferredResult<?> other, Runnable action) {
        return this.wrap((CompletableFuture)this.completableFuture.runAfterEither((CompletionStage)other.toCompletionStage(), action));
    }

    public DeferredResult<Void> runAfterEitherAsync(DeferredResult<?> other, Runnable action, Executor executor) {
        return this.wrap((CompletableFuture)this.completableFuture.runAfterEitherAsync((CompletionStage)other.toCompletionStage(), action, executor));
    }

    public <U> DeferredResult<U> thenCompose(Function<? super T, ? extends DeferredResult<U>> fn) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.thenCompose(fn.andThen(p -> p.toCompletionStage())));
    }

    public <U> DeferredResult<U> thenComposeAsync(Function<? super T, ? extends DeferredResult<U>> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.thenComposeAsync(fn.andThen(p -> p.toCompletionStage()), executor));
    }

    public DeferredResult<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.wrap((CompletableFuture)this.completableFuture.exceptionally(fn));
    }

    public DeferredResult<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.wrap((CompletableFuture)this.completableFuture.whenComplete(action));
    }

    public DeferredResult<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.wrap((CompletableFuture)this.completableFuture.whenCompleteAsync(action, executor));
    }

    public <U> DeferredResult<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.handle(fn));
    }

    public <U> DeferredResult<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)this.completableFuture.handleAsync(fn, executor));
    }

    public T getNow(T valueIfAbsent) {
        return this.completableFuture.getNow(valueIfAbsent);
    }

    public T getNow(Supplier<? extends T> valueSupplierIfAbsent) {
        if (this.completableFuture.isDone()) {
            return this.completableFuture.join();
        }
        return valueSupplierIfAbsent.get();
    }

    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    public CompletionStage<T> toCompletionStage() {
        return this.completableFuture;
    }

    public boolean complete(T value) {
        return this.completableFuture.complete(value);
    }

    public boolean fail(Throwable ex) {
        return this.completableFuture.completeExceptionally(ex);
    }

    public DeferredResult<T> whenCompleteNotify(Operation operation) {
        return this.wrap((CompletableFuture)this.completableFuture.whenComplete((T ignore, U ex) -> {
            if (ex != null) {
                if (ex instanceof CompletionException) {
                    ex = ex.getCause();
                }
                operation.fail((Throwable)ex);
            } else {
                operation.complete();
            }
        }));
    }
}

