/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.AsyncLogFileReader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;

public class ServiceHostLogService
extends StatelessService {
    public static final String DEFAULT_LOG_FILE_PATH = "/tmp";
    public static final String DEFAULT_SYSTEM_LOG_NAME = System.getProperty("os.name").equals("Mac OS X") ? "/var/log/system.log" : "/var/log/syslog";
    private static String DEFAULT_PROCESS_LOG_NAME = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern");
    private String logFileName;

    public static String getDefaultProcessLogName() {
        return DEFAULT_PROCESS_LOG_NAME;
    }

    public static void setDefaultProcessLogName(String name) {
        DEFAULT_PROCESS_LOG_NAME = name;
    }

    public static String getDefaultGoDcpProcessLogName() {
        return ServiceHostLogService.getDefaultLogFilePath("go-dcp.log");
    }

    public static String getDefaultLogFilePath(String fileName) {
        File logDir;
        String base = DEFAULT_LOG_FILE_PATH;
        if (DEFAULT_PROCESS_LOG_NAME != null && (logDir = new File(DEFAULT_PROCESS_LOG_NAME).getParentFile()) != null && logDir.exists()) {
            base = logDir.getPath();
        }
        return base + "/" + fileName;
    }

    public ServiceHostLogService(String logFileName) {
        super(LogServiceState.class);
        this.logFileName = logFileName;
    }

    @Override
    public void handleGet(Operation get) {
        Map<String, String> params = UriUtils.parseUriQueryParams(get.getUri());
        String generation = params.get("logFileNumber");
        if (generation == null || generation.isEmpty()) {
            generation = "0";
        }
        String file = this.logFileName.replaceFirst("%g", generation);
        int max = Integer.MAX_VALUE;
        String lineCount = params.get("lineCount");
        if (lineCount != null) {
            max = Integer.parseInt(lineCount);
        }
        AsyncLogFileReader reader = AsyncLogFileReader.create(this.getSelfLink());
        try {
            reader.start(get, file, max);
        }
        catch (IOException e) {
            get.fail(e);
        }
    }

    public static void setProcessLogFile(String path) {
        DEFAULT_PROCESS_LOG_NAME = path;
    }

    public static class LogServiceState
    extends ServiceDocument {
        public List<String> items;
    }
}

