/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceRuntimeContext;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.AuthorizationCacheUtils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.util.Objects;
import java.util.concurrent.CancellationException;

public class ResourceGroupService
extends StatefulService {
    public static final String FACTORY_LINK = ServiceUriPaths.CORE_AUTHZ_RESOURCE_GROUPS;

    public static Service createFactory() {
        ResourceGroupState st = new ResourceGroupState();
        st.query = QueryTask.Query.Builder.create().addFieldClause("one", "one").build();
        Utils.toJson(st);
        return FactoryService.createIdempotent(ResourceGroupService.class);
    }

    public ResourceGroupService() {
        super(ResourceGroupState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void processCompletionStageUpdateAuthzArtifacts(Operation op) {
        if (AuthorizationCacheUtils.isAuthzCacheClearApplicableOperation(op)) {
            AuthorizationCacheUtils.clearAuthzCacheForResourceGroup(this, op);
        }
        op.complete();
    }

    @Override
    public ServiceRuntimeContext setProcessingStage(Service.ProcessingStage stage) {
        if (stage == Service.ProcessingStage.PAUSED) {
            throw new CancellationException("Cannot pause service.");
        }
        return super.setProcessingStage(stage);
    }

    @Override
    public void handleStart(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        ResourceGroupState state = op.getBody(ResourceGroupState.class);
        if (!this.validate(op, state)) {
            return;
        }
        op.complete();
    }

    @Override
    public void handlePut(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        ResourceGroupState newState = op.getBody(ResourceGroupState.class);
        if (!this.validate(op, newState)) {
            return;
        }
        ResourceGroupState currentState = (ResourceGroupState)this.getState(op);
        ServiceDocumentDescription documentDescription = this.getStateDescription();
        if (ServiceDocument.equals(documentDescription, currentState, newState)) {
            op.setStatusCode(304);
        } else {
            this.setState(op, newState);
        }
        op.complete();
    }

    @Override
    public void handlePatch(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        ResourceGroupState currentState = (ResourceGroupState)this.getState(op);
        PatchQueryRequest patchQuery = op.getBody(PatchQueryRequest.class);
        if (!Objects.equals(patchQuery.kind, PatchQueryRequest.KIND)) {
            op.fail(new IllegalArgumentException("kind should be : " + PatchQueryRequest.KIND));
            return;
        }
        if (patchQuery.clause == null) {
            op.fail(new IllegalArgumentException("clause is required"));
            return;
        }
        if (patchQuery.removeClause) {
            AuthorizationCacheUtils.removeBooleanClause(currentState.query, patchQuery.clause);
        } else {
            currentState.query.addBooleanClause(patchQuery.clause);
        }
        op.setBody(currentState);
        op.complete();
    }

    private boolean validate(Operation op, ResourceGroupState state) {
        if (state.query == null) {
            op.fail(new IllegalArgumentException("query is required"));
            return false;
        }
        return true;
    }

    public static class PatchQueryRequest {
        public static final String KIND = Utils.buildKind(PatchQueryRequest.class);
        public QueryTask.Query clause;
        public boolean removeClause = false;
        public String kind;

        private PatchQueryRequest(QueryTask.Query clause, boolean removeClause) {
            this.clause = clause;
            this.removeClause = removeClause;
            this.kind = KIND;
        }

        public static PatchQueryRequest create(QueryTask.Query clause, boolean removeClause) {
            return new PatchQueryRequest(clause, removeClause);
        }
    }

    public static class ResourceGroupState
    extends ServiceDocument {
        public QueryTask.Query query;
    }
}

