/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.AuthorizationTokenCacheService;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.RoleService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.UserGroupService;
import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public final class AuthorizationCacheUtils {
    private AuthorizationCacheUtils() {
    }

    public static void clearAuthzCacheForUser(Service s, Operation op) {
        String userLink = op.getUri().getPath();
        op.nestCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            if (s.getHost().getAuthorizationServiceUri() == null) {
                op.complete();
                return;
            }
            if (!AuthorizationCacheUtils.isAuthzCacheClearApplicableOperation(op)) {
                op.complete();
                return;
            }
            AuthorizationTokenCacheService.AuthorizationTokenCacheServiceState cacheClearState = new AuthorizationTokenCacheService.AuthorizationTokenCacheServiceState();
            cacheClearState.serviceLink = userLink;
            Operation postClearCacheRequest = Operation.createPatch(s.getHost(), AuthorizationTokenCacheService.SELF_LINK).setBody(cacheClearState).setCompletion((clearOp, clearEx) -> {
                if (clearEx != null) {
                    s.getHost().log(Level.SEVERE, Utils.toString(clearEx), new Object[0]);
                    op.fail(clearEx);
                    return;
                }
                op.complete();
            });
            s.setAuthorizationContext(postClearCacheRequest, s.getSystemAuthorizationContext());
            s.sendRequest(postClearCacheRequest);
        });
    }

    public static void clearAuthzCacheForUserGroup(Service s, Operation op, UserGroupService.UserGroupState userGroupState) {
        op.nestCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            if (userGroupState.query == null) {
                op.complete();
                return;
            }
            QueryTask queryTask = new QueryTask();
            queryTask.querySpec = new QueryTask.QuerySpecification();
            queryTask.querySpec.query = userGroupState.query;
            queryTask.setDirect(true);
            Operation postOp = Operation.createPost(s, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS).setBody(queryTask).setCompletion((queryOp, queryEx) -> {
                if (queryEx != null) {
                    op.fail(queryEx);
                    return;
                }
                QueryTask queryTaskResult = queryOp.getBody(QueryTask.class);
                ServiceDocumentQueryResult result = queryTaskResult.results;
                if (result.documentLinks == null || result.documentLinks.isEmpty()) {
                    op.complete();
                    return;
                }
                AtomicInteger completionCount = new AtomicInteger(0);
                Operation.CompletionHandler handler = (clearOp, clearEx) -> {
                    if (clearEx != null) {
                        s.getHost().log(Level.SEVERE, Utils.toString(clearEx), new Object[0]);
                        op.fail(clearEx);
                        return;
                    }
                    if (completionCount.incrementAndGet() == result.documentLinks.size()) {
                        op.complete();
                    }
                };
                for (String userLink : result.documentLinks) {
                    Operation clearUserOp = new Operation();
                    clearUserOp.setUri(UriUtils.buildUri(s.getHost(), userLink));
                    clearUserOp.setCompletion(handler);
                    AuthorizationCacheUtils.clearAuthzCacheForUser(s, clearUserOp);
                    clearUserOp.complete();
                }
            });
            s.setAuthorizationContext(postOp, s.getSystemAuthorizationContext());
            s.sendRequest(postOp);
        });
    }

    public static void clearAuthzCacheForRole(Service s, Operation op, RoleService.RoleState roleState) {
        op.nestCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            if (roleState.userGroupLink == null) {
                op.complete();
                return;
            }
            Operation parentOp = Operation.createGet(s.getHost(), roleState.userGroupLink).setCompletion((getOp, getEx) -> {
                if (getOp.getStatusCode() == 404) {
                    op.complete();
                    return;
                }
                if (getEx != null) {
                    op.setBodyNoCloning(getOp.getBodyRaw()).fail(getOp.getStatusCode());
                    return;
                }
                UserGroupService.UserGroupState userGroupState = getOp.getBody(UserGroupService.UserGroupState.class);
                AuthorizationCacheUtils.clearAuthzCacheForUserGroup(s, op, userGroupState);
                op.complete();
            });
            s.setAuthorizationContext(parentOp, s.getSystemAuthorizationContext());
            s.sendRequest(parentOp);
        });
    }

    public static void clearAuthzCacheForResourceGroup(Service s, Operation op) {
        String resourceGroupPath = op.getUri().getPath();
        op.nestCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            QueryTask queryTask = new QueryTask();
            queryTask.querySpec = new QueryTask.QuerySpecification();
            QueryTask.Query resourceGroupQuery = QueryTask.Query.Builder.create().addFieldClause("resourceGroupLink", resourceGroupPath).addKindFieldClause(RoleService.RoleState.class).build();
            queryTask.querySpec.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
            queryTask.querySpec.query = resourceGroupQuery;
            queryTask.setDirect(true);
            Operation postOp = Operation.createPost(s, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS).setBody(queryTask).setCompletion((queryOp, queryEx) -> {
                if (queryEx != null) {
                    op.fail(queryEx);
                    return;
                }
                QueryTask queryTaskResult = queryOp.getBody(QueryTask.class);
                ServiceDocumentQueryResult result = queryTaskResult.results;
                if (result.documents == null || result.documents.isEmpty()) {
                    op.complete();
                    return;
                }
                AtomicInteger completionCount = new AtomicInteger(0);
                Operation.CompletionHandler handler = (subOp, subEx) -> {
                    if (subEx != null) {
                        op.fail(subEx);
                        return;
                    }
                    if (completionCount.incrementAndGet() == result.documents.size()) {
                        op.complete();
                    }
                };
                for (Object doc : result.documents.values()) {
                    RoleService.RoleState roleState = Utils.fromJson(doc, RoleService.RoleState.class);
                    Operation roleOp = new Operation();
                    roleOp.setCompletion(handler);
                    AuthorizationCacheUtils.clearAuthzCacheForRole(s, roleOp, roleState);
                    roleOp.complete();
                }
            });
            s.setAuthorizationContext(postOp, s.getSystemAuthorizationContext());
            s.sendRequest(postOp);
        });
    }

    public static <T extends ServiceDocument> T extractBody(Operation request, Service s, Class<T> clazz) {
        if (!request.hasBody() && request.hasPragmaDirective("xn-synch-owner")) {
            return null;
        }
        ServiceDocument state = null;
        switch (request.getAction()) {
            case PUT: 
            case POST: {
                state = (ServiceDocument)request.getBody(clazz);
                break;
            }
            case DELETE: {
                if (request.isFromReplication() && request.hasBody()) {
                    state = (ServiceDocument)request.getBody(clazz);
                    break;
                }
                state = s.getState(request);
                break;
            }
        }
        return (T)state;
    }

    public static boolean isAuthzCacheClearApplicableOperation(Operation op) {
        if (op.getAction() == Service.Action.GET) {
            return false;
        }
        return !op.isFromReplication() || !(op.getAction() == Service.Action.POST ? !op.hasPragmaDirective("xn-created") : op.getAction() == Service.Action.DELETE && !op.isCommit());
    }

    public static QueryTask.Query removeBooleanClause(QueryTask.Query inputQuery, QueryTask.Query inputClause) {
        if (inputQuery.booleanClauses == null || inputClause == null) {
            return inputQuery;
        }
        for (QueryTask.Query clause : inputQuery.booleanClauses) {
            if (!Objects.equals(clause.term, inputClause.term) || !Objects.equals((Object)clause.occurance, (Object)inputClause.occurance)) continue;
            inputQuery.booleanClauses.remove(clause);
            break;
        }
        return inputQuery;
    }
}

