/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public enum ZonedDateTimeConverter implements JsonSerializer<ZonedDateTime>,
JsonDeserializer<ZonedDateTime>
{
    INSTANCE;

    private static final DateTimeFormatter FORMATTER;
    public static final Type TYPE;

    public JsonElement serialize(ZonedDateTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(FORMATTER.format(src));
    }

    public ZonedDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return FORMATTER.parse((CharSequence)json.getAsString(), ZonedDateTime::from);
    }

    static {
        FORMATTER = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        TYPE = new TypeToken<ZonedDateTime>(){}.getType();
    }
}

