/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceRequestListener;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.MaintenanceProxyService;
import com.vmware.xenon.common.http.netty.NettyHttpServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class NettyHttpListener
implements ServiceRequestListener {
    public static final String UNKNOWN_CLIENT_REFERER_PATH = "unknown-client";
    public static final int EVENT_LOOP_THREAD_COUNT = 2;
    private AtomicInteger activeChannelCount = new AtomicInteger();
    private int port;
    private ServiceHost host;
    private Channel serverChannel;
    private Map<String, NettyListenerChannelContext> pausedChannels = new ConcurrentSkipListMap<String, NettyListenerChannelContext>();
    private NioEventLoopGroup eventLoopGroup;
    private ExecutorService nettyExecutorService;
    private SslContext sslContext;
    private ChannelHandler childChannelHandler;
    private boolean isListening;
    private int responsePayloadSizeLimit = RESPONSE_PAYLOAD_SIZE_LIMIT;

    public NettyHttpListener(ServiceHost host) {
        this.host = host;
    }

    @Override
    public long getActiveClientCount() {
        return this.activeChannelCount.get();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setChildChannelHandler(ChannelHandler handler) {
        this.childChannelHandler = handler;
    }

    @Override
    public void start(int port, String bindAddress) throws Throwable {
        InetSocketAddress addr;
        this.nettyExecutorService = Executors.newFixedThreadPool(2, r -> new Thread(r, this.host.getUri().toString() + "/netty-listener/" + this.host.getId()));
        this.eventLoopGroup = new NioEventLoopGroup(2, (Executor)this.nettyExecutorService);
        if (this.childChannelHandler == null) {
            this.childChannelHandler = new NettyHttpServerInitializer(this, this.host, this.sslContext, this.responsePayloadSizeLimit);
        }
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group((EventLoopGroup)this.eventLoopGroup).channel(NioServerSocketChannel.class)).childHandler(this.childChannelHandler);
        if (bindAddress != null) {
            addr = new InetSocketAddress(bindAddress, port);
        } else {
            this.host.log(Level.WARNING, "*** Binding to all interfaces, please supply a bindAddress instead ***", new Object[0]);
            addr = new InetSocketAddress(port);
        }
        this.serverChannel = b.bind((SocketAddress)addr).sync().channel();
        this.serverChannel.config().setOption(ChannelOption.SO_LINGER, (Object)0);
        this.port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
        this.isListening = true;
        MaintenanceProxyService.start(this.host, this::handleMaintenance);
    }

    void addChannel(Channel c) {
        this.activeChannelCount.incrementAndGet();
    }

    void removeChannel(Channel c) {
        this.pausedChannels.remove(c.id().toString());
        this.activeChannelCount.decrementAndGet();
    }

    void pauseChannel(Channel c) {
        NettyListenerChannelContext ctx = new NettyListenerChannelContext();
        ctx.setChannel(c);
        this.host.log(Level.INFO, "Disabling auto-reads on %s", c);
        c.config().setAutoRead(false);
        ctx.updateLastUseTime();
        this.pausedChannels.put(c.id().toString(), ctx);
    }

    @Override
    public void handleMaintenance(Operation op) {
        if (this.pausedChannels.isEmpty()) {
            op.complete();
            return;
        }
        try {
            long now = Utils.getSystemNowMicrosUtc();
            for (NettyListenerChannelContext ctx : this.pausedChannels.values()) {
                Channel c = ctx.getChannel();
                if (c.config().isAutoRead() || now - ctx.getLastUseTimeMicros() < this.host.getMaintenanceIntervalMicros()) continue;
                this.host.log(Level.INFO, "Resuming paused channel %s, last use: %d", c, ctx.getLastUseTimeMicros());
                c.config().setAutoRead(true);
            }
            op.complete();
        }
        catch (Throwable e) {
            op.fail(e);
        }
    }

    @Override
    public void stop() throws IOException {
        this.isListening = false;
        this.pausedChannels.clear();
        if (this.serverChannel != null) {
            this.serverChannel.close();
            this.serverChannel = null;
        }
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
            this.eventLoopGroup = null;
        }
        if (this.nettyExecutorService != null) {
            this.nettyExecutorService.shutdown();
            this.nettyExecutorService = null;
        }
        this.host.setPublicUri(null);
    }

    public void setSSLContext(SslContext context) {
        if (this.isListening()) {
            throw new IllegalStateException("listener already started");
        }
        this.sslContext = context;
    }

    public SslContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public void setSSLContextFiles(URI certFile, URI keyFile) throws Throwable {
        this.setSSLContextFiles(certFile, keyFile, null);
    }

    @Override
    public void setSSLContextFiles(URI certFile, URI keyFile, String keyPassphrase) throws Throwable {
        if (this.isListening()) {
            throw new IllegalStateException("listener already started");
        }
        this.sslContext = SslContextBuilder.forServer((File)new File(certFile), (File)new File(keyFile), (String)keyPassphrase).build();
    }

    @Override
    public boolean isSSLConfigured() {
        return this.sslContext != null;
    }

    @Override
    public boolean isListening() {
        return this.isListening;
    }

    @Override
    public void setResponsePayloadSizeLimit(int responsePayloadSizeLimit) {
        if (this.isListening()) {
            throw new IllegalStateException("Already started listening");
        }
        this.responsePayloadSizeLimit = responsePayloadSizeLimit;
    }

    @Override
    public int getResponsePayloadSizeLimit() {
        return this.responsePayloadSizeLimit;
    }

    public static class NettyListenerChannelContext
    extends Operation.SocketContext {
        private Channel channel;

        public NettyListenerChannelContext setChannel(Channel c) {
            this.channel = c;
            super.updateLastUseTime();
            return this;
        }

        public Channel getChannel() {
            return this.channel;
        }
    }
}

