/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import io.netty.handler.codec.http.cookie.Cookie;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class CookieJar {
    static final String URI_SCHEME_HTTPS = "https";
    Map<String, Set<Cookie>> cookiesByOrigin = new ConcurrentSkipListMap<String, Set<Cookie>>();

    static String buildOrigin(URI uri) {
        return String.format("%s:%d", uri.getHost(), uri.getPort());
    }

    public void add(URI uri, Cookie cookie) {
        String origin = CookieJar.buildOrigin(uri);
        Set<Cookie> byOrigin = this.cookiesByOrigin.get(origin);
        if (byOrigin == null) {
            this.cookiesByOrigin.putIfAbsent(origin, new ConcurrentSkipListSet());
            byOrigin = this.cookiesByOrigin.get(origin);
        }
        byOrigin.add(cookie);
    }

    public Map<String, String> list(URI uri) {
        HashMap<String, String> result = new HashMap<String, String>();
        String origin = CookieJar.buildOrigin(uri);
        Set<Cookie> byOrigin = this.cookiesByOrigin.get(origin);
        if (byOrigin != null) {
            for (Cookie cookie : byOrigin) {
                if (cookie.isSecure() && !uri.getScheme().equals(URI_SCHEME_HTTPS)) continue;
                result.put(cookie.name(), cookie.value());
            }
        }
        return result;
    }

    public static String encodeCookies(Map<String, String> cookies) {
        Iterator<Map.Entry<String, String>> it = cookies.entrySet().iterator();
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (it.hasNext()) {
            if (i++ > 0) {
                buf.append("; ");
            }
            Map.Entry<String, String> e = it.next();
            buf.append(e.getKey()).append("=").append(e.getValue());
        }
        return buf.toString();
    }

    public static Map<String, String> decodeCookies(String header) {
        HashMap<String, String> cookies = new HashMap<String, String>();
        String[] cookiePairs = header.split(";");
        if (cookiePairs.length != 0) {
            for (String cookiePair : cookiePairs) {
                String[] keyVal = cookiePair.split("=");
                if (keyVal.length != 2) continue;
                cookies.put(keyVal[0].trim(), keyVal[1].trim());
            }
        }
        return cookies;
    }

    public boolean isEmpty() {
        return this.cookiesByOrigin.isEmpty();
    }
}

