/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceStats;
import java.util.EnumSet;

public final class ServiceStatUtils {
    private ServiceStatUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceStats.ServiceStat getHistogramStat(Service service, String name) {
        ServiceStats.ServiceStat stat;
        if (!service.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return null;
        }
        ServiceStats.ServiceStat serviceStat = stat = service.getStat(name);
        synchronized (serviceStat) {
            if (stat.logHistogram == null) {
                stat.logHistogram = new ServiceStats.ServiceStatLogHistogram();
            }
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceStats.ServiceStat getTimeSeriesStat(Service service, String name, int numBins, long binDurationMillis, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationType) {
        ServiceStats.ServiceStat stat;
        if (!service.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return null;
        }
        ServiceStats.ServiceStat serviceStat = stat = service.getStat(name);
        synchronized (serviceStat) {
            if (stat.timeSeriesStats == null) {
                stat.timeSeriesStats = new ServiceStats.TimeSeriesStats(numBins, binDurationMillis, aggregationType);
            } else if (!stat.timeSeriesStats.aggregationType.equals(aggregationType)) {
                throw new IllegalStateException("Mismatched aggregation type " + stat.timeSeriesStats.aggregationType);
            }
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceStats.ServiceStat getTimeSeriesHistogramStat(Service service, String name, int numBins, long binDurationMillis, EnumSet<ServiceStats.TimeSeriesStats.AggregationType> aggregationType) {
        ServiceStats.ServiceStat stat;
        if (!service.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            return null;
        }
        ServiceStats.ServiceStat serviceStat = stat = service.getStat(name);
        synchronized (serviceStat) {
            if (stat.logHistogram == null) {
                stat.logHistogram = new ServiceStats.ServiceStatLogHistogram();
            }
            if (stat.timeSeriesStats == null) {
                stat.timeSeriesStats = new ServiceStats.TimeSeriesStats(numBins, binDurationMillis, aggregationType);
            } else if (!stat.timeSeriesStats.aggregationType.equals(aggregationType)) {
                throw new IllegalStateException("Mismatched aggregation type " + stat.timeSeriesStats.aggregationType);
            }
        }
        return stat;
    }
}

