/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.services.common.QueryFilter;
import java.util.logging.Level;

public final class QueryFilterUtils {
    private QueryFilterUtils() {
    }

    public static ServiceDocument getServiceState(Operation op, ServiceHost host) {
        Service s = host.findService(op.getUri().getPath());
        if (s == null) {
            return null;
        }
        Class<? extends ServiceDocument> type = s.getStateType();
        if (type == null) {
            return null;
        }
        return op.getBody(type);
    }

    public static boolean evaluate(QueryFilter filter, ServiceDocument state, ServiceHost host) {
        ServiceDocumentDescription sdd = host.buildDocumentDescription(state.documentSelfLink);
        if (sdd == null) {
            host.log(Level.WARNING, "Description not found for %s", state.documentSelfLink);
            return false;
        }
        return QueryFilterUtils.evaluate(filter, state, sdd);
    }

    public static boolean evaluate(QueryFilter filter, ServiceDocument state, ServiceDocumentDescription sdd) {
        return filter.evaluate(state, sdd);
    }
}

