/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.ConsistentHashingNodeSelectorService;
import java.util.EnumSet;
import java.util.Map;

public class NodeSelectorForwardingService
extends StatelessService {
    private ConsistentHashingNodeSelectorService parent;

    public NodeSelectorForwardingService(ConsistentHashingNodeSelectorService parent) {
        super(ServiceDocument.class);
        super.toggleOption(Service.ServiceOption.UTILITY, true);
        this.parent = parent;
        super.setSelfLink(UriUtils.buildUriPath(this.parent.getSelfLink(), "forwarding"));
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation op) {
        Map<String, String> params = UriUtils.parseUriQueryParams(op.getUri());
        String link = params.get("path");
        if (link == null) {
            if (params.isEmpty() && op.getAction() == Service.Action.DELETE) {
                super.handleRequest(op);
                return;
            }
            op.fail(new IllegalArgumentException("link uri parameter is required"));
            return;
        }
        String key = params.get("key");
        if (link.equals(this.getSelfLink())) {
            op.fail(new IllegalArgumentException("link can not be this service"));
            return;
        }
        String destination = params.get("target");
        if (destination == null) {
            op.fail(new IllegalArgumentException("destination uri parameter is required"));
            return;
        }
        String query = params.get("query");
        NodeSelectorService.SelectAndForwardRequest body = new NodeSelectorService.SelectAndForwardRequest();
        body.key = key;
        body.targetPath = link;
        body.targetQuery = query == null || query.isEmpty() ? null : query;
        body.options = EnumSet.noneOf(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.class);
        if (destination.equals(UriUtils.ForwardingTarget.ALL.toString())) {
            body.options.add(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.BROADCAST);
        } else {
            body.options.add(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.UNICAST);
        }
        if (destination.equals(UriUtils.ForwardingTarget.PEER_ID.toString())) {
            String peerId = params.get("peer");
            if (peerId == null) {
                op.fail(new IllegalArgumentException("peer uri parameter is required"));
                return;
            }
            body.key = peerId;
        }
        this.parent.selectAndForward(op, body);
    }
}

