/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyFullHttpRequest;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import java.lang.reflect.Field;

public class NettyHttpToHttp2Handler
extends HttpToHttp2ConnectionHandler {
    public NettyHttpToHttp2Handler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders) {
        super(decoder, encoder, initialSettings, validateHeaders);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.associateOperationAndStreamId(msg);
        super.write(ctx, msg, promise);
    }

    private void associateOperationAndStreamId(Object msg) {
        int currentStreamId;
        if (!(msg instanceof NettyFullHttpRequest)) {
            return;
        }
        NettyFullHttpRequest request = (NettyFullHttpRequest)((Object)msg);
        Operation operation = request.getOperation();
        if (operation == null) {
            return;
        }
        try {
            currentStreamId = this.getStreamId(request.headers());
        }
        catch (Exception ex) {
            Utils.logWarning("Failed to retrieve streamId: %s", Utils.toString(ex));
            operation.fail(new RuntimeException("Failed to retrieve streamId", ex));
            return;
        }
        NettyChannelContext socketContext = (NettyChannelContext)operation.getSocketContext();
        if (socketContext == null) {
            return;
        }
        Operation oldOperation = socketContext.getOperationForStream(currentStreamId);
        if (oldOperation == null || oldOperation.getId() == operation.getId()) {
            socketContext.setOperationForStream(currentStreamId, operation);
            return;
        }
        long oldOpId = oldOperation.getId();
        long opId = operation.getId();
        Utils.logWarning("Reusing stream %d. opId=%d, oldOpId=%d", currentStreamId, opId, oldOpId);
        IllegalStateException e = new IllegalStateException("HTTP/2 Stream ID collision for id " + currentStreamId);
        ServiceErrorResponse rsp = ServiceErrorResponse.createWithShouldRetry(e);
        oldOperation.setRetryCount(1);
        operation.setRetryCount(1);
        socketContext.setOperation(null);
        socketContext.removeOperationForStream(currentStreamId);
        socketContext.close();
        oldOperation.setBodyNoCloning(rsp).fail(e, rsp.statusCode);
        operation.setBodyNoCloning(rsp).fail(e, rsp.statusCode);
    }

    private int getStreamId(HttpHeaders httpHeaders) {
        Integer streamId = httpHeaders.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId != null) {
            return streamId;
        }
        return this.getDefaultStreamId();
    }

    private int getDefaultStreamId() {
        Http2Connection.Endpoint endpoint = this.connection().local();
        Field field = ReflectionUtils.getField(endpoint.getClass(), "nextReservationStreamId");
        try {
            int nextReservationStreamId = field.getInt(endpoint);
            return nextReservationStreamId >= 0 ? nextReservationStreamId + 2 : nextReservationStreamId;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

