/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.ServiceRequestSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public class OperationJoin {
    private static final int APPROXIMATE_EXPECTED_CAPACITY = 4;
    public static final String ERROR_MSG_BATCH_LIMIT_VIOLATED = "batch limit violated";
    public static final String ERROR_MSG_INVALID_BATCH_SIZE = "batch size must be greater than 0";
    public static final String ERROR_MSG_OPERATIONS_ALREADY_SET = "operations have already been set";
    private final ConcurrentHashMap<Long, Operation> operations;
    private ConcurrentHashMap<Long, Throwable> failures;
    JoinedCompletionHandler joinedCompletion;
    private OperationContext opContext;
    private final AtomicInteger pendingCount = new AtomicInteger();
    private final AtomicInteger batchSizeGuard = new AtomicInteger();
    private int batchSize = 0;
    private Iterator<Operation> operationIterator;
    private ServiceRequestSender sender;
    private final Object failuresLock = new Object();
    private String transactionId;

    private OperationJoin() {
        this.operations = new ConcurrentHashMap(4);
        this.opContext = OperationContext.getOperationContext();
    }

    public static OperationJoin create() {
        return new OperationJoin();
    }

    public static OperationJoin create(Operation ... ops) {
        OperationJoin joinOp = new OperationJoin();
        joinOp.setOperations(ops);
        return joinOp;
    }

    public static OperationJoin create(Collection<Operation> ops) {
        OperationJoin joinOp = new OperationJoin();
        joinOp.setOperations(ops);
        return joinOp;
    }

    public static OperationJoin create(Stream<Operation> ops) {
        OperationJoin joinOp = new OperationJoin();
        joinOp.setOperations(ops);
        return joinOp;
    }

    public OperationJoin setOperations(Operation ... ops) {
        if (ops.length == 0) {
            throw new IllegalArgumentException("At least one operation to join expected");
        }
        if (this.operationIterator != null) {
            throw new IllegalStateException(ERROR_MSG_OPERATIONS_ALREADY_SET);
        }
        for (Operation op : ops) {
            this.prepareOperation(op);
        }
        this.operationIterator = this.operations.values().iterator();
        return this;
    }

    public OperationJoin setOperations(Collection<Operation> ops) {
        if (ops.isEmpty()) {
            throw new IllegalArgumentException("At least one operation to join expected");
        }
        if (this.operationIterator != null) {
            throw new IllegalStateException(ERROR_MSG_OPERATIONS_ALREADY_SET);
        }
        for (Operation op : ops) {
            this.prepareOperation(op);
        }
        this.operationIterator = this.operations.values().iterator();
        return this;
    }

    public OperationJoin setOperations(Stream<Operation> ops) {
        if (this.operationIterator != null) {
            throw new IllegalStateException(ERROR_MSG_OPERATIONS_ALREADY_SET);
        }
        ops.forEach(this::prepareOperation);
        this.operationIterator = this.operations.values().iterator();
        if (this.isEmpty()) {
            throw new IllegalArgumentException("At least one operation to join expected");
        }
        return this;
    }

    private void prepareOperation(Operation op) {
        this.operations.put(op.getId(), op);
        if (this.transactionId != null) {
            op.setTransactionId(this.transactionId);
        }
        op.nestCompletion(this::parentCompletion);
        this.pendingCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parentCompletion(Operation o, Throwable e) {
        if (e != null) {
            Object object = this.failuresLock;
            synchronized (object) {
                if (this.failures == null) {
                    this.failures = new ConcurrentHashMap();
                }
            }
            this.failures.put(o.getId(), e);
        }
        Operation originalOp = this.getOperation(o.getId());
        originalOp.setStatusCode(o.getStatusCode()).transferResponseHeadersFrom(o).setBodyNoCloning(o.getBodyRaw());
        this.batchSizeGuard.decrementAndGet();
        this.sendNext();
        if (this.pendingCount.decrementAndGet() != 0) {
            return;
        }
        OperationContext.restoreOperationContext(this.opContext);
        for (Operation op : this.operations.values()) {
            Throwable t = null;
            if (this.failures != null) {
                t = this.failures.get(op.getId());
            }
            if (t != null) {
                op.fail(t);
                continue;
            }
            op.complete();
        }
        if (this.joinedCompletion != null) {
            this.joinedCompletion.handle(this.operations, this.failures);
        }
    }

    private void sendWithBatch() {
        if (this.operationIterator == null || !this.operationIterator.hasNext()) {
            throw new IllegalStateException("No operations to be sent");
        }
        ArrayList<Operation> batch = new ArrayList<Operation>();
        int count = 0;
        while (this.operationIterator.hasNext()) {
            batch.add(this.operationIterator.next());
            if (this.batchSize <= 0 || ++count != this.batchSize) continue;
        }
        for (Operation op : batch) {
            this.sendOperation(op);
            if (this.batchSize <= 0 || this.batchSizeGuard.incrementAndGet() <= this.batchSize) continue;
            throw new IllegalStateException(ERROR_MSG_BATCH_LIMIT_VIOLATED);
        }
    }

    private void sendOperation(Operation op) {
        this.sender.sendRequest(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNext() {
        if (this.sender == null) {
            return;
        }
        Operation op = null;
        Iterator<Operation> iterator = this.operationIterator;
        synchronized (iterator) {
            if (this.operationIterator.hasNext()) {
                op = this.operationIterator.next();
            }
        }
        if (op != null) {
            if (this.batchSize > 0 && this.batchSizeGuard.incrementAndGet() > this.batchSize) {
                throw new IllegalStateException(ERROR_MSG_BATCH_LIMIT_VIOLATED);
            }
            this.sendOperation(op);
        }
    }

    public void sendWith(ServiceRequestSender sender, int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException(ERROR_MSG_INVALID_BATCH_SIZE);
        }
        this.batchSize = batchSize;
        this.sendWith(sender);
    }

    public void sendWith(ServiceRequestSender sender) {
        if (sender == null) {
            throw new IllegalArgumentException("host must not be null.");
        }
        this.sender = sender;
        this.sendWithBatch();
    }

    public OperationJoin setCompletion(JoinedCompletionHandler joinedCompletion) {
        this.joinedCompletion = joinedCompletion;
        return this;
    }

    OperationContext getOperationContext() {
        return this.opContext;
    }

    void setOperationContext(OperationContext opContext) {
        this.opContext = opContext;
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    public Collection<Operation> getOperations() {
        return this.operations.values();
    }

    public Map<Long, Throwable> getFailures() {
        return this.failures;
    }

    public Operation getOperation(long id) {
        return this.operations.get(id);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public OperationJoin setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    void fail(Throwable t) {
        this.failures = new ConcurrentHashMap();
        this.failures.put(this.operations.keys().nextElement(), t);
        OperationContext origContext = OperationContext.getOperationContext();
        OperationContext.restoreOperationContext(this.opContext);
        for (Operation op : this.operations.values()) {
            op.fail(t);
        }
        OperationContext.restoreOperationContext(origContext);
    }

    @FunctionalInterface
    public static interface JoinedCompletionHandler {
        public void handle(Map<Long, Operation> var1, Map<Long, Throwable> var2);
    }
}

