/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

public class FNVHash {
    public static final long FNV_PRIME = 1099511628211L;
    public static final long FNV_OFFSET_MINUS_MSB = 4695981039346656037L;

    private FNVHash() {
    }

    public static long compute(CharSequence data) {
        return FNVHash.compute(data, 4695981039346656037L);
    }

    public static long compute(CharSequence data, long hash) {
        int length = data.length();
        for (int pos = 0; pos < length; ++pos) {
            char code = data.charAt(pos);
            hash ^= (long)(code + code << 8);
            hash *= 1099511628211L;
        }
        return hash;
    }

    public static long compute(int code, long hash) {
        hash ^= (long)(code + code << 8);
        return hash *= 1099511628211L;
    }

    public static int compute32(CharSequence data) {
        return FNVHash.compute32(data, 4695981039346656037L);
    }

    public static int compute32(CharSequence data, long hash) {
        hash = FNVHash.compute(data, hash);
        return (int)(hash >> 31 | 0xFFFFFFFFL & hash);
    }

    public static long compute(byte[] data, int offset, int length) {
        return FNVHash.compute(data, offset, length, 4695981039346656037L);
    }

    public static long compute(byte[] data, int offset, int length, long hash) {
        for (int i = offset; i < length; ++i) {
            byte code = data[i];
            hash ^= (long)code;
            hash *= 1099511628211L;
        }
        return hash;
    }
}

