/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.AuthCredentialsService;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ResourceGroupService;
import com.vmware.xenon.services.common.RoleService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.UserGroupService;
import com.vmware.xenon.services.common.UserService;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.logging.Level;

public class AuthorizationSetupHelper {
    private String userEmail;
    private String userPassword;
    private boolean isAdmin;
    private String documentKind;
    private String documentLink;
    private ServiceHost host;
    private AuthSetupCompletion completion;
    private boolean updateUserGroupForUser = false;
    private UserCreationStep currentStep;
    private URI referer;
    private String userSelfLink;
    private String userGroupSelfLink;
    private String resourceGroupSelfLink;
    private String roleSelfLink;
    private QueryTask.Query userGroupQuery;
    private QueryTask.Query resourceQuery;
    private EnumSet<Service.Action> verbs;
    private RoleService.Policy policy = RoleService.Policy.ALLOW;
    private String failureMessage;

    public static AuthorizationSetupHelper create() {
        return new AuthorizationSetupHelper();
    }

    public AuthorizationSetupHelper setUserEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    public AuthorizationSetupHelper setUserPassword(String userPassword) {
        this.userPassword = userPassword;
        return this;
    }

    public AuthorizationSetupHelper setUserSelfLink(String userSelfLink) {
        this.userSelfLink = userSelfLink;
        return this;
    }

    public AuthorizationSetupHelper setIsAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
        return this;
    }

    public AuthorizationSetupHelper setUpdateUserGroupForUser(boolean updateUserGroupForUser) {
        this.updateUserGroupForUser = updateUserGroupForUser;
        return this;
    }

    public AuthorizationSetupHelper setDocumentKind(String documentKind) {
        this.documentKind = documentKind;
        return this;
    }

    public AuthorizationSetupHelper setDocumentLink(String documentLink) {
        this.documentLink = documentLink;
        return this;
    }

    public AuthorizationSetupHelper setHost(ServiceHost host) {
        this.host = host;
        this.referer = host.getPublicUri();
        return this;
    }

    public AuthorizationSetupHelper setCompletion(AuthSetupCompletion completion) {
        this.completion = completion;
        return this;
    }

    public AuthorizationSetupHelper setCompletion(Operation.CompletionHandler completion) {
        this.completion = ex -> completion.handle(null, ex);
        return this;
    }

    public AuthorizationSetupHelper setUserGroupQuery(QueryTask.Query userGroupQuery) {
        this.userGroupQuery = userGroupQuery;
        return this;
    }

    public AuthorizationSetupHelper setResourceQuery(QueryTask.Query resourceQuery) {
        this.resourceQuery = resourceQuery;
        return this;
    }

    public AuthorizationSetupHelper setVerbs(EnumSet<Service.Action> verbs) {
        this.verbs = verbs;
        return this;
    }

    public AuthorizationSetupHelper setPolicy(RoleService.Policy policy) {
        this.policy = policy;
        return this;
    }

    public AuthorizationSetupHelper setUserGroupName(String userGroupName) {
        this.userGroupSelfLink = userGroupName;
        return this;
    }

    public AuthorizationSetupHelper setResourceGroupName(String resourceGroupName) {
        this.resourceGroupSelfLink = resourceGroupName;
        return this;
    }

    public AuthorizationSetupHelper setRoleName(String roleName) {
        this.roleSelfLink = roleName;
        return this;
    }

    public AuthorizationSetupHelper start() {
        this.validate();
        this.currentStep = UserCreationStep.QUERY_USER;
        this.setupUser();
        return this;
    }

    public AuthorizationSetupHelper setupRole() {
        this.validateForRoleSetup();
        this.currentStep = UserCreationStep.MAKE_USER_GROUP;
        this.makeUserGroup();
        return this;
    }

    private void validate() {
        if (this.userEmail == null) {
            throw new IllegalStateException("Missing user email");
        }
        if (this.userPassword == null) {
            throw new IllegalStateException("Missing user password");
        }
        if (this.host == null) {
            throw new IllegalStateException("Missing host");
        }
        if (this.resourceQuery == null && !this.isAdmin && this.documentKind == null && this.documentLink == null) {
            throw new IllegalStateException("User has access to nothing");
        }
    }

    private void validateForRoleSetup() {
        if (this.host == null) {
            throw new IllegalStateException("Missing host");
        }
        if (this.userEmail != null || this.userPassword != null) {
            throw new IllegalStateException("User email and password are not required during role setup");
        }
        if (this.userGroupQuery == null && this.userSelfLink == null) {
            throw new IllegalStateException("No user specified");
        }
        if (this.resourceQuery == null && !this.isAdmin && this.documentKind != null && this.userSelfLink == null) {
            throw new IllegalStateException("No user specified");
        }
        if (this.resourceQuery == null && !this.isAdmin && this.documentKind == null && this.documentLink == null) {
            throw new IllegalStateException("User has access to nothing");
        }
    }

    private void setupUser() {
        switch (this.currentStep) {
            case QUERY_USER: {
                this.queryUser();
                break;
            }
            case MAKE_USER: {
                this.makeUser();
                break;
            }
            case MAKE_CREDENTIALS: {
                this.makeCredentials();
                break;
            }
            case MAKE_USER_GROUP: {
                this.makeUserGroup();
                break;
            }
            case UPDATE_USERGROUP_FOR_USER: {
                this.updateUserGroupForUser();
                break;
            }
            case MAKE_RESOURCE_GROUP: {
                this.makeResourceGroup();
                break;
            }
            case MAKE_ROLE: {
                this.makeRole();
                break;
            }
            case SUCCESS: {
                this.printUserDetails();
                break;
            }
            case FAILURE: {
                this.handleFailure();
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unhandled user setup step: %s", new Object[]{this.currentStep}));
            }
        }
    }

    private void queryUser() {
        QueryTask.Query userQuery = QueryTask.Query.Builder.create().addFieldClause("documentKind", Utils.buildKind(UserService.UserState.class)).addFieldClause("email", this.userEmail).build();
        QueryTask queryTask = QueryTask.Builder.createDirectTask().setQuery(userQuery).build();
        URI queryTaskUri = UriUtils.buildUri(this.host, ServiceUriPaths.CORE_QUERY_TASKS);
        Operation postQuery = Operation.createPost(queryTaskUri).setBody(queryTask).setReferer(this.referer).setCompletion((Operation op, Throwable ex) -> {
            if (ex != null) {
                this.failureMessage = String.format("Could not query user %s: %s", this.userEmail, ex);
                this.currentStep = UserCreationStep.FAILURE;
                this.setupUser();
                return;
            }
            QueryTask queryResponse = op.getBody(QueryTask.class);
            if (queryResponse.results.documentLinks != null && queryResponse.results.documentLinks.isEmpty()) {
                this.currentStep = UserCreationStep.MAKE_USER;
                this.setupUser();
                return;
            }
            this.host.log(Level.INFO, "User %s already exists, skipping setup of user", this.userEmail);
            if (this.completion != null) {
                this.completion.handle(null);
            }
        });
        this.host.sendRequest(postQuery);
    }

    private void makeUser() {
        UserService.UserState user = new UserService.UserState();
        user.email = this.userEmail;
        if (this.userSelfLink != null) {
            user.documentSelfLink = this.userSelfLink;
        }
        URI userFactoryUri = UriUtils.buildUri(this.host, ServiceUriPaths.CORE_AUTHZ_USERS);
        Operation postUser = Operation.createPost(userFactoryUri).setBody(user).setReferer(this.referer).setCompletion((Operation op, Throwable ex) -> {
            if (ex != null) {
                this.failureMessage = String.format("Could not make user %s: %s", this.userEmail, ex);
                this.currentStep = UserCreationStep.FAILURE;
                this.setupUser();
                return;
            }
            UserService.UserState userResponse = op.getBody(UserService.UserState.class);
            this.userSelfLink = this.normalizeLink(UserService.FACTORY_LINK, userResponse.documentSelfLink);
            this.currentStep = UserCreationStep.MAKE_CREDENTIALS;
            this.setupUser();
        });
        this.addReplicationFactor(postUser);
        this.host.sendRequest(postUser);
    }

    private void makeCredentials() {
        AuthCredentialsService.AuthCredentialsServiceState auth = new AuthCredentialsService.AuthCredentialsServiceState();
        auth.userEmail = this.userEmail;
        auth.privateKey = this.userPassword;
        URI credentialFactoryUri = UriUtils.buildUri(this.host, "/core/auth/credentials");
        Operation postCreds = Operation.createPost(credentialFactoryUri).setBody(auth).setReferer(this.referer).setCompletion((Operation op, Throwable ex) -> {
            if (ex != null) {
                this.failureMessage = String.format("Could not make credentials for user %s: %s", this.userEmail, ex);
                this.currentStep = UserCreationStep.FAILURE;
                this.setupUser();
                return;
            }
            this.currentStep = UserCreationStep.MAKE_USER_GROUP;
            this.setupUser();
        });
        this.addReplicationFactor(postCreds);
        this.host.sendRequest(postCreds);
    }

    private void makeUserGroup() {
        QueryTask.Query userGroupQuery = this.userGroupQuery == null ? QueryTask.Query.Builder.create().setTerm("documentSelfLink", this.userSelfLink).build() : this.userGroupQuery;
        UserGroupService.UserGroupState group = new UserGroupService.UserGroupState();
        group.query = userGroupQuery;
        group.documentSelfLink = this.userGroupSelfLink;
        URI userGroupFactoryUri = UriUtils.buildUri(this.host, ServiceUriPaths.CORE_AUTHZ_USER_GROUPS);
        Operation postGroup = Operation.createPost(userGroupFactoryUri).addPragmaDirective("xn-force-index-update").setBody(group).setReferer(this.referer).setCompletion((Operation op, Throwable ex) -> {
            if (ex != null) {
                this.failureMessage = String.format("Could not make user group for user %s: %s", this.userEmail, ex);
                this.currentStep = UserCreationStep.FAILURE;
                this.setupUser();
                return;
            }
            UserGroupService.UserGroupState groupResponse = op.getBody(UserGroupService.UserGroupState.class);
            this.userGroupSelfLink = this.normalizeLink(UserGroupService.FACTORY_LINK, groupResponse.documentSelfLink);
            this.currentStep = UserCreationStep.UPDATE_USERGROUP_FOR_USER;
            this.setupUser();
        });
        this.addReplicationFactor(postGroup);
        this.host.sendRequest(postGroup);
    }

    private void updateUserGroupForUser() {
        if (!this.updateUserGroupForUser) {
            this.currentStep = UserCreationStep.MAKE_RESOURCE_GROUP;
            this.setupUser();
            return;
        }
        UserService.UserState userState = new UserService.UserState();
        userState.userGroupLinks = Collections.singleton(this.userGroupSelfLink);
        Operation patchUser = Operation.createPatch(UriUtils.buildUri(this.host, this.userSelfLink)).setBody(userState).setReferer(this.referer).setCompletion((Operation op, Throwable ex) -> {
            if (ex != null) {
                this.failureMessage = String.format("Could not patch user %s: %s", this.userSelfLink, ex);
                this.currentStep = UserCreationStep.FAILURE;
                this.setupUser();
                return;
            }
            this.currentStep = UserCreationStep.MAKE_RESOURCE_GROUP;
            this.setupUser();
        });
        this.addReplicationFactor(patchUser);
        this.host.sendRequest(patchUser);
    }

    private void makeResourceGroup() {
        QueryTask.Query resourceQuery = null;
        if (this.resourceQuery == null) {
            if (this.isAdmin) {
                resourceQuery = QueryTask.Query.Builder.create().setTerm("documentSelfLink", "*", QueryTask.QueryTerm.MatchType.WILDCARD).build();
            } else if (this.documentKind != null) {
                resourceQuery = QueryTask.Query.Builder.create().addFieldClause("documentAuthPrincipalLink", this.userSelfLink).addFieldClause("documentKind", this.documentKind).build();
            } else if (this.documentLink != null) {
                resourceQuery = this.documentLink.contains("*") ? QueryTask.Query.Builder.create().setTerm("documentSelfLink", this.documentLink, QueryTask.QueryTerm.MatchType.WILDCARD).build() : QueryTask.Query.Builder.create().addFieldClause("documentSelfLink", this.documentLink).build();
            }
        } else {
            resourceQuery = this.resourceQuery;
        }
        ResourceGroupService.ResourceGroupState group = new ResourceGroupService.ResourceGroupState();
        group.query = resourceQuery;
        group.documentSelfLink = this.resourceGroupSelfLink;
        URI resourceGroupFactoryUri = UriUtils.buildUri(this.host, ServiceUriPaths.CORE_AUTHZ_RESOURCE_GROUPS);
        Operation postGroup = Operation.createPost(resourceGroupFactoryUri).addPragmaDirective("xn-force-index-update").setBody(group).setReferer(this.referer).setCompletion((Operation op, Throwable ex) -> {
            if (ex != null) {
                this.failureMessage = String.format("Could not make resource group for user %s: %s", this.userEmail, ex);
                this.currentStep = UserCreationStep.FAILURE;
                this.setupUser();
                return;
            }
            ResourceGroupService.ResourceGroupState groupResponse = op.getBody(ResourceGroupService.ResourceGroupState.class);
            this.resourceGroupSelfLink = this.normalizeLink(ResourceGroupService.FACTORY_LINK, groupResponse.documentSelfLink);
            this.currentStep = UserCreationStep.MAKE_ROLE;
            this.setupUser();
        });
        this.addReplicationFactor(postGroup);
        this.host.sendRequest(postGroup);
    }

    private void makeRole() {
        if (this.verbs == null) {
            this.verbs = EnumSet.allOf(Service.Action.class);
            Collections.addAll(this.verbs, Service.Action.values());
        }
        RoleService.RoleState role = new RoleService.RoleState();
        role.userGroupLink = this.userGroupSelfLink;
        role.resourceGroupLink = this.resourceGroupSelfLink;
        role.verbs = this.verbs;
        role.policy = this.policy;
        role.documentSelfLink = this.roleSelfLink;
        URI roleFactoryUri = UriUtils.buildUri(this.host, ServiceUriPaths.CORE_AUTHZ_ROLES);
        Operation postRole = Operation.createPost(roleFactoryUri).addPragmaDirective("xn-force-index-update").setBody(role).setReferer(this.referer).setCompletion((Operation op, Throwable ex) -> {
            if (ex != null) {
                this.failureMessage = String.format("Could not make role for user %s: %s", this.userEmail, ex);
                this.currentStep = UserCreationStep.FAILURE;
                this.setupUser();
                return;
            }
            RoleService.RoleState roleResponse = op.getBody(RoleService.RoleState.class);
            this.roleSelfLink = this.normalizeLink(RoleService.FACTORY_LINK, roleResponse.documentSelfLink);
            this.currentStep = UserCreationStep.SUCCESS;
            this.setupUser();
        });
        this.addReplicationFactor(postRole);
        this.host.sendRequest(postRole);
    }

    private void addReplicationFactor(Operation op) {
        op.addRequestHeader("x-xenon-rpl-quorum", "x-xenon-all");
    }

    private String normalizeLink(String factoryLink, String documentLink) {
        if (UriUtils.isChildPath(documentLink, factoryLink)) {
            return documentLink;
        }
        String lastPathSegment = UriUtils.getLastPathSegment(documentLink);
        return UriUtils.buildUriPath(factoryLink, lastPathSegment);
    }

    private void printUserDetails() {
        if (this.userEmail != null) {
            this.host.log(Level.INFO, "Created user %s (%s) with credentials, user group (%s) resource group (%s) and role(%s)", this.userEmail, this.userSelfLink, this.userGroupSelfLink, this.resourceGroupSelfLink, this.roleSelfLink);
        } else {
            this.host.log(Level.INFO, "Created user group (%s) resource group (%s) and role (%s)", this.userGroupSelfLink, this.resourceGroupSelfLink, this.roleSelfLink);
        }
        if (this.completion != null) {
            this.completion.handle(null);
        }
    }

    private void handleFailure() {
        this.host.log(Level.WARNING, this.failureMessage, new Object[0]);
        if (this.completion != null) {
            this.completion.handle(new IllegalStateException(this.failureMessage));
        }
    }

    private static enum UserCreationStep {
        QUERY_USER,
        MAKE_USER,
        MAKE_CREDENTIALS,
        MAKE_USER_GROUP,
        UPDATE_USERGROUP_FOR_USER,
        MAKE_RESOURCE_GROUP,
        MAKE_ROLE,
        SUCCESS,
        FAILURE;

    }

    @FunctionalInterface
    public static interface AuthSetupCompletion {
        public void handle(Exception var1);
    }
}

