/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.services.common.AuthorizationCacheUtils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;

public class UserGroupService
extends StatefulService {
    public static final String FACTORY_LINK = ServiceUriPaths.CORE_AUTHZ_USER_GROUPS;

    public static Service createFactory() {
        FactoryService fs = new FactoryService(UserGroupState.class){

            @Override
            public Service createServiceInstance() throws Throwable {
                return new UserGroupService();
            }

            @Override
            public void handlePost(Operation request) {
                UserGroupState userGroupState = AuthorizationCacheUtils.extractBody(request, this, UserGroupState.class);
                if (userGroupState != null) {
                    AuthorizationCacheUtils.clearAuthzCacheForUserGroup(this, request, userGroupState);
                }
                super.handlePost(request);
            }
        };
        fs.toggleOption(Service.ServiceOption.IDEMPOTENT_POST, true);
        return fs;
    }

    public UserGroupService() {
        super(UserGroupState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleRequest(Operation request, Service.OperationProcessingStage opProcessingStage) {
        UserGroupState userGroupState = AuthorizationCacheUtils.extractBody(request, this, UserGroupState.class);
        if (userGroupState != null) {
            AuthorizationCacheUtils.clearAuthzCacheForUserGroup(this, request, userGroupState);
        }
        super.handleRequest(request, opProcessingStage);
    }

    @Override
    public void handleStart(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        UserGroupState newState = op.getBody(UserGroupState.class);
        if (!this.validate(op, newState)) {
            return;
        }
        op.complete();
    }

    @Override
    public void handlePut(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        UserGroupState newState = op.getBody(UserGroupState.class);
        if (!this.validate(op, newState)) {
            return;
        }
        UserGroupState currentState = (UserGroupState)this.getState(op);
        ServiceDocumentDescription documentDescription = this.getStateDescription();
        if (ServiceDocument.equals(documentDescription, currentState, newState)) {
            op.setStatusCode(304);
        } else {
            this.setState(op, newState);
        }
        op.complete();
    }

    private boolean validate(Operation op, UserGroupState state) {
        if (state.query == null) {
            op.fail(new IllegalArgumentException("query is required"));
            return false;
        }
        return true;
    }

    public static class UserGroupState
    extends ServiceDocument {
        public QueryTask.Query query;
    }
}

