/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ResourceGroupService;
import com.vmware.xenon.services.common.RoleService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.UserGroupService;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;

public class AuthorizationCacheUtils {
    public static void clearAuthzCacheForUser(Service s, Operation op, String userLink) {
        if (!AuthorizationCacheUtils.isAuthzCacheClearApplicableOperation(op)) {
            return;
        }
        op.nestCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            if (userLink != null) {
                s.getHost().clearAuthorizationContext(s, userLink);
            }
            op.complete();
        });
    }

    public static void clearAuthzCacheForUserGroup(Service s, Operation op, UserGroupService.UserGroupState userGroupState) {
        if (!AuthorizationCacheUtils.isAuthzCacheClearApplicableOperation(op)) {
            return;
        }
        op.nestCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            if (userGroupState.query == null) {
                op.complete();
                return;
            }
            QueryTask queryTask = new QueryTask();
            queryTask.querySpec = new QueryTask.QuerySpecification();
            queryTask.querySpec.query = userGroupState.query;
            queryTask.setDirect(true);
            Operation postOp = Operation.createPost(s, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS).setBody(queryTask).setCompletion((queryOp, queryEx) -> {
                if (queryEx != null) {
                    op.fail(queryEx);
                    return;
                }
                QueryTask queryTaskResult = queryOp.getBody(QueryTask.class);
                ServiceDocumentQueryResult result = queryTaskResult.results;
                if (result.documentLinks == null || result.documentLinks.isEmpty()) {
                    op.complete();
                    return;
                }
                for (String userLink : result.documentLinks) {
                    s.getHost().clearAuthorizationContext(s, userLink);
                }
                op.complete();
            });
            s.setAuthorizationContext(postOp, s.getSystemAuthorizationContext());
            s.sendRequest(postOp);
        });
    }

    public static void clearAuthzCacheForRole(Service s, Operation op, RoleService.RoleState roleState) {
        if (!AuthorizationCacheUtils.isAuthzCacheClearApplicableOperation(op)) {
            return;
        }
        op.nestCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            if (roleState.userGroupLink == null) {
                op.complete();
                return;
            }
            Operation parentOp = Operation.createGet(s.getHost(), roleState.userGroupLink).setCompletion((getOp, getEx) -> {
                if (getOp.getStatusCode() == 404) {
                    op.complete();
                    return;
                }
                if (getEx != null) {
                    op.setBodyNoCloning(getOp.getBodyRaw()).fail(getOp.getStatusCode());
                    return;
                }
                UserGroupService.UserGroupState userGroupState = getOp.getBody(UserGroupService.UserGroupState.class);
                AuthorizationCacheUtils.clearAuthzCacheForUserGroup(s, op, userGroupState);
                op.complete();
            });
            s.setAuthorizationContext(parentOp, s.getSystemAuthorizationContext());
            s.sendRequest(parentOp);
        });
    }

    public static void clearAuthzCacheForResourceGroup(Service s, Operation op, ResourceGroupService.ResourceGroupState resourceGroupState) {
        if (!AuthorizationCacheUtils.isAuthzCacheClearApplicableOperation(op)) {
            return;
        }
        op.nestCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            QueryTask queryTask = new QueryTask();
            queryTask.querySpec = new QueryTask.QuerySpecification();
            QueryTask.Query resourceGroupQuery = QueryTask.Query.Builder.create().addFieldClause("resourceGroupLink", resourceGroupState.documentSelfLink).addKindFieldClause(RoleService.RoleState.class).build();
            queryTask.querySpec.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
            queryTask.setDirect(true);
            queryTask.querySpec.query = resourceGroupQuery;
            queryTask.setDirect(true);
            Operation postOp = Operation.createPost(s, ServiceUriPaths.CORE_LOCAL_QUERY_TASKS).setBody(queryTask).setCompletion((queryOp, queryEx) -> {
                if (queryEx != null) {
                    op.fail(queryEx);
                    return;
                }
                QueryTask queryTaskResult = queryOp.getBody(QueryTask.class);
                ServiceDocumentQueryResult result = queryTaskResult.results;
                if (result.documents == null || result.documents.isEmpty()) {
                    op.complete();
                    return;
                }
                AtomicInteger completionCount = new AtomicInteger(0);
                Operation.CompletionHandler handler = (subOp, subEx) -> {
                    if (subEx != null) {
                        op.fail(subEx);
                        return;
                    }
                    if (completionCount.incrementAndGet() == result.documents.size()) {
                        op.complete();
                    }
                };
                for (Object doc : result.documents.values()) {
                    RoleService.RoleState roleState = Utils.fromJson(doc, RoleService.RoleState.class);
                    Operation roleOp = new Operation();
                    roleOp.setCompletion(handler);
                    AuthorizationCacheUtils.clearAuthzCacheForRole(s, roleOp, roleState);
                    roleOp.complete();
                }
            });
            s.setAuthorizationContext(postOp, s.getSystemAuthorizationContext());
            s.sendRequest(postOp);
        });
    }

    public static <T extends ServiceDocument> T extractBody(Operation request, Service s, Class<T> clazz) {
        ServiceDocument state = null;
        switch (request.getAction()) {
            case PUT: 
            case POST: {
                state = (ServiceDocument)request.getBody(clazz);
                break;
            }
            case DELETE: {
                if (request.isFromReplication() && request.hasBody()) {
                    state = (ServiceDocument)request.getBody(clazz);
                    break;
                }
                state = s.getState(request);
                break;
            }
        }
        return (T)state;
    }

    private static boolean isAuthzCacheClearApplicableOperation(Operation op) {
        return !op.isFromReplication() || !(op.getAction() == Service.Action.POST ? !op.hasPragmaDirective("xn-created") : !op.isCommit());
    }
}

