/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.jwt;

import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public enum Algorithm {
    HS256("HmacSHA256"),
    HS384("HmacSHA384"),
    HS512("HmacSHA512");

    private String value;

    public static Algorithm fromString(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "HS256": {
                return HS256;
            }
            case "HS384": {
                return HS384;
            }
            case "HS512": {
                return HS512;
            }
        }
        throw new UnknownAlgorithmException(name);
    }

    private Algorithm(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] sign(byte[] payload, byte[] secret) throws GeneralSecurityException {
        Mac mac = Mac.getInstance(this.value);
        mac.init(new SecretKeySpec(secret, this.value));
        return mac.doFinal(payload);
    }

    public static class UnknownAlgorithmException
    extends RuntimeException {
        private static final long serialVersionUID = 7719318497737763328L;

        public UnknownAlgorithmException(String name) {
            super(String.format("Unknown algorithm: %s", name));
        }
    }
}

