/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.http.netty.NettyChannelPool;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class NettyChannelContext
extends Operation.SocketContext {
    static final Logger logger = Logger.getLogger(NettyChannelPool.class.getName());
    static final AttributeKey<Operation> OPERATION_KEY = AttributeKey.valueOf((String)"operation");
    static final AttributeKey<ChannelPromise> SETTINGS_PROMISE_KEY = AttributeKey.valueOf((String)"settings-promise");
    static final AttributeKey<NettyChannelContext> CHANNEL_CONTEXT_KEY = AttributeKey.valueOf((String)"channel-context");
    static final AttributeKey<Boolean> HTTP2_KEY = AttributeKey.valueOf((String)"http2");
    public static final int BUFFER_SIZE = 65536;
    public static final int MAX_INITIAL_LINE_LENGTH = 4096;
    public static final int MAX_HEADER_SIZE = 65536;
    public static final int MAX_CHUNK_SIZE = 65536;
    public static final int MAX_HTTP2_FRAME_SIZE = 65536;
    public static final int INITIAL_HTTP2_WINDOW_SIZE = 65536;
    public static final int DEFAULT_MAX_STREAM_ID = 0x7FFFFFFE;
    private static int maxStreamId = 0x7FFFFFFE;
    public static final PooledByteBufAllocator ALLOCATOR = NettyChannelContext.createAllocator();
    private Channel channel;
    private final NettyChannelPool.NettyChannelGroupKey key;
    private Protocol protocol;
    public final Map<Integer, Operation> streamIdMap;
    private AtomicBoolean openInProgress = new AtomicBoolean(false);
    private int largestStreamId = 0;
    private boolean isPoolStopping;

    static PooledByteBufAllocator createAllocator() {
        int maxOrder = 4;
        return new PooledByteBufAllocator(true, 2, 2, 8192, maxOrder, 64, 32, 16);
    }

    public NettyChannelContext(NettyChannelPool.NettyChannelGroupKey key, Protocol protocol) {
        this.key = key;
        this.protocol = protocol;
        this.streamIdMap = protocol == Protocol.HTTP2 ? new HashMap<Integer, Operation>() : null;
    }

    public NettyChannelContext setChannel(Channel c) {
        this.channel = c;
        this.channel.closeFuture().addListener(future -> {
            if (this.isPoolStopping) {
                return;
            }
            logger.info("Channel closed, ChannelId:" + this.channel.id() + ", Protocol:" + (Object)((Object)this.protocol) + ", NodeChannelGroupKey:" + this.key);
        });
        return this;
    }

    public static void setMaxStreamId(int max) {
        maxStreamId = max;
    }

    public NettyChannelContext setOperation(Operation request) {
        if (this.channel == null) {
            return this;
        }
        if (this.streamIdMap == null) {
            this.channel.attr(OPERATION_KEY).set((Object)request);
        }
        if (request == null) {
            return this;
        }
        request.setSocketContext(this);
        return this;
    }

    public Operation getOperation() {
        Channel ch = this.channel;
        if (ch == null) {
            return null;
        }
        return (Operation)ch.attr(OPERATION_KEY).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation getOperationForStream(int streamId) {
        if (this.streamIdMap == null) {
            throw new IllegalStateException("Internal error: requested operation for stream, but no records");
        }
        Map<Integer, Operation> map = this.streamIdMap;
        synchronized (map) {
            return this.streamIdMap.get(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOperationForStream(int streamId, Operation operation) {
        if (this.streamIdMap == null) {
            throw new IllegalStateException("Internal error: Adding operation for stream, but no records");
        }
        Map<Integer, Operation> map = this.streamIdMap;
        synchronized (map) {
            this.streamIdMap.put(streamId, operation);
            if (streamId > this.largestStreamId) {
                this.largestStreamId = streamId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOperationForStream(int streamId) {
        if (this.streamIdMap == null) {
            return;
        }
        Map<Integer, Operation> map = this.streamIdMap;
        synchronized (map) {
            this.streamIdMap.remove(streamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveStreams() {
        Map<Integer, Operation> map = this.streamIdMap;
        synchronized (map) {
            return !this.streamIdMap.isEmpty();
        }
    }

    public NettyChannelPool.NettyChannelGroupKey getKey() {
        return this.key;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean isOpenInProgress() {
        return this.openInProgress.get();
    }

    public void setOpenInProgress(boolean inProgress) {
        this.openInProgress.set(inProgress);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        boolean isExhausted;
        if (this.protocol == Protocol.HTTP11) {
            throw new IllegalStateException("Internal error: checked for stream exhaustion on HTTP/1.1 connection");
        }
        Map<Integer, Operation> map = this.streamIdMap;
        synchronized (map) {
            isExhausted = this.largestStreamId >= maxStreamId;
        }
        return !isExhausted;
    }

    public int getLargestStreamId() {
        return this.largestStreamId;
    }

    @Override
    public void writeHttpRequest(Object request) {
        this.channel.writeAndFlush(request);
        this.updateLastUseTime();
    }

    public void close(boolean isShutdown) {
        this.isPoolStopping = isShutdown;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Channel c = this.channel;
        this.openInProgress.set(false);
        if (c == null) {
            return;
        }
        if (c.isOpen()) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        IllegalStateException e = new IllegalStateException("Socket channel closed:" + this.key);
        ServiceErrorResponse body = ServiceErrorResponse.createWithShouldRetry(e);
        Operation op = this.getOperation();
        if (op != null) {
            this.setOperation(null);
            op.setStatusCode(body.statusCode);
            op.fail(e, body);
            return;
        }
        if (this.streamIdMap == null || this.streamIdMap.isEmpty()) {
            return;
        }
        ArrayList<Operation> ops = new ArrayList<Operation>();
        Map<Integer, Operation> map = this.streamIdMap;
        synchronized (map) {
            ops.addAll(this.streamIdMap.values());
            this.streamIdMap.clear();
        }
        for (Operation o : ops) {
            o.setStatusCode(body.statusCode);
            o.fail(e, body);
        }
    }

    public static enum Protocol {
        HTTP11,
        HTTP2;

    }
}

