/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceConfigUpdateRequest;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.ServiceSubscriptionState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.UiContentService;
import java.io.NotActiveException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;

public class UtilityService
implements Service {
    private transient Service parent;
    private ServiceStats stats;
    private ServiceSubscriptionState subscriptions;
    private UiContentService uiService;

    public UtilityService setParent(Service parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation op) {
        String uriPrefix = this.parent.getSelfLink() + "/ui";
        if (op.getUri().getPath().startsWith(uriPrefix)) {
            this.handleUiRequest(op);
        } else if (op.getUri().getPath().endsWith("/stats")) {
            this.handleStatsRequest(op);
        } else if (op.getUri().getPath().endsWith("/subscriptions")) {
            this.handleSubscriptionsRequest(op);
        } else if (op.getUri().getPath().endsWith("/template")) {
            this.handleDocumentTemplateRequest(op);
        } else if (op.getUri().getPath().endsWith("/config")) {
            this.parent.handleConfigurationRequest(op);
        } else if (op.getUri().getPath().endsWith("/available")) {
            this.handleAvailableRequest(op);
        } else {
            op.fail(new UnknownHostException());
        }
    }

    @Override
    public void handleCreate(Operation post) {
        post.complete();
    }

    @Override
    public void handleStart(Operation startPost) {
        startPost.complete();
    }

    @Override
    public void handleStop(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation op, Service.OperationProcessingStage opProcessingStage) {
        this.handleRequest(op);
    }

    private void handleAvailableRequest(Operation op) {
        if (op.getAction() == Service.Action.GET) {
            if (this.parent.getProcessingStage() != Service.ProcessingStage.PAUSED && this.parent.getProcessingStage() != Service.ProcessingStage.AVAILABLE) {
                op.fail(503);
                return;
            }
            if (this.stats == null) {
                op.complete();
                return;
            }
            ServiceStats.ServiceStat st = this.getStat("isAvailable", false);
            if (st == null || st.latestValue == 1.0) {
                op.complete();
                return;
            }
            op.fail(503);
        } else if (op.getAction() == Service.Action.PATCH || op.getAction() == Service.Action.PUT) {
            if (!op.hasBody()) {
                op.fail(new IllegalArgumentException("body is required"));
                return;
            }
            ServiceStats.ServiceStat st = op.getBody(ServiceStats.ServiceStat.class);
            if (!"isAvailable".equals(st.name)) {
                op.fail(new IllegalArgumentException("body must be of type ServiceStat and name must be isAvailable"));
                return;
            }
            this.handleStatsRequest(op);
        } else {
            this.getHost().failRequestActionNotSupported(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubscriptionsRequest(Operation op) {
        UtilityService utilityService = this;
        synchronized (utilityService) {
            if (this.subscriptions == null) {
                this.subscriptions = new ServiceSubscriptionState();
                this.subscriptions.subscribers = new ConcurrentSkipListMap<URI, ServiceSubscriptionState.ServiceSubscriber>();
            }
        }
        ServiceSubscriptionState.ServiceSubscriber body = null;
        if (op.hasBody()) {
            body = op.getBody(ServiceSubscriptionState.ServiceSubscriber.class);
            if (body.reference == null) {
                op.fail(new IllegalArgumentException("reference is required"));
                return;
            }
        }
        switch (op.getAction()) {
            case POST: {
                ServiceSubscriptionState serviceSubscriptionState = this.subscriptions;
                synchronized (serviceSubscriptionState) {
                    this.subscriptions.subscribers.put(body.reference, body);
                }
                if (!body.replayState) break;
                URI notificationURI = body.reference;
                this.parent.sendRequest(Operation.createGet(this, this.parent.getSelfLink()).setCompletion((o, e) -> {
                    if (e != null) {
                        op.fail(new IllegalStateException("Unable to get current state"));
                        return;
                    }
                    Operation putOp = Operation.createPut(notificationURI).setBodyNoCloning(o.getBody(this.parent.getStateType())).addPragmaDirective("xn-nt").setReferer(this.getUri());
                    this.parent.sendRequest(putOp);
                }));
                break;
            }
            case DELETE: {
                ServiceSubscriptionState serviceSubscriptionState = this.subscriptions;
                synchronized (serviceSubscriptionState) {
                    this.subscriptions.subscribers.remove(body.reference);
                    break;
                }
            }
            case GET: {
                ServiceDocument rsp;
                ServiceSubscriptionState serviceSubscriptionState = this.subscriptions;
                synchronized (serviceSubscriptionState) {
                    rsp = Utils.clone(this.subscriptions);
                }
                op.setBody(rsp);
                break;
            }
            default: {
                op.fail(new NotActiveException());
            }
        }
        op.complete();
    }

    public boolean hasSubscribers() {
        ServiceSubscriptionState subscriptions = this.subscriptions;
        return subscriptions != null && subscriptions.subscribers != null && !subscriptions.subscribers.isEmpty();
    }

    public void notifySubscribers(Operation op) {
        try {
            if (op.getAction() == Service.Action.GET) {
                return;
            }
            if (!this.hasSubscribers()) {
                return;
            }
            long now = Utils.getNowMicrosUtc();
            Operation clone = op.clone();
            clone.addPragmaDirective("xn-nt");
            for (Map.Entry<URI, ServiceSubscriptionState.ServiceSubscriber> e : this.subscriptions.subscribers.entrySet()) {
                ServiceSubscriptionState.ServiceSubscriber s = e.getValue();
                this.notifySubscriber(now, clone, s);
            }
            if (!this.performSubscriptionsMaintenance(now)) {
                return;
            }
        }
        catch (Throwable e) {
            this.parent.getHost().log(Level.WARNING, "Uncaught exception notifying subscribers for %s: %s", this.parent.getSelfLink(), Utils.toString(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySubscriber(long now, Operation clone, ServiceSubscriptionState.ServiceSubscriber s) {
        ServiceSubscriptionState.ServiceSubscriber serviceSubscriber = s;
        synchronized (serviceSubscriber) {
            if (s.failedNotificationCount != null) {
                clone.addPragmaDirective("xn-nt-skipped");
            }
        }
        Operation.CompletionHandler c = (o, ex) -> {
            s.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
            ServiceSubscriptionState.ServiceSubscriber serviceSubscriber = s;
            synchronized (serviceSubscriber) {
                if (ex != null) {
                    if (s.failedNotificationCount == null) {
                        s.failedNotificationCount = 0L;
                        s.initialFailedNotificationTimeMicros = now;
                    }
                    Long l = s.failedNotificationCount;
                    Long l2 = s.failedNotificationCount = Long.valueOf(s.failedNotificationCount + 1L);
                    return;
                }
                if (s.failedNotificationCount != null) {
                    s.failedNotificationCount = null;
                    s.initialFailedNotificationTimeMicros = null;
                }
            }
        };
        this.parent.sendRequest(clone.setUri(s.reference).setCompletion(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performSubscriptionsMaintenance(long now) {
        ArrayList<URI> subscribersToDelete = null;
        UtilityService utilityService = this;
        synchronized (utilityService) {
            if (this.subscriptions == null) {
                return false;
            }
            Iterator<Map.Entry<URI, ServiceSubscriptionState.ServiceSubscriber>> it = this.subscriptions.subscribers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<URI, ServiceSubscriptionState.ServiceSubscriber> e = it.next();
                ServiceSubscriptionState.ServiceSubscriber s = e.getValue();
                boolean remove = false;
                ServiceSubscriptionState.ServiceSubscriber serviceSubscriber = s;
                synchronized (serviceSubscriber) {
                    if (s.documentExpirationTimeMicros != 0L && s.documentExpirationTimeMicros < now) {
                        remove = true;
                    } else if (s.notificationLimit != null) {
                        if (s.notificationCount == null) {
                            s.notificationCount = 0L;
                        }
                        ServiceSubscriptionState.ServiceSubscriber serviceSubscriber2 = s;
                        serviceSubscriber2.notificationCount = serviceSubscriber2.notificationCount + 1L;
                        if (serviceSubscriber2.notificationCount >= s.notificationLimit) {
                            remove = true;
                        }
                    } else if (s.failedNotificationCount != null && s.failedNotificationCount > 5L && now - s.initialFailedNotificationTimeMicros > this.getHost().getMaintenanceIntervalMicros()) {
                        remove = true;
                    }
                }
                if (!remove) continue;
                it.remove();
                if (subscribersToDelete == null) {
                    subscribersToDelete = new ArrayList<URI>();
                }
                subscribersToDelete.add(s.reference);
            }
        }
        if (subscribersToDelete != null) {
            for (URI subscriber : subscribersToDelete) {
                this.parent.sendRequest(Operation.createDelete(subscriber));
            }
        }
        return true;
    }

    private void handleUiRequest(Operation op) {
        if (op.getAction() != Service.Action.GET) {
            op.fail(new IllegalArgumentException("Action not supported"));
            return;
        }
        if (!this.parent.hasOption(Service.ServiceOption.HTML_USER_INTERFACE)) {
            String servicePath = UriUtils.buildUriPath("/core/ui/default/#", op.getUri().getPath());
            String defaultHtmlPath = UriUtils.buildUriPath(servicePath.substring(0, servicePath.length() - "/ui".length()), "/home");
            this.redirectGetToHtmlUiResource(op, defaultHtmlPath);
            return;
        }
        if (this.uiService == null) {
            this.uiService = new UiContentService(){};
            this.uiService.setHost(this.parent.getHost());
        }
        String selfLink = this.parent.getSelfLink() + "/ui";
        this.uiService.handleUiGet(selfLink, this.parent, op);
    }

    public void redirectGetToHtmlUiResource(Operation op, String htmlResourcePath) {
        try {
            op.addResponseHeader("location", URLDecoder.decode(htmlResourcePath, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        op.setStatusCode(302);
        op.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStatsRequest(Operation op) {
        switch (op.getAction()) {
            case PUT: {
                ServiceStats.ServiceStat stat = op.getBody(ServiceStats.ServiceStat.class);
                if (stat.kind == null) {
                    op.fail(new IllegalArgumentException("kind is required"));
                    return;
                }
                if (stat.kind.equals(ServiceStats.ServiceStat.KIND)) {
                    if (stat.name == null) {
                        op.fail(new IllegalArgumentException("stat name is required"));
                        return;
                    }
                    this.replaceSingleStat(stat);
                } else if (stat.kind.equals(ServiceStats.KIND)) {
                    ServiceStats stats = op.getBody(ServiceStats.class);
                    if (stats.entries == null || stats.entries.isEmpty()) {
                        op.fail(new IllegalArgumentException("stats entries need to be defined"));
                        return;
                    }
                    this.replaceAllStats(stats);
                } else {
                    op.fail(new IllegalArgumentException("operation not supported for kind"));
                    return;
                }
                op.complete();
                break;
            }
            case POST: {
                ServiceStats.ServiceStat newStat = op.getBody(ServiceStats.ServiceStat.class);
                if (newStat.name == null) {
                    op.fail(new IllegalArgumentException("stat name is required"));
                    return;
                }
                ServiceStats.ServiceStat existingStat = this.getStat(newStat.name);
                if (existingStat == null) {
                    op.fail(new IllegalArgumentException("stat does not exist"));
                    return;
                }
                this.initializeOrSetStat(existingStat, newStat);
                op.complete();
                break;
            }
            case DELETE: {
                op.fail(new NotActiveException());
                break;
            }
            case PATCH: {
                ServiceStats.ServiceStat newStat = op.getBody(ServiceStats.ServiceStat.class);
                if (newStat.name == null) {
                    op.fail(new IllegalArgumentException("stat name is required"));
                    return;
                }
                ServiceStats.ServiceStat existingStat = this.getStat(newStat.name, false);
                if (existingStat == null) {
                    op.fail(new IllegalArgumentException("stat to patch does not exist"));
                    return;
                }
                this.adjustStat(existingStat, newStat.latestValue);
                op.complete();
                break;
            }
            case GET: {
                ServiceDocument rsp;
                if (this.stats == null) {
                    ServiceStats s = new ServiceStats();
                    this.populateDocumentProperties(s);
                    op.setBody(s).complete();
                    break;
                }
                ServiceStats serviceStats = this.stats;
                synchronized (serviceStats) {
                    rsp = this.populateDocumentProperties(this.stats);
                    rsp = Utils.clone(rsp);
                }
                op.setBodyNoCloning(rsp);
                op.complete();
                break;
            }
            default: {
                op.fail(new NotActiveException());
            }
        }
    }

    private ServiceStats populateDocumentProperties(ServiceStats stats) {
        ServiceStats clone = new ServiceStats();
        clone.entries = stats.entries;
        clone.documentUpdateTimeMicros = stats.documentUpdateTimeMicros;
        clone.documentSelfLink = UriUtils.buildUriPath(this.parent.getSelfLink(), "/stats");
        clone.documentOwner = this.getHost().getId();
        clone.documentKind = Utils.buildKind(ServiceStats.class);
        return clone;
    }

    private void handleDocumentTemplateRequest(Operation op) {
        if (op.getAction() != Service.Action.GET) {
            op.fail(new NotActiveException());
            return;
        }
        ServiceDocument template = this.parent.getDocumentTemplate();
        String serializedTemplate = Utils.toJsonHtml(template);
        op.setBody(serializedTemplate).complete();
    }

    @Override
    public void handleConfigurationRequest(Operation op) {
        this.parent.handleConfigurationRequest(op);
    }

    public void handlePatchConfiguration(Operation op, ServiceConfigUpdateRequest updateBody) {
        if (updateBody == null) {
            updateBody = op.getBody(ServiceConfigUpdateRequest.class);
        }
        if (!ServiceConfigUpdateRequest.KIND.equals(updateBody.kind)) {
            op.fail(new IllegalArgumentException("Unrecognized kind: " + updateBody.kind));
            return;
        }
        if (updateBody.maintenanceIntervalMicros == null && updateBody.operationQueueLimit == null && updateBody.epoch == null && (updateBody.addOptions == null || updateBody.addOptions.isEmpty()) && (updateBody.removeOptions == null || updateBody.removeOptions.isEmpty())) {
            op.fail(new IllegalArgumentException("At least one configuraton field must be specified"));
            return;
        }
        if (updateBody.addOptions != null) {
            for (Service.ServiceOption c : updateBody.addOptions) {
                this.parent.toggleOption(c, true);
            }
        }
        if (updateBody.removeOptions != null) {
            for (Service.ServiceOption c : updateBody.removeOptions) {
                this.parent.toggleOption(c, false);
            }
        }
        if (updateBody.maintenanceIntervalMicros != null) {
            this.parent.setMaintenanceIntervalMicros(updateBody.maintenanceIntervalMicros);
        }
        op.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeOrSetStat(ServiceStats.ServiceStat stat, ServiceStats.ServiceStat newValue) {
        ServiceStats.ServiceStat serviceStat = stat;
        synchronized (serviceStat) {
            if (stat.timeSeriesStats == null && newValue.timeSeriesStats != null) {
                stat.timeSeriesStats = new ServiceStats.TimeSeriesStats(newValue.timeSeriesStats.numBuckets, newValue.timeSeriesStats.bucketDurationMillis, newValue.timeSeriesStats.aggregationType);
            }
            stat.unit = newValue.unit;
            stat.sourceTimeMicrosUtc = newValue.sourceTimeMicrosUtc;
            this.setStat(stat, newValue.latestValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStat(ServiceStats.ServiceStat stat, double newValue) {
        this.allocateStats();
        ServiceStats.ServiceStat serviceStat = stat;
        synchronized (serviceStat) {
            ++stat.version;
            stat.accumulatedValue += newValue;
            stat.latestValue = newValue;
            if (stat.logHistogram != null) {
                int binIndex = 0;
                if (newValue > 0.0) {
                    binIndex = (int)Math.log10(newValue);
                }
                if (binIndex >= 0 && binIndex < stat.logHistogram.bins.length) {
                    int n = binIndex;
                    stat.logHistogram.bins[n] = stat.logHistogram.bins[n] + 1L;
                }
            }
            stat.lastUpdateMicrosUtc = Utils.getNowMicrosUtc();
            if (stat.timeSeriesStats != null) {
                if (stat.sourceTimeMicrosUtc != null) {
                    stat.timeSeriesStats.add(stat.sourceTimeMicrosUtc, newValue);
                } else {
                    stat.timeSeriesStats.add(stat.lastUpdateMicrosUtc, newValue);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustStat(ServiceStats.ServiceStat stat, double delta) {
        this.allocateStats();
        ServiceStats.ServiceStat serviceStat = stat;
        synchronized (serviceStat) {
            stat.latestValue += delta;
            ++stat.version;
            if (stat.logHistogram != null) {
                int binIndex = 0;
                if (delta > 0.0) {
                    binIndex = (int)Math.log10(delta);
                }
                if (binIndex >= 0 && binIndex < stat.logHistogram.bins.length) {
                    int n = binIndex;
                    stat.logHistogram.bins[n] = stat.logHistogram.bins[n] + 1L;
                }
            }
            stat.lastUpdateMicrosUtc = Utils.getNowMicrosUtc();
            if (stat.timeSeriesStats != null) {
                if (stat.sourceTimeMicrosUtc != null) {
                    stat.timeSeriesStats.add(stat.sourceTimeMicrosUtc, stat.latestValue);
                } else {
                    stat.timeSeriesStats.add(stat.lastUpdateMicrosUtc, stat.latestValue);
                }
            }
        }
    }

    @Override
    public ServiceStats.ServiceStat getStat(String name) {
        return this.getStat(name, true);
    }

    private ServiceStats.ServiceStat getStat(String name, boolean create) {
        if (!this.allocateStats(true)) {
            return null;
        }
        return this.findStat(name, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSingleStat(ServiceStats.ServiceStat stat) {
        if (!this.allocateStats(true)) {
            return;
        }
        ServiceStats serviceStats = this.stats;
        synchronized (serviceStats) {
            ServiceStats.ServiceStat newStat = new ServiceStats.ServiceStat();
            newStat.name = stat.name;
            this.initializeOrSetStat(newStat, stat);
            if (this.stats.entries == null) {
                this.stats.entries = new HashMap<String, ServiceStats.ServiceStat>();
            }
            this.stats.entries.put(stat.name, newStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAllStats(ServiceStats newStats) {
        if (!this.allocateStats(true)) {
            return;
        }
        ServiceStats serviceStats = this.stats;
        synchronized (serviceStats) {
            this.stats.entries.clear();
            for (ServiceStats.ServiceStat currentStat : newStats.entries.values()) {
                this.replaceSingleStat(currentStat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceStats.ServiceStat findStat(String name, boolean create) {
        ServiceStats serviceStats = this.stats;
        synchronized (serviceStats) {
            ServiceStats.ServiceStat st;
            if (this.stats.entries == null) {
                this.stats.entries = new HashMap<String, ServiceStats.ServiceStat>();
            }
            if ((st = this.stats.entries.get(name)) == null && create) {
                st = new ServiceStats.ServiceStat();
                st.name = name;
                this.stats.entries.put(name, st);
            }
            return st;
        }
    }

    private void allocateStats() {
        this.allocateStats(true);
    }

    private synchronized boolean allocateStats(boolean mustAllocate) {
        if (!mustAllocate && this.stats == null) {
            return false;
        }
        if (this.stats != null) {
            return true;
        }
        this.stats = new ServiceStats();
        return true;
    }

    @Override
    public ServiceHost getHost() {
        return this.parent.getHost();
    }

    @Override
    public String getSelfLink() {
        return null;
    }

    @Override
    public URI getUri() {
        return null;
    }

    @Override
    public OperationProcessingChain getOperationProcessingChain() {
        return null;
    }

    @Override
    public Service.ProcessingStage getProcessingStage() {
        return Service.ProcessingStage.AVAILABLE;
    }

    @Override
    public EnumSet<Service.ServiceOption> getOptions() {
        return EnumSet.of(Service.ServiceOption.UTILITY);
    }

    @Override
    public boolean hasOption(Service.ServiceOption cap) {
        return false;
    }

    @Override
    public void toggleOption(Service.ServiceOption cap, boolean enable) {
        throw new RuntimeException();
    }

    @Override
    public void adjustStat(String name, double delta) {
    }

    @Override
    public void setStat(String name, double newValue) {
    }

    @Override
    public void handleMaintenance(Operation post) {
        post.complete();
    }

    @Override
    public void setHost(ServiceHost serviceHost) {
    }

    @Override
    public void setSelfLink(String path) {
    }

    @Override
    public void setOperationProcessingChain(OperationProcessingChain opProcessingChain) {
    }

    @Override
    public void setProcessingStage(Service.ProcessingStage initialized) {
    }

    @Override
    public ServiceDocument setInitialState(String jsonState, Long initialVersion) {
        return null;
    }

    @Override
    public Service getUtilityService(String uriPath) {
        return null;
    }

    @Override
    public boolean queueRequest(Operation op) {
        return false;
    }

    @Override
    public void sendRequest(Operation op) {
        throw new RuntimeException();
    }

    @Override
    public ServiceDocument getDocumentTemplate() {
        return null;
    }

    @Override
    public void setPeerNodeSelectorPath(String uriPath) {
    }

    @Override
    public String getPeerNodeSelectorPath() {
        return null;
    }

    @Override
    public void setState(Operation op, ServiceDocument newState) {
        op.linkState(newState);
    }

    @Override
    public <T extends ServiceDocument> T getState(Operation op) {
        return (T)op.getLinkedState();
    }

    @Override
    public void setMaintenanceIntervalMicros(long micros) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public long getMaintenanceIntervalMicros() {
        return 0L;
    }

    @Override
    public Operation dequeueRequest() {
        return null;
    }

    @Override
    public Class<? extends ServiceDocument> getStateType() {
        return null;
    }

    @Override
    public final void setAuthorizationContext(Operation op, Operation.AuthorizationContext ctx) {
        throw new RuntimeException("Service not allowed to set authorization context");
    }

    @Override
    public final Operation.AuthorizationContext getSystemAuthorizationContext() {
        throw new RuntimeException("Service not allowed to get system authorization context");
    }
}

