/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;

class OperationQueue {
    private int limit;
    private int elementCount;
    private Deque<Operation> store = new ConcurrentLinkedDeque<Operation>();

    public static OperationQueue createFifo(int limit) {
        OperationQueue opDeque = new OperationQueue();
        opDeque.limit = limit;
        return opDeque;
    }

    public static OperationQueue createLifo(int limit) {
        OperationQueue opDeque = new OperationQueue();
        opDeque.limit = -limit;
        return opDeque;
    }

    private OperationQueue() {
    }

    public int getLimit() {
        return Math.abs(this.limit);
    }

    public void setLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be greater than zero");
        }
        this.limit = this.limit < 0 ? -limit : limit;
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public boolean offer(Operation op) {
        if (op == null) {
            throw new IllegalArgumentException("op is required");
        }
        if (this.limit < 0) {
            if (this.elementCount >= -this.limit) {
                return false;
            }
            this.store.offerFirst(op);
            ++this.elementCount;
            return true;
        }
        if (this.elementCount >= this.limit) {
            return false;
        }
        this.store.offerLast(op);
        ++this.elementCount;
        return true;
    }

    public Operation poll() {
        Operation op = this.store.poll();
        if (op == null) {
            return null;
        }
        --this.elementCount;
        if (this.elementCount < 0) {
            throw new IllegalStateException("elementCount is negative");
        }
        return op;
    }

    Collection<Operation> toCollection() {
        ArrayList<Operation> clone = new ArrayList<Operation>(this.elementCount);
        for (Operation op : this.store) {
            clone.add(op);
        }
        return clone;
    }

    public void clear() {
        this.store.clear();
    }
}

