/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.ODataFactoryQueryResult;
import com.vmware.xenon.common.ODataUtils;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.OperationJoin;
import com.vmware.xenon.common.OperationProcessingChain;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.TransactionServiceHelper;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.QueryTaskUtils;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class FactoryService
extends StatelessService {
    public static final Integer SELF_QUERY_RESULT_LIMIT = Integer.getInteger("xenon.FactoryService.SELF_QUERY_RESULT_LIMIT", 1000);
    private EnumSet<Service.ServiceOption> childOptions;
    private String nodeSelectorLink = "/core/node-selectors/default";
    private int selfQueryResultLimit = SELF_QUERY_RESULT_LIMIT;
    private ServiceDocument childTemplate;

    public static FactoryService create(Class<? extends Service> childServiceType, Service.ServiceOption ... options) {
        try {
            Service s = childServiceType.newInstance();
            Class<? extends ServiceDocument> childServiceDocumentType = s.getStateType();
            FactoryService fs = FactoryService.create(childServiceType, childServiceDocumentType, options);
            return fs;
        }
        catch (Throwable e) {
            Utils.logWarning("Failure creating factory for %s: %s", childServiceType, Utils.toString(e));
            return null;
        }
    }

    public static FactoryService create(final Class<? extends Service> childServiceType, Class<? extends ServiceDocument> childServiceDocumentType, Service.ServiceOption ... options) {
        FactoryService fs = new FactoryService(childServiceDocumentType){

            @Override
            public Service createServiceInstance() throws Throwable {
                return (Service)childServiceType.newInstance();
            }
        };
        Arrays.stream(options).forEach(option -> fs.toggleOption((Service.ServiceOption)((Object)option), true));
        return fs;
    }

    public static FactoryService createIdempotent(Class<? extends Service> childServiceType) {
        return FactoryService.create(childServiceType, Service.ServiceOption.IDEMPOTENT_POST);
    }

    public static FactoryService createIdempotent(Class<? extends Service> childServiceType, Class<? extends ServiceDocument> childServiceDocumentType) {
        return FactoryService.create(childServiceType, childServiceDocumentType, Service.ServiceOption.IDEMPOTENT_POST);
    }

    public FactoryService(Class<? extends ServiceDocument> childServiceDocumentType) {
        super(childServiceDocumentType);
        super.toggleOption(Service.ServiceOption.FACTORY, true);
        this.setSelfLink("");
        Service s = this.createChildServiceSafe();
        if (s == null) {
            throw new IllegalStateException("Could not create service of type " + childServiceDocumentType.toString());
        }
        this.setSelfLink(null);
        this.childOptions = s.getOptions();
    }

    public void setSelfQueryResultLimit(int limit) {
        this.selfQueryResultLimit = limit;
    }

    public int getSelfQueryResultLimit() {
        return this.selfQueryResultLimit;
    }

    @Override
    public final void handleStart(Operation startPost) {
        try {
            this.setAvailable(false);
            Service s = this.createChildService();
            s.setHost(this.getHost());
            this.getHost().buildDocumentDescription(s);
            if (this.childOptions.contains((Object)Service.ServiceOption.PERSISTENCE)) {
                this.toggleOption(Service.ServiceOption.PERSISTENCE, true);
            }
            Class<? extends ServiceDocument> childStateTypeDeclaredInChild = s.getStateType();
            if (!this.getStateType().equals(childStateTypeDeclaredInChild)) {
                throw new IllegalArgumentException(String.format("Child service state type %s does not match state type declared in child service class (%s)", this.getStateType(), childStateTypeDeclaredInChild));
            }
            if (s.hasOption(Service.ServiceOption.PERSISTENCE)) {
                byte[] buffer = new byte[8192];
                Utils.toBytes(s, buffer, 0);
            }
        }
        catch (Throwable e2) {
            this.logSevere(e2);
            startPost.fail(e2);
            return;
        }
        if (!ServiceHost.isServiceIndexed(this)) {
            this.setAvailable(true);
            startPost.complete();
            return;
        }
        Operation clonedOp = startPost.clone();
        startPost.complete();
        clonedOp.setCompletion((o, e) -> {
            if (e != null && !this.getHost().isStopping()) {
                this.logWarning("Failure querying index for all child services: %s", e.getMessage());
                return;
            }
            this.setAvailable(true);
            this.logFine("Finished self query for child services", new Object[0]);
        });
        if (!this.childOptions.contains((Object)Service.ServiceOption.REPLICATION)) {
            SynchronizationContext ctx = new SynchronizationContext();
            ctx.originalSelection = null;
            ctx.maintOp = clonedOp;
            this.startOrSynchronizeChildServices(ctx);
            return;
        }
    }

    private void startOrSynchronizeChildServices(SynchronizationContext ctx) {
        QueryTask queryTask;
        if (this.childOptions.contains((Object)Service.ServiceOption.ON_DEMAND_LOAD)) {
            ctx.maintOp.complete();
            return;
        }
        ctx.queryTask = queryTask = this.buildChildQueryTask();
        this.queryForChildren(ctx);
    }

    protected void queryForChildren(SynchronizationContext ctx) {
        URI queryFactoryUri = UriUtils.buildUri(this.getHost(), ServiceUriPaths.CORE_QUERY_TASKS);
        Operation queryPost = Operation.createPost(queryFactoryUri).setBody(ctx.queryTask).setCompletion((o, e) -> {
            if (this.getHost().isStopping()) {
                ctx.maintOp.fail(new CancellationException("host is stopping"));
                return;
            }
            if (e != null) {
                if (!this.getHost().isStopping()) {
                    this.logWarning("Query failed with %s", e.toString());
                }
                ctx.maintOp.fail(e);
                return;
            }
            ServiceDocumentQueryResult rsp = o.getBody(QueryTask.class).results;
            if (rsp == null || rsp.nextPageLink == null) {
                ctx.maintOp.complete();
                return;
            }
            ctx.nextPageReference = UriUtils.buildUri(queryFactoryUri, rsp.nextPageLink);
            this.processChildQueryPage(ctx, true);
        });
        this.sendRequest(queryPost);
    }

    private QueryTask buildChildQueryTask() {
        QueryTask queryTask = new QueryTask();
        queryTask.querySpec = new QueryTask.QuerySpecification();
        queryTask.taskInfo.isDirect = true;
        QueryTask.Query uriPrefixClause = new QueryTask.Query().setTermPropertyName("documentSelfLink").setTermMatchType(QueryTask.QueryTerm.MatchType.WILDCARD).setTermMatchValue(this.getSelfLink() + "/" + "*");
        queryTask.querySpec.query.addBooleanClause(uriPrefixClause);
        QueryTask.Query kindClause = new QueryTask.Query().setTermPropertyName("documentKind").setTermMatchValue(Utils.buildKind(this.getStateType()));
        queryTask.querySpec.query.addBooleanClause(kindClause);
        long timeoutMicros = TimeUnit.SECONDS.toMicros(this.getHost().getPeerSynchronizationTimeLimitSeconds());
        timeoutMicros = Math.max(timeoutMicros, this.getHost().getOperationTimeoutMicros());
        queryTask.documentExpirationTimeMicros = Utils.getNowMicrosUtc() + timeoutMicros;
        queryTask.querySpec.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.BROADCAST);
        queryTask.nodeSelectorLink = this.getPeerNodeSelectorPath();
        queryTask.querySpec.resultLimit = this.selfQueryResultLimit;
        return queryTask;
    }

    private void processChildQueryPage(SynchronizationContext ctx, boolean verifyOwner) {
        if (ctx.nextPageReference == null) {
            ctx.maintOp.complete();
            return;
        }
        if (this.getHost().isStopping()) {
            ctx.maintOp.fail(new CancellationException());
            return;
        }
        if (verifyOwner && this.hasOption(Service.ServiceOption.REPLICATION)) {
            this.verifySynchronizationOwner(ctx);
            return;
        }
        Operation.CompletionHandler c = (o, e) -> {
            if (e != null) {
                if (!this.getHost().isStopping()) {
                    this.logWarning("Failure retrieving query results from %s: %s", ctx.nextPageReference, e.toString());
                }
                ctx.maintOp.fail(new IllegalStateException("failure retrieving query page results"));
                return;
            }
            ServiceDocumentQueryResult rsp = o.getBody(QueryTask.class).results;
            if (rsp.documentCount == 0L || rsp.documentLinks.isEmpty()) {
                ctx.maintOp.complete();
                return;
            }
            this.synchronizeChildrenInQueryPage(ctx, rsp);
        };
        this.sendRequest(Operation.createGet(ctx.nextPageReference).setCompletion(c));
    }

    private void synchronizeChildrenInQueryPage(SynchronizationContext ctx, ServiceDocumentQueryResult rsp) {
        if (this.getProcessingStage() == Service.ProcessingStage.STOPPED) {
            ctx.maintOp.fail(new CancellationException());
            return;
        }
        ServiceMaintenanceRequest smr = null;
        if (ctx.maintOp.hasBody()) {
            smr = ctx.maintOp.getBody(ServiceMaintenanceRequest.class);
        }
        AtomicInteger pendingStarts = new AtomicInteger(rsp.documentLinks.size());
        Operation.CompletionHandler c = (so, se) -> {
            int r = pendingStarts.decrementAndGet();
            if (se != null && !this.getHost().isStopping()) {
                this.logWarning("Restart for children failed: %s", se.getMessage());
            }
            if (this.getHost().isStopping()) {
                ctx.maintOp.fail(new CancellationException());
                return;
            }
            if (r != 0) {
                return;
            }
            ctx.nextPageReference = rsp.nextPageLink == null ? null : UriUtils.buildUri(ctx.nextPageReference, rsp.nextPageLink);
            this.processChildQueryPage(ctx, true);
        };
        for (String link : rsp.documentLinks) {
            if (this.getHost().isStopping()) {
                ctx.maintOp.fail(new CancellationException());
                return;
            }
            Operation post = Operation.createPost(this, link).setCompletion(c).setReferer(this.getUri());
            this.startOrSynchChildService(link, post, smr);
        }
    }

    private void startOrSynchChildService(String link, Operation post, ServiceMaintenanceRequest smr) {
        try {
            Service child = this.createChildService();
            NodeGroupService.NodeGroupState ngs = smr != null ? smr.nodeGroupState : null;
            this.getHost().startOrSynchService(post, child, ngs);
        }
        catch (Throwable e1) {
            this.logSevere(e1);
            post.fail(e1);
        }
    }

    @Override
    public void authorizeRequest(Operation op) {
        op.complete();
    }

    @Override
    public void handleRequest(Operation op) {
        this.handleRequest(op, Service.OperationProcessingStage.PROCESSING_FILTERS);
    }

    @Override
    public void handleRequest(Operation op, Service.OperationProcessingStage opProcessingStage) {
        if (op.getAction() == Service.Action.POST) {
            if (opProcessingStage == Service.OperationProcessingStage.PROCESSING_FILTERS) {
                OperationProcessingChain opProcessingChain = this.getOperationProcessingChain();
                if (opProcessingChain != null && !opProcessingChain.processRequest(op)) {
                    return;
                }
                opProcessingStage = Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER;
            }
            if (opProcessingStage == Service.OperationProcessingStage.EXECUTING_SERVICE_HANDLER) {
                op.nestCompletion((o, e) -> {
                    if (e != null) {
                        this.logWarning("Service start failed: %s", Utils.toString(e));
                        op.fail(e);
                        return;
                    }
                    this.handlePostCompletion(op);
                });
                this.handlePost(op);
            }
        } else if (op.getAction() == Service.Action.GET) {
            if (this.getProcessingStage() != Service.ProcessingStage.AVAILABLE) {
                op.setBody(new ServiceDocumentQueryResult()).complete();
                return;
            }
            op.nestCompletion(this::handleGetCompletion);
            this.handleGet(op);
        } else if (op.getAction() == Service.Action.DELETE) {
            if (ServiceHost.isServiceStop(op)) {
                op.nestCompletion(o -> this.handleStopCompletion(op));
                this.handleStop(op);
            } else {
                op.nestCompletion(o -> this.handleDeleteCompletion(op));
                this.handleDelete(op);
            }
        } else if (op.getAction() == Service.Action.OPTIONS) {
            op.nestCompletion(this::handleOptionsCompletion);
            this.handleOptions(op);
        } else {
            op.fail(new IllegalArgumentException("Action not supported"));
        }
    }

    private void handlePostCompletion(Operation o) {
        Service childService;
        if (o.getStatusCode() == 202) {
            o.complete();
            return;
        }
        if (!o.hasPragmaDirective("xn-synch")) {
            o.addPragmaDirective("xn-created");
        }
        ServiceDocument initialState = null;
        try {
            String suffix;
            childService = this.createChildService();
            if (o.hasBody()) {
                initialState = (ServiceDocument)o.getBody(this.stateType);
                initialState = Utils.clone(initialState);
            }
            if (initialState == null) {
                suffix = UUID.randomUUID().toString();
                initialState = new ServiceDocument();
            } else {
                suffix = initialState.documentSelfLink == null ? UUID.randomUUID().toString() : initialState.documentSelfLink;
            }
            URI serviceUri = UriUtils.isChildPath(suffix, this.getSelfLink()) ? UriUtils.buildUri(this.getHost(), suffix) : UriUtils.extendUri(this.getUri(), suffix);
            o.setUri(serviceUri);
        }
        catch (Throwable e) {
            this.logSevere(e);
            o.fail(e);
            return;
        }
        initialState.documentSelfLink = o.getUri().getPath();
        initialState.documentKind = Utils.buildKind(this.stateType);
        initialState.documentTransactionId = o.getTransactionId();
        o.setBody(initialState);
        if (this.childOptions.contains((Object)Service.ServiceOption.REPLICATION) && !o.isFromReplication() && !o.isForwardingDisabled()) {
            this.forwardRequest(o, childService);
            return;
        }
        this.completePostRequest(o, childService);
    }

    private void completePostRequest(Operation o, Service childService) {
        if (!o.isFromReplication() && !o.isReplicationDisabled()) {
            o.nestCompletion(startOp -> {
                this.publish(o);
                if (o.getAction() == Service.Action.PUT || !this.hasOption(Service.ServiceOption.REPLICATION)) {
                    o.complete();
                    return;
                }
                o.setReplicationDisabled(false);
                this.replicateRequest(o);
            });
            if (o.isWithinTransaction() && this.getHost().getTransactionServiceUri() != null) {
                TransactionServiceHelper.notifyTransactionCoordinatorOfNewService(this, childService, o);
            }
        }
        o.setReplicationDisabled(true);
        o.addPragmaDirective("xn-check-version");
        this.getHost().startService(o, childService);
    }

    private void replicateRequest(Operation op) {
        op.setUri(this.getUri());
        ServiceDocument initialState = (ServiceDocument)op.getBody(this.stateType);
        ServiceDocument clonedInitState = Utils.clone(initialState);
        String originalLink = clonedInitState.documentSelfLink;
        clonedInitState.documentSelfLink = clonedInitState.documentSelfLink.replace(this.getSelfLink(), "");
        op.nestCompletion(replicatedOp -> {
            clonedInitState.documentSelfLink = originalLink;
            op.linkState(null).setBodyNoCloning(clonedInitState).complete();
        });
        op.linkState(clonedInitState);
        this.getHost().replicateRequest(this.childOptions, clonedInitState, this.getPeerNodeSelectorPath(), originalLink, op);
    }

    private void forwardRequest(Operation o, Service childService) {
        Operation selectOp = Operation.createPost(null).setExpiration(o.getExpirationMicrosUtc()).setCompletion((so, se) -> {
            if (se != null) {
                o.fail(se);
                return;
            }
            if (!so.hasBody()) {
                throw new IllegalStateException();
            }
            NodeSelectorService.SelectOwnerResponse rsp = so.getBody(NodeSelectorService.SelectOwnerResponse.class);
            ServiceDocument initialState = (ServiceDocument)o.getBodyRaw();
            initialState.documentOwner = rsp.ownerNodeId;
            if (initialState.documentEpoch == null) {
                initialState.documentEpoch = 0L;
            }
            if (rsp.isLocalHostOwner) {
                this.completePostRequest(o, childService);
                return;
            }
            URI remotePeerService = NodeSelectorService.SelectOwnerResponse.buildUriToOwner(rsp, this.getSelfLink(), null);
            Operation.CompletionHandler fc = (fo, fe) -> {
                o.setBodyNoCloning(fo.getBodyRaw());
                o.setStatusCode(fo.getStatusCode());
                o.transferResponseHeadersFrom(fo);
                if (fe != null) {
                    o.fail(fe);
                    return;
                }
                o.complete();
            };
            Operation forwardOp = o.clone().setUri(remotePeerService).setCompletion(fc);
            forwardOp.setConnectionTag("xn-cnx-tag-p2p-fwd");
            forwardOp.toggleOption(NodeSelectorService.FORWARDING_OPERATION_OPTION, true);
            initialState.documentSelfLink = initialState.documentSelfLink.replace(this.getSelfLink(), "");
            this.getHost().sendRequest(forwardOp);
        });
        this.getHost().selectOwner(this.getPeerNodeSelectorPath(), o.getUri().getPath(), selectOp);
    }

    @Override
    public void handleGet(Operation get) {
        get.complete();
    }

    private void handleGetCompletion(Operation op) {
        String query = op.getUri().getQuery();
        String oDataFilter = UriUtils.getODataFilterParamValue(op.getUri());
        boolean expand = UriUtils.hasODataExpandParamValue(op.getUri());
        if (query == null || oDataFilter == null && expand) {
            this.completeGetWithQuery(op, this.childOptions);
        } else {
            this.handleGetOdataCompletion(op);
        }
    }

    private void handleGetOdataCompletion(Operation op) {
        String path = UriUtils.getPathParamValue(op.getUri());
        String peer = UriUtils.getPeerParamValue(op.getUri());
        if (path != null && peer != null) {
            this.handleNavigationRequest(op);
            return;
        }
        Set<String> expandedQueryPropertyNames = QueryTaskUtils.getExpandedQueryPropertyNames(this.getChildTemplate().documentDescription);
        QueryTask task = ODataUtils.toQuery(op, false, expandedQueryPropertyNames);
        if (task == null) {
            return;
        }
        task.setDirect(true);
        String kind = Utils.buildKind(this.getStateType());
        QueryTask.Query kindClause = new QueryTask.Query().setTermPropertyName("documentKind").setTermMatchValue(kind);
        task.querySpec.query.addBooleanClause(kindClause);
        if (task.querySpec.sortTerm != null) {
            String propertyName = task.querySpec.sortTerm.propertyName;
            ServiceDocumentDescription.PropertyDescription propertyDescription = this.getChildTemplate().documentDescription.propertyDescriptions.get(propertyName);
            if (propertyDescription == null) {
                op.fail(new IllegalArgumentException("Sort term is not a valid property: " + propertyName));
                return;
            }
            task.querySpec.sortTerm.propertyType = propertyDescription.typeName;
        }
        if (task.querySpec.resultLimit != null) {
            this.handleODataLimitRequest(op, task);
            return;
        }
        this.sendRequest(Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(task).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ServiceDocumentQueryResult result = o.getBody(QueryTask.class).results;
            ODataFactoryQueryResult odataResult = new ODataFactoryQueryResult();
            odataResult.totalCount = result.documentCount;
            result.copyTo(odataResult);
            op.setBodyNoCloning(odataResult).complete();
        }));
    }

    private void handleNavigationRequest(Operation op) {
        String path = UriUtils.buildUriPath("/core/node-selectors/default", "forwarding");
        String query = UriUtils.buildUriQuery("path", UriUtils.getPathParamValue(op.getUri()), "peer", UriUtils.getPeerParamValue(op.getUri()), "target", UriUtils.ForwardingTarget.PEER_ID.toString());
        this.sendRequest(Operation.createGet(UriUtils.buildUri(this.getHost(), path, query)).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ServiceDocumentQueryResult result = o.getBody(QueryTask.class).results;
            this.prepareNavigationResult(result);
            op.setBodyNoCloning(result).complete();
        }));
    }

    private void handleODataLimitRequest(Operation op, QueryTask task) {
        if (task.querySpec.options.contains((Object)QueryTask.QuerySpecification.QueryOption.COUNT)) {
            task.querySpec.options.remove((Object)QueryTask.QuerySpecification.QueryOption.COUNT);
            task.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
            Operation query = Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(task);
            this.prepareRequest(query);
            QueryTask countTask = new QueryTask();
            countTask.setDirect(true);
            countTask.querySpec = new QueryTask.QuerySpecification();
            countTask.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.COUNT);
            countTask.querySpec.query = task.querySpec.query;
            Operation count = Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(countTask);
            this.prepareRequest(count);
            OperationJoin.create(count, query).setCompletion((os, es) -> {
                if (es != null && !es.isEmpty()) {
                    op.fail((Throwable)es.values().iterator().next());
                    return;
                }
                ServiceDocumentQueryResult countResult = ((Operation)os.get((Object)Long.valueOf((long)count.getId()))).getBody(QueryTask.class).results;
                ServiceDocumentQueryResult queryResult = ((Operation)os.get((Object)Long.valueOf((long)query.getId()))).getBody(QueryTask.class).results;
                if (queryResult.nextPageLink == null) {
                    ODataFactoryQueryResult odataResult = new ODataFactoryQueryResult();
                    queryResult.copyTo(odataResult);
                    odataResult.totalCount = countResult.documentCount;
                    op.setBodyNoCloning(odataResult).complete();
                    return;
                }
                this.sendNextRequest(op, queryResult.nextPageLink, countResult.documentCount);
            }).sendWith(this.getHost());
            return;
        }
        this.sendRequest(Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(task).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ServiceDocumentQueryResult result = o.getBody(QueryTask.class).results;
            if (result.nextPageLink == null) {
                ODataFactoryQueryResult odataResult = new ODataFactoryQueryResult();
                result.copyTo(odataResult);
                odataResult.totalCount = result.documentCount;
                op.setBodyNoCloning(odataResult).complete();
                return;
            }
            this.sendNextRequest(op, result.nextPageLink, null);
        }));
    }

    private void sendNextRequest(Operation op, String nextPageLink, Long totalCount) {
        this.sendRequest(Operation.createGet(this, nextPageLink).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ODataFactoryQueryResult odataResult = new ODataFactoryQueryResult();
            ServiceDocumentQueryResult result = o.getBody(QueryTask.class).results;
            result.copyTo(odataResult);
            odataResult.totalCount = totalCount == null ? result.documentCount : totalCount;
            this.prepareNavigationResult(odataResult);
            op.setBodyNoCloning(odataResult).complete();
        }));
    }

    private void prepareNavigationResult(ServiceDocumentQueryResult result) {
        if (result.nextPageLink != null) {
            result.nextPageLink = this.convertNavigationLink(result.nextPageLink);
        }
        if (result.prevPageLink != null) {
            result.prevPageLink = this.convertNavigationLink(result.prevPageLink);
        }
    }

    private String convertNavigationLink(String navigationLink) {
        URI uri = URI.create(navigationLink);
        return this.getSelfLink() + "?" + UriUtils.buildUriQuery("path", UriUtils.getPathParamValue(uri), "peer", UriUtils.getPeerParamValue(uri));
    }

    public void completeGetWithQuery(Operation op, EnumSet<Service.ServiceOption> caps) {
        boolean doExpand = false;
        if (op.getUri().getQuery() != null) {
            doExpand = UriUtils.hasODataExpandParamValue(op.getUri());
        }
        URI u = UriUtils.buildDocumentQueryUri(this.getHost(), UriUtils.buildUriPath(this.getSelfLink(), "*"), doExpand, false, caps != null ? caps : EnumSet.of(Service.ServiceOption.NONE));
        Operation query = Operation.createGet(u).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.setBodyNoCloning(o.getBodyRaw()).complete();
        });
        this.sendRequest(query);
    }

    @Override
    public void handleOptions(Operation op) {
        op.setBody(null).complete();
    }

    @Override
    public void handlePost(Operation op) {
        if (op.hasBody()) {
            ServiceDocument body = (ServiceDocument)op.getBody(this.stateType);
            if (body == null) {
                op.fail(new IllegalArgumentException("structured body is required"));
                return;
            }
            if (body.documentSourceLink != null) {
                op.fail(new IllegalArgumentException("clone request not supported"));
                return;
            }
        }
        op.complete();
    }

    private Service createChildService() throws Throwable {
        Service childService = this.createServiceInstance();
        this.childOptions = childService.getOptions();
        if (childService.hasOption(Service.ServiceOption.REPLICATION)) {
            this.toggleOption(Service.ServiceOption.REPLICATION, true);
            if (!"/core/node-selectors/default".equals(childService.getPeerNodeSelectorPath())) {
                this.nodeSelectorLink = childService.getPeerNodeSelectorPath();
            } else if (!"/core/node-selectors/default".equals(this.nodeSelectorLink)) {
                childService.setPeerNodeSelectorPath(this.nodeSelectorLink);
            }
        }
        if (childService.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
            this.toggleOption(Service.ServiceOption.ON_DEMAND_LOAD, true);
        }
        if (childService.hasOption(Service.ServiceOption.HTML_USER_INTERFACE)) {
            this.toggleOption(Service.ServiceOption.HTML_USER_INTERFACE, true);
        }
        if (childService.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            this.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        }
        if (this.hasOption(Service.ServiceOption.IDEMPOTENT_POST)) {
            childService.toggleOption(Service.ServiceOption.IDEMPOTENT_POST, true);
        }
        childService.toggleOption(Service.ServiceOption.FACTORY_ITEM, true);
        return childService;
    }

    private Service createChildServiceSafe() {
        try {
            return this.createChildService();
        }
        catch (Throwable e) {
            this.logSevere(e);
            return null;
        }
    }

    @Override
    public void toggleOption(Service.ServiceOption option, boolean enable) {
        if (enable) {
            this.options.add(option);
        } else {
            this.options.remove((Object)option);
        }
    }

    @Override
    public String getPeerNodeSelectorPath() {
        return this.nodeSelectorLink;
    }

    @Override
    public void setPeerNodeSelectorPath(String link) {
        this.nodeSelectorLink = link;
    }

    @Override
    public ServiceDocument getDocumentTemplate() {
        ServiceDocumentQueryResult r = new ServiceDocumentQueryResult();
        ServiceDocument childTemplate = this.getChildTemplate();
        r.documents = new HashMap<String, Object>();
        childTemplate.documentSelfLink = UriUtils.buildUriPath(this.getSelfLink(), "child-template");
        r.documentLinks.add(childTemplate.documentSelfLink);
        r.documents.put(childTemplate.documentSelfLink, childTemplate);
        return r;
    }

    private ServiceDocument getChildTemplate() {
        if (this.childTemplate == null) {
            try {
                Service s = this.createServiceInstance();
                s.setHost(this.getHost());
                this.childTemplate = s.getDocumentTemplate();
            }
            catch (Throwable e) {
                this.logSevere(e);
                return null;
            }
        }
        return this.childTemplate;
    }

    @Override
    public void handleNodeGroupMaintenance(Operation maintOp) {
        if (!this.hasOption(Service.ServiceOption.REPLICATION)) {
            maintOp.complete();
            return;
        }
        if (this.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
            this.setAvailable(true);
            maintOp.complete();
            return;
        }
        this.setAvailable(false);
        OperationContext opContext = OperationContext.getOperationContext();
        Operation selectOwnerOp = maintOp.clone().setExpiration(Utils.getNowMicrosUtc() + this.getHost().getOperationTimeoutMicros());
        selectOwnerOp.setCompletion((o, e) -> {
            OperationContext.restoreOperationContext(opContext);
            if (e != null) {
                this.logWarning("owner selection failed: %s", e.toString());
                maintOp.fail(e);
                return;
            }
            NodeSelectorService.SelectOwnerResponse rsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            if (!rsp.isLocalHostOwner) {
                maintOp.complete();
                return;
            }
            if (rsp.availableNodeCount > 1) {
                this.logInfo("Elected owner on %s, starting synch (%d)", this.getHost().getId(), rsp.availableNodeCount);
            }
            SynchronizationContext ctx = new SynchronizationContext();
            ctx.originalSelection = rsp;
            ctx.maintOp = maintOp;
            this.synchronizeChildServicesAsOwner(ctx);
        });
        this.getHost().selectOwner(this.nodeSelectorLink, this.getSelfLink(), selectOwnerOp);
    }

    private void verifySynchronizationOwner(SynchronizationContext ctx) {
        OperationContext opContext = OperationContext.getOperationContext();
        Operation selectOwnerOp = ctx.maintOp.clone().setExpiration(Utils.getNowMicrosUtc() + this.getHost().getOperationTimeoutMicros());
        selectOwnerOp.setCompletion((o, e) -> {
            OperationContext.restoreOperationContext(opContext);
            if (e != null) {
                ctx.maintOp.fail(e);
                return;
            }
            NodeSelectorService.SelectOwnerResponse rsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            if (rsp.availableNodeCount != ctx.originalSelection.availableNodeCount || rsp.membershipUpdateTimeMicros != ctx.originalSelection.membershipUpdateTimeMicros) {
                this.logWarning("Membership changed, aborting synch", new Object[0]);
                ctx.maintOp.fail(new CancellationException("aborted due to node group change"));
                return;
            }
            if (!rsp.isLocalHostOwner) {
                this.logWarning("No longer owner, aborting synch. New owner %s", rsp.ownerNodeId);
                ctx.maintOp.fail(new CancellationException("aborted due to owner change"));
                return;
            }
            this.processChildQueryPage(ctx, false);
        });
        this.getHost().selectOwner(this.nodeSelectorLink, this.getSelfLink(), selectOwnerOp);
    }

    private void synchronizeChildServicesAsOwner(SynchronizationContext ctx) {
        ctx.maintOp.nestCompletion((o, e) -> {
            if (e != null) {
                this.logWarning("synch failed: %s", e.toString());
            } else {
                this.setAvailable(true);
            }
            ctx.maintOp.complete();
        });
        this.startOrSynchronizeChildServices(ctx);
    }

    public abstract Service createServiceInstance() throws Throwable;

    static class SynchronizationContext {
        NodeSelectorService.SelectOwnerResponse originalSelection;
        QueryTask queryTask;
        Operation maintOp;
        public URI nextPageReference;

        SynchronizationContext() {
        }
    }
}

