/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.TaskState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.QueryTaskUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BroadcastQueryPageService
extends StatelessService {
    public static final String SELF_LINK_PREFIX = "broadcast-query-page";
    public static final String KIND = Utils.buildKind(QueryTask.class);
    private final QueryTask.QuerySpecification spec;
    private final List<String> pageLinks;
    private final long expirationMicros;

    public BroadcastQueryPageService(QueryTask.QuerySpecification spec, List<String> pageLinks, long expMicros) {
        super(QueryTask.class);
        this.spec = spec;
        this.pageLinks = pageLinks;
        this.expirationMicros = expMicros;
    }

    @Override
    public void handleStart(Operation post) {
        ServiceDocument initState = post.getBody(ServiceDocument.class);
        long interval = initState.documentExpirationTimeMicros - Utils.getNowMicrosUtc();
        if (interval < 0L) {
            this.logWarning("Task expiration is in the past, extending it", new Object[0]);
            interval = TimeUnit.SECONDS.toMicros(this.getHost().getMaintenanceIntervalMicros() * 2L);
        }
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        super.setMaintenanceIntervalMicros(interval);
        post.complete();
    }

    @Override
    public void handleGet(Operation get) {
        List responses = Collections.synchronizedList(new ArrayList());
        AtomicInteger remainingQueries = new AtomicInteger(this.pageLinks.size());
        if (remainingQueries.get() == 0) {
            get.complete();
            return;
        }
        for (String indexLink : this.pageLinks) {
            Operation op = Operation.createGet(UriUtils.buildUri(this.getHost(), indexLink)).transferRefererFrom(get).setExpiration(Utils.getNowMicrosUtc() + this.getHost().getOperationTimeoutMicros() / 3L).setCompletion((o, e) -> {
                int r;
                if (e != null) {
                    get.fail(e);
                    return;
                }
                QueryTask rsp = o.getBody(QueryTask.class);
                if (rsp != null) {
                    responses.add(rsp);
                }
                if ((r = remainingQueries.decrementAndGet()) == 0) {
                    rsp.results = this.collectPagesAndStartNewServices(responses);
                    get.setBodyNoCloning(rsp).complete();
                }
            });
            this.getHost().sendRequest(op);
        }
    }

    private ServiceDocumentQueryResult collectPagesAndStartNewServices(List<QueryTask> responses) {
        ArrayList<ServiceDocumentQueryResult> queryResults = new ArrayList<ServiceDocumentQueryResult>();
        ArrayList<String> nextPageLinks = new ArrayList<String>();
        ArrayList<String> prevPageLinks = new ArrayList<String>();
        EnumSet<QueryTask.QuerySpecification.QueryOption> options = EnumSet.noneOf(QueryTask.QuerySpecification.QueryOption.class);
        for (QueryTask rsp : responses) {
            if (rsp.results == null) continue;
            queryResults.add(rsp.results);
            if (rsp.results.nextPageLink != null) {
                nextPageLinks.add(rsp.results.nextPageLink);
            }
            if (rsp.results.prevPageLink != null) {
                prevPageLinks.add(rsp.results.prevPageLink);
            }
            if (rsp.querySpec == null || rsp.querySpec.options == null) continue;
            options = rsp.querySpec.options;
        }
        boolean isAscOrder = this.spec.sortOrder == null || this.spec.sortOrder == QueryTask.QuerySpecification.SortOrder.ASC;
        ServiceDocumentQueryResult mergeResults = QueryTaskUtils.mergeQueryResults(queryResults, isAscOrder, options);
        if (!nextPageLinks.isEmpty()) {
            mergeResults.nextPageLink = this.startNewService(nextPageLinks);
        }
        if (!prevPageLinks.isEmpty()) {
            mergeResults.prevPageLink = this.startNewService(prevPageLinks);
        }
        return mergeResults;
    }

    @Override
    public void handleMaintenance(Operation op) {
        op.complete();
        this.getHost().stopService(this);
    }

    private String startNewService(List<String> pageLinks) {
        URI broadcastPageServiceUri = UriUtils.buildUri(this.getHost(), UriUtils.buildUriPath("/core", SELF_LINK_PREFIX, String.valueOf(Utils.getNowMicrosUtc())));
        URI forwarderUri = UriUtils.buildForwardToPeerUri(broadcastPageServiceUri, this.getHost().getId(), "/core/node-selectors/default", EnumSet.noneOf(Service.ServiceOption.class));
        String broadcastQueryPageLink = forwarderUri.getPath() + "?" + forwarderUri.getQuery();
        ServiceDocument postBody = new ServiceDocument();
        postBody.documentSelfLink = broadcastPageServiceUri.getPath();
        postBody.documentExpirationTimeMicros = this.expirationMicros;
        Operation startPost = Operation.createPost(broadcastPageServiceUri).setBody(postBody).setCompletion((o, e) -> {
            if (e != null) {
                this.failTask(e, o, null);
                return;
            }
        });
        this.getHost().startService(startPost, new BroadcastQueryPageService(this.spec, pageLinks, this.expirationMicros));
        return broadcastQueryPageLink;
    }

    private void failTask(Throwable e, Operation directOp, Operation.CompletionHandler c) {
        QueryTask t = new QueryTask();
        t.taskInfo.stage = TaskState.TaskStage.FAILED;
        t.taskInfo.failure = Utils.toServiceErrorResponse(e);
        if (directOp != null) {
            directOp.setBody(t).fail(e);
            return;
        }
        this.sendRequest(Operation.createPatch(this.getUri()).setBody(t).setCompletion(c));
    }
}

