/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.vmware.xenon.common.RequestRouter;
import com.vmware.xenon.common.Service;
import java.lang.reflect.Type;

public enum RequestRouteConverter implements JsonSerializer<RequestRouter.Route>,
JsonDeserializer<RequestRouter.Route>
{
    INSTANCE;

    public static final Type TYPE;

    public JsonElement serialize(RequestRouter.Route src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject ob = new JsonObject();
        ob.addProperty("action", src.action.toString());
        if (src.matcher != null) {
            ob.addProperty("condition", src.matcher.toString());
        }
        ob.addProperty("description", src.description);
        if (src.requestType != null) {
            ob.addProperty("requestType", src.requestType.getName());
        }
        if (src.responseType != null) {
            ob.addProperty("responseType", src.responseType.getName());
        }
        return ob;
    }

    public RequestRouter.Route deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("The json element is not valid");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        RequestRouter.Route route = new RequestRouter.Route();
        String action = this.checkAndGetFromJson(jsonObject, "action");
        route.action = action == null ? null : Service.Action.valueOf(action);
        route.description = this.checkAndGetFromJson(jsonObject, "description");
        try {
            String requestType = this.checkAndGetFromJson(jsonObject, "requestType");
            route.requestType = requestType == null ? null : Class.forName(requestType);
            String responseType = this.checkAndGetFromJson(jsonObject, "responseType");
            route.responseType = responseType == null ? null : Class.forName(responseType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return route;
    }

    private String checkAndGetFromJson(JsonObject jsonObject, String memberName) {
        if (jsonObject.has(memberName)) {
            return jsonObject.get(memberName).getAsString();
        }
        return null;
    }

    static {
        TYPE = new TypeToken<RequestRouter.Route>(){}.getType();
    }
}

