/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.time.Instant;

public class InstantSerializer
extends Serializer<Instant> {
    public static final InstantSerializer INSTANCE = new InstantSerializer();

    public InstantSerializer() {
        this.setAcceptsNull(false);
        this.setImmutable(true);
    }

    public void write(Kryo kryo, Output output, Instant object) {
        InstantSerializer.write(output, object);
    }

    public Instant read(Kryo kryo, Input input, Class<Instant> type) {
        return InstantSerializer.read(input);
    }

    protected static void write(Output output, Instant object) {
        output.writeLong(object.getEpochSecond());
        output.writeInt(object.getNano());
    }

    protected static Instant read(Input input) {
        long epochSecond = input.readLong();
        int nano = input.readInt();
        return Instant.ofEpochSecond(epochSecond, nano);
    }
}

