/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;

public class TransactionServiceHelper {
    static void handleGetWithinTransaction(StatefulService s, Operation get, Handler h, FailRequest fr) {
        if (get.isWithinTransaction()) {
            Operation inTransactionQueryOp = TransactionServiceHelper.buildLatestInTransactionQueryTaskOp(s, get.getTransactionId()).setCompletion((o, e) -> {
                if (e != null) {
                    get.fail(e);
                    return;
                }
                QueryTask response = o.getBody(QueryTask.class);
                if (response.results.documentLinks.isEmpty()) {
                    Operation nonTransactionQueryOp = TransactionServiceHelper.buildLatestNonTransactionQueryTaskOp(s).setCompletion((o2, e2) -> {
                        if (e2 != null) {
                            get.fail(e);
                            return;
                        }
                        QueryTask nonTransactionResponse = o2.getBody(QueryTask.class);
                        TransactionServiceHelper.returnLatestOrFail(nonTransactionResponse, get, fr);
                    });
                    s.sendRequest(nonTransactionQueryOp);
                } else {
                    TransactionServiceHelper.returnLatestOrFail(response, get, fr);
                }
            });
            s.sendRequest(inTransactionQueryOp);
        } else {
            Operation nonTransactionQueryOp = TransactionServiceHelper.buildLatestNonTransactionQueryTaskOp(s).setCompletion((o, e) -> {
                if (e != null) {
                    get.fail(e);
                    return;
                }
                QueryTask response = o.getBody(QueryTask.class);
                TransactionServiceHelper.returnLatestOrFail(response, get, fr);
            });
            s.sendRequest(nonTransactionQueryOp);
        }
    }

    private static void returnLatestOrFail(QueryTask response, Operation get, FailRequest fr) {
        if (response.results.documentLinks.isEmpty()) {
            get.setStatusCode(404);
            fr.failRequest(get, new IllegalStateException("Latest state not found"), false);
            return;
        }
        String latest = response.results.documentLinks.get(0);
        Object obj = response.results.documents.get(latest);
        get.setBodyNoCloning(obj).complete();
    }

    private static Operation buildLatestInTransactionQueryTaskOp(StatefulService s, String txid) {
        QueryTask.Query.Builder queryBuilder = QueryTask.Query.Builder.create();
        queryBuilder.addFieldClause("documentSelfLink", s.getSelfLink());
        queryBuilder.addFieldClause("documentTransactionId", txid);
        QueryTask.Builder queryTaskBuilder = QueryTask.Builder.createDirectTask().setQuery(queryBuilder.build());
        queryTaskBuilder.addOption(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        queryTaskBuilder.addOption(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        queryTaskBuilder.orderDescending("documentVersion", ServiceDocumentDescription.TypeName.LONG);
        QueryTask task = queryTaskBuilder.build();
        return Operation.createPost(UriUtils.buildUri(s.getHost(), ServiceUriPaths.CORE_QUERY_TASKS)).setBody(task);
    }

    private static Operation buildLatestNonTransactionQueryTaskOp(StatefulService s) {
        QueryTask.Query.Builder queryBuilder = QueryTask.Query.Builder.create();
        queryBuilder.addFieldClause("documentSelfLink", s.getSelfLink());
        queryBuilder.addFieldClause("documentTransactionId", "*", QueryTask.QueryTerm.MatchType.WILDCARD, QueryTask.Query.Occurance.MUST_NOT_OCCUR);
        QueryTask.Builder queryTaskBuilder = QueryTask.Builder.createDirectTask().setQuery(queryBuilder.build());
        queryTaskBuilder.addOption(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        queryTaskBuilder.addOption(QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        queryTaskBuilder.orderDescending("documentVersion", ServiceDocumentDescription.TypeName.LONG);
        QueryTask task = queryTaskBuilder.build();
        return Operation.createPost(UriUtils.buildUri(s.getHost(), ServiceUriPaths.CORE_QUERY_TASKS)).setBody(task);
    }

    static void notifyTransactionCoordinator(StatefulService s, Operation op, Throwable e) {
        Operation.TransactionContext operationsLogRecord = new Operation.TransactionContext();
        operationsLogRecord.action = op.getAction();
        operationsLogRecord.coordinatorLinks = s.getPendingTransactions();
        operationsLogRecord.isSuccessful = e == null;
        URI txCoordinator = UriUtils.buildTransactionUri(s.getHost(), op.getTransactionId());
        s.addPendingTransaction(txCoordinator.getPath());
        s.sendRequest(Operation.createPut(txCoordinator).setBody(operationsLogRecord).setTransactionId(null));
    }

    static void notifyTransactionCoordinatorOfNewService(FactoryService factoryService, Service childService, Operation op) {
        childService.setHost(factoryService.getHost());
        URI childServiceUri = op.getUri().normalize();
        String childServicePath = UriUtils.normalizeUriPath(childServiceUri.getPath()).intern();
        childService.setSelfLink(childServicePath);
        TransactionServiceHelper.notifyTransactionCoordinator((StatefulService)childService, op, null);
    }

    static boolean handleOperationInTransaction(StatefulService s, Class<? extends ServiceDocument> st, Operation request) {
        if (request.getRequestHeader("x-xenon-tx-phase") == null) {
            return false;
        }
        if (request.getRequestHeader("x-xenon-tx-phase").equals("try-commit") || request.getRequestHeader("x-xenon-tx-phase").equals("ensure-commit")) {
            return false;
        }
        if (request.getRequestHeader("x-xenon-tx-phase").equals("commit")) {
            s.removePendingTransaction(request.getReferer().getPath());
            s.getHost().clearTransactionalCachedServiceState(s, UriUtils.getLastPathSegment(request.getReferer().getPath()));
            QueryTask.QuerySpecification q = new QueryTask.QuerySpecification();
            QueryTask.Query txnIdClause = new QueryTask.Query().setTermPropertyName("documentTransactionId").setTermMatchValue(UriUtils.getLastPathSegment(request.getReferer()));
            txnIdClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
            q.query.addBooleanClause(txnIdClause);
            QueryTask.Query selfLinkClause = new QueryTask.Query().setTermPropertyName("documentSelfLink").setTermMatchValue(s.getSelfLink());
            selfLinkClause.occurance = QueryTask.Query.Occurance.MUST_OCCUR;
            q.query.addBooleanClause(selfLinkClause);
            q.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT, QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
            QueryTask task = QueryTask.create(q).setDirect(true);
            URI uri = UriUtils.buildUri(s.getHost(), ServiceUriPaths.CORE_QUERY_TASKS);
            Operation startPost = Operation.createPost(uri).setBody(task).setCompletion((o, f) -> TransactionServiceHelper.unshadowQueryCompletion(s, st, o, f, request));
            s.sendRequest(startPost);
        } else if (request.getRequestHeader("x-xenon-tx-phase").equals("abort")) {
            s.removePendingTransaction(request.getReferer().getPath());
            s.getHost().clearTransactionalCachedServiceState(s, UriUtils.getLastPathSegment(request.getReferer().getPath()));
            request.complete();
        } else {
            request.fail(new IllegalArgumentException("Transaction control message, but none of {commit, abort}"));
        }
        return true;
    }

    static void unshadowQueryCompletion(StatefulService s, Class<? extends ServiceDocument> st, Operation o, Throwable f, Operation original) {
        if (f != null) {
            s.logInfo(f.toString(), new Object[0]);
            original.fail(f);
            return;
        }
        QueryTask response = o.getBody(QueryTask.class);
        if (response.results.documentLinks.isEmpty()) {
            original.fail(new IllegalStateException("There should be at least one shadowed, but none was found"));
            return;
        }
        List<String> dl = response.results.documentLinks;
        String latest = dl.get(0);
        Object obj = response.results.documents.get(latest);
        ServiceDocument sd = Utils.fromJson((String)obj, st);
        sd.documentTransactionId = null;
        s.setState(original, sd);
        original.complete();
    }

    static interface FailRequest {
        public void failRequest(Operation var1, Throwable var2, boolean var3);
    }

    static interface Handler {
        public void handler(Operation var1);
    }
}

