/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ReflectionUtils {
    private static final ConcurrentHashMap<Class<?>, Map<String, Field>> DECLARED_FIELDS_CACHE = new ConcurrentHashMap();

    public static <T> T instantiate(Class<T> clazz) {
        try {
            Constructor<T> ctor = clazz.getDeclaredConstructor(new Class[0]);
            if (!ctor.isAccessible()) {
                ctor.setAccessible(true);
            }
            return ctor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            Utils.logWarning("Reflection error: %s", Utils.toString(e));
            return null;
        }
    }

    public static Object getPropertyValue(ServiceDocumentDescription.PropertyDescription pd, Object instance) {
        try {
            return pd.accessor.get(instance);
        }
        catch (Throwable e) {
            Utils.logWarning("Reflection error: %s", Utils.toString(e));
            return null;
        }
    }

    public static void setPropertyValue(ServiceDocumentDescription.PropertyDescription pd, Object instance, Object value) {
        try {
            pd.accessor.set(instance, value);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasField(Class<? extends Service> type, String fieldName) {
        try {
            type.getField(fieldName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field getField(Class<?> clazz, String name) {
        Map fieldMap = DECLARED_FIELDS_CACHE.computeIfAbsent(clazz, key -> Arrays.stream(key.getDeclaredFields()).collect(Collectors.toMap(Field::getName, Function.identity())));
        Field field = (Field)fieldMap.get(name);
        if (field == null) {
            return null;
        }
        if (!field.isAccessible()) {
            Field field2 = field;
            synchronized (field2) {
                field.setAccessible(true);
            }
        }
        return field;
    }
}

