/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.ODataQueryVisitor;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.QueryTask;
import java.util.Collections;
import java.util.Set;

public class ODataUtils {
    public static final String FILTER_VALUE_ALL_FIELDS = "ALL_FIELDS";

    public static QueryTask toQuery(Operation op, boolean validate) {
        return ODataUtils.toQuery(op, validate, Collections.emptySet());
    }

    public static QueryTask toQuery(Operation op, boolean validate, Set<String> wildcardFilterUnfoldPropertyNames) {
        Integer skip;
        Integer top;
        UriUtils.ODataOrderByTuple orderBy;
        QueryTask.Query q;
        QueryTask task = new QueryTask();
        task.setDirect(true);
        task.querySpec = new QueryTask.QuerySpecification();
        boolean count = UriUtils.getODataCountParamValue(op.getUri());
        if (count) {
            task.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.COUNT);
        } else {
            task.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        }
        String filter = UriUtils.getODataFilterParamValue(op.getUri());
        if (filter != null && (q = new ODataQueryVisitor(wildcardFilterUnfoldPropertyNames).toQuery(filter)) != null) {
            task.querySpec.query.addBooleanClause(q);
        }
        if ((orderBy = UriUtils.getODataOrderByParamValue(op.getUri())) != null) {
            if (count && validate) {
                op.fail(new IllegalArgumentException("$count cannot be used together with $orderby"));
                return null;
            }
            task.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.SORT);
            task.querySpec.sortOrder = orderBy.order == UriUtils.ODataOrder.ASC ? QueryTask.QuerySpecification.SortOrder.ASC : QueryTask.QuerySpecification.SortOrder.DESC;
            task.querySpec.sortTerm = new QueryTask.QueryTerm();
            ServiceDocumentDescription.TypeName typeName = ServiceDocumentDescription.TypeName.STRING;
            if (orderBy.propertyType != null) {
                try {
                    typeName = Enum.valueOf(ServiceDocumentDescription.TypeName.class, orderBy.propertyType);
                }
                catch (IllegalArgumentException ex) {
                    op.fail(new IllegalArgumentException("Type name " + orderBy.propertyType + " is not supported for " + "$orderbytype"));
                    return null;
                }
            }
            task.querySpec.sortTerm.propertyType = typeName;
            task.querySpec.sortTerm.propertyName = orderBy.propertyName;
        }
        if ((top = UriUtils.getODataTopParamValue(op.getUri())) != null) {
            if (count && validate) {
                op.fail(new IllegalArgumentException("$count cannot be used together with $top"));
                return null;
            }
            task.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.TOP_RESULTS);
            task.querySpec.resultLimit = top;
        }
        if ((skip = UriUtils.getODataSkipParamValue(op.getUri())) != null) {
            op.fail(new IllegalArgumentException("$skip is not supported, see skipto"));
            return null;
        }
        Integer limit = UriUtils.getODataLimitParamValue(op.getUri());
        if (limit != null && limit > 0) {
            if (count && validate) {
                op.fail(new IllegalArgumentException("$count cannot be used together with $limit"));
                return null;
            }
            if (top != null) {
                op.fail(new IllegalArgumentException("$top cannot be used together with $limit"));
                return null;
            }
            task.querySpec.resultLimit = limit;
        }
        return task;
    }
}

