/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;

public class UserService
extends StatefulService {
    public UserService() {
        super(UserState.class);
        super.toggleOption(Service.ServiceOption.PERSISTENCE, true);
        super.toggleOption(Service.ServiceOption.REPLICATION, true);
        super.toggleOption(Service.ServiceOption.OWNER_SELECTION, true);
    }

    @Override
    public void handleStart(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        UserState state = op.getBody(UserState.class);
        if (!this.validate(op, state)) {
            return;
        }
        op.complete();
    }

    @Override
    public void handlePut(Operation op) {
        if (!op.hasBody()) {
            op.fail(new IllegalArgumentException("body is required"));
            return;
        }
        UserState newState = op.getBody(UserState.class);
        if (!this.validate(op, newState)) {
            return;
        }
        UserState currentState = (UserState)this.getState(op);
        if (currentState.email.equals(newState.email)) {
            op.setStatusCode(304);
        } else {
            this.setState(op, newState);
        }
        op.complete();
    }

    private boolean validate(Operation op, UserState state) {
        if (state.email == null) {
            op.fail(new IllegalArgumentException("email is required"));
            return false;
        }
        int firstAtIndex = state.email.indexOf(64);
        int lastAtIndex = state.email.lastIndexOf(64);
        if (firstAtIndex == -1 || firstAtIndex != lastAtIndex) {
            op.fail(new IllegalArgumentException("email is invalid"));
            return false;
        }
        return true;
    }

    public static class UserState
    extends ServiceDocument {
        public static final String FIELD_NAME_EMAIL = "email";
        public String email;
    }
}

