/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyFullHttpRequest;
import com.vmware.xenon.common.http.netty.SimpleChannelPromiseAggregator;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.ReferenceCountUtil;

public class NettyHttpToHttp2Handler
extends Http2ConnectionHandler {
    private final boolean validateHeaders;
    private int currentStreamId;

    protected NettyHttpToHttp2Handler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders) {
        super(decoder, encoder, initialSettings);
        this.validateHeaders = validateHeaders;
    }

    private int getStreamId(HttpHeaders httpHeaders) throws Exception {
        return httpHeaders.getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), this.connection().local().incrementAndGetNextStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (!(msg instanceof HttpMessage) && !(msg instanceof HttpContent)) {
            ctx.write(msg, promise);
            return;
        }
        boolean release = true;
        SimpleChannelPromiseAggregator promiseAggregator = new SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
        try {
            Http2ConnectionEncoder encoder = this.encoder();
            boolean endStream = false;
            if (msg instanceof HttpMessage) {
                NettyChannelContext socketContext;
                NettyFullHttpRequest request;
                Operation operation;
                HttpMessage httpMsg = (HttpMessage)msg;
                this.currentStreamId = this.getStreamId(httpMsg.headers());
                if (msg instanceof NettyFullHttpRequest && (operation = (request = (NettyFullHttpRequest)((Object)msg)).getOperation()) != null && (socketContext = (NettyChannelContext)operation.getSocketContext()) != null) {
                    Operation oldOperation = socketContext.getOperationForStream(this.currentStreamId);
                    if (oldOperation != null && oldOperation != operation) {
                        Utils.logWarning("===== ajr Reusing stream %d", this.currentStreamId);
                    }
                    socketContext.setOperationForStream(this.currentStreamId, operation);
                }
                Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers((HttpMessage)httpMsg, (boolean)this.validateHeaders);
                endStream = msg instanceof FullHttpMessage && !((FullHttpMessage)msg).content().isReadable();
                encoder.writeHeaders(ctx, this.currentStreamId, http2Headers, 0, endStream, promiseAggregator.newPromise());
            }
            if (!endStream && msg instanceof HttpContent) {
                boolean isLastContent = false;
                EmptyHttp2Headers trailers = EmptyHttp2Headers.INSTANCE;
                if (msg instanceof LastHttpContent) {
                    isLastContent = true;
                    LastHttpContent lastContent = (LastHttpContent)msg;
                    trailers = HttpConversionUtil.toHttp2Headers((HttpHeaders)lastContent.trailingHeaders(), (boolean)this.validateHeaders);
                }
                ByteBuf content = ((HttpContent)msg).content();
                endStream = isLastContent && trailers.isEmpty();
                release = false;
                encoder.writeData(ctx, this.currentStreamId, content, 0, endStream, promiseAggregator.newPromise());
                if (!trailers.isEmpty()) {
                    encoder.writeHeaders(ctx, this.currentStreamId, (Http2Headers)trailers, 0, true, promiseAggregator.newPromise());
                }
            }
            promiseAggregator.doneAllocatingPromises();
        }
        catch (Throwable t) {
            promiseAggregator.setFailure(t);
        }
        finally {
            if (release) {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }
}

