/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.http.netty.CookieJar;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLSession;

public class NettyHttpClientRequestHandler
extends SimpleChannelInboundHandler<Object> {
    private static final String ERROR_MSG_DECODING_FAILURE = "Failure decoding HTTP request";
    private final ServiceHost host;
    private final SslHandler sslHandler;

    public NettyHttpClientRequestHandler(ServiceHost host, SslHandler sslHandler) {
        this.host = host;
        this.sslHandler = sslHandler;
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return msg instanceof FullHttpRequest;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Operation request = null;
        Integer streamId = null;
        try {
            FullHttpRequest nettyRequest = (FullHttpRequest)msg;
            long expMicros = Utils.getNowMicrosUtc() + this.host.getOperationTimeoutMicros();
            URI targetUri = new URI(nettyRequest.uri()).normalize();
            request = Operation.createGet(null);
            request.setAction(Service.Action.valueOf(nettyRequest.method().toString())).setExpiration(expMicros);
            String query = targetUri.getQuery();
            if (query != null && !query.isEmpty()) {
                query = QueryStringDecoder.decodeComponent((String)targetUri.getQuery());
            }
            URI uri = new URI("http", null, "127.0.0.1", this.host.getPort(), targetUri.getPath(), query, null);
            request.setUri(uri);
            streamId = nettyRequest.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            if (streamId == null) {
                ctx.channel().attr(NettyChannelContext.OPERATION_KEY).set((Object)request);
            }
            if (nettyRequest.decoderResult().isFailure()) {
                request.setStatusCode(400).setKeepAlive(false);
                request.setBody(ServiceErrorResponse.create(new IllegalArgumentException(ERROR_MSG_DECODING_FAILURE), request.getStatusCode()));
                this.sendResponse(ctx, request, streamId);
                return;
            }
            this.parseRequestHeaders(ctx, request, (HttpRequest)nettyRequest);
            this.decodeRequestBody(ctx, request, nettyRequest.content(), streamId);
        }
        catch (Throwable e) {
            this.host.log(Level.SEVERE, "Uncaught exception: %s", Utils.toString(e));
            if (request == null) {
                request = Operation.createGet(this.host.getUri());
            }
            int sc = 400;
            if (e instanceof URISyntaxException) {
                request.setUri(this.host.getUri());
            }
            request.setKeepAlive(false).setStatusCode(sc).setBodyNoCloning(ServiceErrorResponse.create(e, sc));
            this.sendResponse(ctx, request, streamId);
        }
    }

    private void decodeRequestBody(ChannelHandlerContext ctx, Operation request, ByteBuf content, Integer streamId) {
        if (!content.isReadable()) {
            request.setContentLength(0L);
            this.submitRequest(ctx, request, streamId);
            return;
        }
        request.nestCompletion((o, e) -> {
            if (e != null) {
                request.setStatusCode(400);
                request.setBody(ServiceErrorResponse.create(e, request.getStatusCode()));
                this.sendResponse(ctx, request, streamId);
                return;
            }
            this.submitRequest(ctx, request, streamId);
        });
        Utils.decodeBody(request, content.nioBuffer());
    }

    private void parseRequestHeaders(ChannelHandlerContext ctx, Operation request, HttpRequest nettyRequest) {
        String cookie;
        HttpHeaders headers = nettyRequest.headers();
        String referer = this.getAndRemove(headers, HttpHeaderNames.REFERER);
        if (referer != null) {
            try {
                request.setReferer(new URI(referer));
            }
            catch (URISyntaxException e) {
                this.setRefererFromSocketContext(ctx, request);
            }
        } else {
            this.setRefererFromSocketContext(ctx, request);
        }
        if (headers.isEmpty()) {
            return;
        }
        request.setKeepAlive(HttpUtil.isKeepAlive((HttpMessage)nettyRequest));
        if (HttpUtil.isContentLengthSet((HttpMessage)nettyRequest)) {
            request.setContentLength(HttpUtil.getContentLength((HttpMessage)nettyRequest));
        }
        request.setContextId(this.getAndRemove(headers, "x-xenon-ctx-id"));
        String contentType = this.getAndRemove(headers, HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null) {
            request.setContentType(contentType);
        }
        if ((cookie = this.getAndRemove(headers, HttpHeaderNames.COOKIE)) != null) {
            request.setCookies(CookieJar.decodeCookies(cookie));
        }
        for (Map.Entry h : headers) {
            String key = (String)h.getKey();
            String value = (String)h.getValue();
            request.addRequestHeader(key, value);
        }
        if (this.sslHandler == null) {
            return;
        }
        try {
            if (this.sslHandler.engine().getWantClientAuth() || this.sslHandler.engine().getNeedClientAuth()) {
                SSLSession session = this.sslHandler.engine().getSession();
                request.setPeerCertificates(session.getPeerPrincipal(), session.getPeerCertificateChain());
            }
        }
        catch (Exception e) {
            this.host.log(Level.FINE, "Failed to get peer principal " + Utils.toString(e), new Object[0]);
        }
    }

    private String getAndRemove(HttpHeaders headers, AsciiString headerName) {
        String headerValue = headers.get(headerName.toString());
        headers.remove((CharSequence)headerName);
        return headerValue;
    }

    private String getAndRemove(HttpHeaders headers, String headerName) {
        String headerValue = headers.get(headerName);
        headers.remove(headerName);
        return headerValue;
    }

    private void submitRequest(ChannelHandlerContext ctx, Operation request, Integer streamId) {
        request.nestCompletion((o, e) -> {
            request.setBodyNoCloning(o.getBodyRaw());
            this.sendResponse(ctx, request, streamId);
        });
        request.setCloningDisabled(true);
        Operation localOp = request;
        if (request.getRequestCallbackLocation() != null) {
            localOp = this.processRequestWithCallback(request);
        }
        this.host.handleRequest(null, localOp);
    }

    private Operation processRequestWithCallback(Operation op) {
        URI[] targetCallback = new URI[]{null};
        try {
            targetCallback[0] = new URI(op.getRequestCallbackLocation());
        }
        catch (URISyntaxException e1) {
            op.fail(e1);
            return null;
        }
        Operation localOp = op.clone();
        op.setStatusCode(202).setBody(null).complete();
        localOp.setCompletion((o, e) -> {
            Operation patchForCompletion = Operation.createPatch(targetCallback[0]).setReferer(o.getUri());
            int responseStatusCode = o.getStatusCode();
            if (e != null) {
                ServiceErrorResponse rsp = Utils.toServiceErrorResponse(e);
                rsp.statusCode = responseStatusCode;
                patchForCompletion.setBody(rsp);
            } else if (!o.hasBody()) {
                patchForCompletion.setBodyNoCloning("{}");
            } else {
                patchForCompletion.setBodyNoCloning(o.getBodyRaw());
            }
            patchForCompletion.transferResponseHeadersToRequestHeadersFrom(o);
            patchForCompletion.addRequestHeader("x-xenon-rsp-status", Integer.toString(responseStatusCode));
            this.host.sendRequest(patchForCompletion);
        });
        return localOp;
    }

    private void sendResponse(ChannelHandlerContext ctx, Operation request, Integer streamId) {
        try {
            this.writeResponseUnsafe(ctx, request, streamId);
        }
        catch (Throwable e1) {
            this.host.log(Level.SEVERE, "%s", Utils.toString(e1));
        }
    }

    private void writeResponseUnsafe(ChannelHandlerContext ctx, Operation request, Integer streamId) {
        ByteBuf bodyBuffer = null;
        try {
            byte[] data = Utils.encodeBody(request);
            if (data != null) {
                bodyBuffer = Unpooled.wrappedBuffer((byte[])data);
            }
        }
        catch (Throwable e1) {
            byte[] data;
            this.host.log(Level.SEVERE, "Error encoding body: %s", Utils.toString(e1));
            try {
                data = ("Error encoding body: " + e1.getMessage()).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ueex) {
                this.exceptionCaught(ctx, ueex);
                return;
            }
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])data), false, false);
            if (streamId != null) {
                response.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), streamId.intValue());
            }
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
            response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
            this.writeResponse(ctx, request, (FullHttpResponse)response);
            return;
        }
        DefaultFullHttpResponse response = bodyBuffer == null || request.getStatusCode() == 304 ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)request.getStatusCode()), false, false) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)request.getStatusCode()), bodyBuffer, false, false);
        if (streamId != null) {
            response.headers().setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), streamId.intValue());
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)request.getContentType());
        response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
        for (Map.Entry<String, String> nameValue : request.getResponseHeaders().entrySet()) {
            response.headers().set(nameValue.getKey(), (Object)nameValue.getValue());
        }
        Operation.AuthorizationContext authorizationContext = request.getAuthorizationContext();
        if (authorizationContext != null && authorizationContext.shouldPropagateToClient()) {
            String token = authorizationContext.getToken();
            response.headers().add("x-xenon-auth-token", (Object)token);
            StringBuilder buf = new StringBuilder().append("xenon-auth-cookie").append('=').append(token);
            buf.append("; Path=/");
            if (authorizationContext.getClaims().getExpirationTime() != null) {
                buf.append("; Max-Age=");
                long maxAge = authorizationContext.getClaims().getExpirationTime() - Utils.getNowMicrosUtc();
                buf.append(maxAge > 0L ? TimeUnit.MICROSECONDS.toSeconds(maxAge) : 0L);
            }
            response.headers().add("set-cookie", (Object)buf.toString());
        }
        this.writeResponse(ctx, request, (FullHttpResponse)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Operation op = (Operation)ctx.attr(NettyChannelContext.OPERATION_KEY).get();
        if (op != null) {
            this.host.log(Level.SEVERE, "HTTP/1.1 listener channel exception: %s, in progress op: %s", cause.getMessage(), op.toString());
        } else {
            this.host.log(Level.SEVERE, "Listener channel exception: %s", cause.getMessage());
        }
        ctx.channel().attr(NettyChannelContext.OPERATION_KEY).remove();
        ctx.close();
    }

    private void setRefererFromSocketContext(ChannelHandlerContext ctx, Operation request) {
        try {
            InetSocketAddress remote = (InetSocketAddress)ctx.channel().remoteAddress();
            String path = "unknown-client";
            request.setReferer(UriUtils.buildUri(this.sslHandler != null ? "https" : "http", remote.getHostString(), remote.getPort(), path, null));
        }
        catch (Throwable e) {
            this.host.log(Level.SEVERE, "%s", Utils.toString(e));
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, Operation request, FullHttpResponse response) {
        boolean isClose = !request.isKeepAlive() || response == null;
        ByteBuf rsp = Unpooled.EMPTY_BUFFER;
        if (response != null) {
            AsciiString v = isClose ? HttpHeaderValues.CLOSE : HttpHeaderValues.KEEP_ALIVE;
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)v);
            rsp = response;
        }
        ctx.channel().attr(NettyChannelContext.OPERATION_KEY).remove();
        ChannelFuture future = ctx.writeAndFlush((Object)rsp);
        if (isClose) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

