/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class HttpRequestCallbackService
extends StatelessService {
    Map<Long, Operation> pendingOperations = new ConcurrentSkipListMap<Long, Operation>();
    AtomicLong nextKey = new AtomicLong();
    private String publicUri;

    public HttpRequestCallbackService() {
        super(ServiceDocument.class);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
    }

    public URI queueUntilCallback(Operation op) {
        long k = this.nextKey.incrementAndGet();
        this.pendingOperations.put(k, op);
        if (this.publicUri == null) {
            this.publicUri = UriUtils.buildPublicUri(this.getHost(), this.getSelfLink()).toString();
        }
        try {
            return new URI(this.publicUri + "?" + Long.toString(k));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(Operation o) {
        if (o.getAction() == Service.Action.DELETE) {
            super.handleRequest(o);
            return;
        }
        if (o.getAction() != Service.Action.PATCH) {
            o.fail(new IllegalArgumentException("action not supported: " + (Object)((Object)o.getAction())));
            return;
        }
        Operation request = null;
        try {
            String query = o.getUri().getQuery();
            if (query == null) {
                o.fail(new IllegalArgumentException("Missing query parameter"));
                return;
            }
            Long opId = Long.parseLong(query);
            request = this.pendingOperations.remove(opId);
            if (request == null) {
                o.fail(new IllegalArgumentException("Operation not found: " + o.getUri()));
                return;
            }
            request.setBodyNoCloning(o.getBodyRaw());
            String responseStatusValue = o.getRequestHeader("x-xenon-rsp-status");
            if (responseStatusValue == null) {
                request.fail(new IllegalArgumentException("Missing response callback status header :" + o.toString()));
                return;
            }
            request.transferRequestHeadersToResponseHeadersFrom(o);
            request.setStatusCode(Integer.parseInt(responseStatusValue));
            request.complete();
        }
        catch (Throwable e) {
            this.logSevere(e);
            if (request != null) {
                request.fail(e);
            }
        }
        finally {
            if (request != null) {
                o.complete();
            }
        }
    }

    @Override
    public void handleMaintenance(Operation o) {
        Operation op;
        long now = Utils.getNowMicrosUtc();
        Iterator<Operation> it = this.pendingOperations.values().iterator();
        while (it.hasNext() && (op = it.next()).getExpirationMicrosUtc() < now) {
            it.remove();
            op.fail(new TimeoutException());
        }
        o.complete();
    }
}

