/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.vmware.xenon.common.DigestThreadLocal;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.SystemHostInfo;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.logging.StackAwareLogRecord;
import com.vmware.xenon.common.serialization.BufferThreadLocal;
import com.vmware.xenon.common.serialization.JsonMapper;
import com.vmware.xenon.common.serialization.KryoSerializers;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utils {
    private static final int BUFFER_INITIAL_CAPACITY = 1024;
    private static final String CHARSET_UTF_8 = "UTF-8";
    public static final String PROPERTY_NAME_PREFIX = "xenon.";
    public static final String CHARSET = "UTF-8";
    public static final String UI_DIRECTORY_NAME = "ui";
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final String HASH_NAME_SHA_1 = "SHA-1";
    public static final String DEFAULT_CONTENT_HASH = "SHA-1";
    public static final int DEFAULT_THREAD_COUNT = Math.max(4, Runtime.getRuntime().availableProcessors());
    private static final long PING_LAUNCH_TOLERANCE_MS = 50L;
    private static final KryoSerializers.KryoForObjectThreadLocal kryoForObjectPerThread = new KryoSerializers.KryoForObjectThreadLocal();
    private static final KryoSerializers.KryoForDocumentThreadLocal kryoForDocumentPerThread = new KryoSerializers.KryoForDocumentThreadLocal();
    private static final DigestThreadLocal digestPerThread = new DigestThreadLocal();
    private static final BufferThreadLocal bufferPerThread = new BufferThreadLocal();
    private static final JsonMapper JSON = new JsonMapper();
    private static final ConcurrentMap<Class<?>, JsonMapper> CUSTOM_JSON = new ConcurrentHashMap();
    private static AtomicLong prevTime = new AtomicLong();
    private static long timeComparisonEpsilonMicros = TimeUnit.SECONDS.toMicros(120L);

    private static JsonMapper getJsonMapperFor(Type type) {
        if (type instanceof Class) {
            return Utils.getJsonMapperFor((Class)type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return Utils.getJsonMapperFor(rawType);
        }
        return JSON;
    }

    private static JsonMapper getJsonMapperFor(Object instance) {
        if (instance == null) {
            return JSON;
        }
        return Utils.getJsonMapperFor(instance.getClass());
    }

    private static JsonMapper getJsonMapperFor(Class<?> type) {
        if (type.isArray() && type != byte[].class) {
            type = type.getComponentType();
        }
        return CUSTOM_JSON.getOrDefault(type, JSON);
    }

    public static void registerCustomJsonMapper(Class<?> clazz, JsonMapper mapper) {
        CUSTOM_JSON.putIfAbsent(clazz, mapper);
    }

    public static <T> T clone(T t) {
        Kryo k = (Kryo)kryoForDocumentPerThread.get();
        Object clone = k.copy(t);
        return (T)clone;
    }

    public static <T> T cloneObject(T t) {
        Kryo k = (Kryo)kryoForObjectPerThread.get();
        Object clone = k.copy(t);
        k.reset();
        return (T)clone;
    }

    public static String computeSignature(ServiceDocument s, ServiceDocumentDescription description) {
        if (description == null) {
            throw new IllegalArgumentException("description is required");
        }
        byte[] buffer = Utils.getBuffer(description.serializedStateSizeLimit);
        int position = 0;
        for (ServiceDocumentDescription.PropertyDescription pd : description.propertyDescriptions.values()) {
            if (pd.indexingOptions != null && pd.indexingOptions.contains((Object)ServiceDocumentDescription.PropertyIndexingOption.EXCLUDE_FROM_SIGNATURE)) continue;
            Object fieldValue = ReflectionUtils.getPropertyValue(pd, s);
            if (pd.typeName == ServiceDocumentDescription.TypeName.COLLECTION || pd.typeName == ServiceDocumentDescription.TypeName.MAP || pd.typeName == ServiceDocumentDescription.TypeName.PODO || pd.typeName == ServiceDocumentDescription.TypeName.ARRAY) {
                String content = Utils.toJson(fieldValue);
                position = Utils.toBytes(content, buffer, position);
                continue;
            }
            if (fieldValue == null) continue;
            position = Utils.toBytes(fieldValue, buffer, position);
        }
        return Utils.computeHash(buffer, 0, position);
    }

    private static void appendJson(Object obj, Appendable buf) {
        JsonMapper mapper = Utils.getJsonMapperFor(obj);
        mapper.toJson(obj, buf);
    }

    public static byte[] getBuffer(int capacity) {
        byte[] buffer = (byte[])bufferPerThread.get();
        if (buffer.length < capacity) {
            buffer = new byte[capacity];
            bufferPerThread.set(buffer);
        }
        if (buffer.length > capacity * 10) {
            buffer = new byte[capacity];
            bufferPerThread.set(buffer);
        }
        return buffer;
    }

    public static int toBytes(Object o, byte[] buffer, int position) {
        Kryo k = (Kryo)kryoForObjectPerThread.get();
        Output out = new Output(buffer);
        out.setPosition(position);
        k.writeClassAndObject(out, o);
        return out.position();
    }

    public static int toBytes(ServiceDocument o, byte[] buffer, int position) {
        Kryo k = (Kryo)kryoForDocumentPerThread.get();
        Output out = new Output(buffer);
        out.setPosition(position);
        k.writeClassAndObject(out, (Object)o);
        return out.position();
    }

    public static Object fromBytes(byte[] bytes) {
        return Utils.fromBytes(bytes, 0, bytes.length);
    }

    public static Object fromBytes(byte[] bytes, int offset, int length) {
        Kryo k = (Kryo)kryoForObjectPerThread.get();
        Input in = new Input(bytes, offset, length);
        return k.readClassAndObject(in);
    }

    public static Object fromDocumentBytes(byte[] bytes, int offset, int length) {
        Kryo k = (Kryo)kryoForDocumentPerThread.get();
        Input in = new Input(bytes, offset, length);
        return k.readClassAndObject(in);
    }

    public static void performMaintenance() {
    }

    public static String computeHash(String content) {
        byte[] source = content.getBytes(Charset.forName("UTF-8"));
        return Utils.computeHash(source, 0, source.length);
    }

    private static String computeHash(byte[] content, int offset, int length) {
        MessageDigest digest = (MessageDigest)digestPerThread.get();
        digest.update(content, offset, length);
        byte[] hash = digest.digest();
        return Utils.toHexString(hash);
    }

    public static String toJson(Object body) {
        if (body instanceof String) {
            return (String)body;
        }
        StringBuilder content = new StringBuilder(1024);
        Utils.appendJson(body, content);
        return content.toString();
    }

    public static String toJsonHtml(Object body) {
        return Utils.getJsonMapperFor(body).toJsonHtml(body);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return Utils.getJsonMapperFor(clazz).fromJson((Object)json, clazz);
    }

    public static <T> T fromJson(Object json, Class<T> clazz) {
        return Utils.getJsonMapperFor(clazz).fromJson(json, clazz);
    }

    public static <T> T fromJson(Object json, Type type) {
        return Utils.getJsonMapperFor(type).fromJson(json, type);
    }

    public static <T> T getJsonMapValue(Object json, String key, Class<T> valueClazz) {
        Map runtimeMap = (Map)Utils.fromJson(json, new TypeToken<Map<String, JsonElement>>(){}.getType());
        return Utils.fromJson(runtimeMap.get(key), valueClazz);
    }

    public static <T> T getJsonMapValue(Object json, String key, Type valueType) {
        Map runtimeMap = (Map)Utils.fromJson(json, new TypeToken<Map<String, JsonElement>>(){}.getType());
        return Utils.fromJson(runtimeMap.get(key), valueType);
    }

    public static String toString(Throwable t) {
        StringWriter writer = new StringWriter();
        try (PrintWriter printer = new PrintWriter(writer);){
            t.printStackTrace(printer);
        }
        return writer.toString();
    }

    public static String toString(Map<?, Throwable> exceptions) {
        StringWriter writer = new StringWriter();
        try (PrintWriter printer = new PrintWriter(writer);){
            for (Throwable t : exceptions.values()) {
                t.printStackTrace(printer);
            }
        }
        return writer.toString();
    }

    public static String getCurrentFileDirectory() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            Logger.getAnonymousLogger().warning(Utils.toString(e));
            return null;
        }
    }

    public static void log(Class<?> type, String classOrUri, Level level, String fmt, Object ... args) {
        Logger lg = Logger.getLogger(type.getName());
        Utils.log(lg, 3, classOrUri, level, fmt, args);
    }

    public static void log(Logger lg, Integer nestingLevel, String classOrUri, Level level, String fmt, Object ... args) {
        if (nestingLevel == null) {
            nestingLevel = 2;
        }
        Level l = lg.getLevel();
        Logger parent = lg.getParent();
        while (l == null && parent != null) {
            l = parent.getLevel();
            if (l != null) continue;
            parent = parent.getParent();
        }
        if (l == null) {
            l = level;
        }
        if (l.intValue() > level.intValue()) {
            return;
        }
        StackAwareLogRecord lr = new StackAwareLogRecord(level, String.format(fmt, args));
        Exception e = new Exception();
        StackTraceElement[] stacks = e.getStackTrace();
        if (stacks.length > nestingLevel) {
            StackTraceElement stack = stacks[nestingLevel];
            lr.setStackElement(stack);
            lr.setSourceMethodName(stack.getMethodName());
        }
        lr.setSourceClassName(classOrUri);
        lr.setLoggerName(lg.getName());
        lg.log(lr);
    }

    public static void logWarning(String fmt, Object ... args) {
        Logger.getAnonymousLogger().warning(String.format(fmt, args));
    }

    public static long getNowMicrosUtc() {
        long time;
        long now = System.currentTimeMillis() * 1000L;
        if (now > (time = prevTime.getAndIncrement())) {
            prevTime.compareAndSet(time + 1L, now);
            return prevTime.getAndIncrement();
        }
        return time;
    }

    public static String buildKind(Class<?> type) {
        return type.getCanonicalName().replace(".", ":");
    }

    public static ServiceErrorResponse toServiceErrorResponse(Throwable e) {
        return ServiceErrorResponse.create(e, 400);
    }

    public static String toServiceErrorResponseJson(Throwable e) {
        return Utils.toJson(Utils.toServiceErrorResponse(e));
    }

    public static ServiceErrorResponse toValidationErrorResponse(Throwable t) {
        ServiceErrorResponse rsp = new ServiceErrorResponse();
        rsp.message = t.getLocalizedMessage();
        return rsp;
    }

    public static boolean isValidationError(Throwable e) {
        return e instanceof IllegalArgumentException;
    }

    public static String toHexString(byte[] data) {
        char[] sb = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            int v = data[i] & 0xFF;
            sb[2 * i] = HEX_CHARS[v >>> 4];
            sb[2 * i + 1] = HEX_CHARS[v & 0xF];
        }
        return new String(sb);
    }

    public static String buildServicePath(Class<? extends Service> klass) {
        return klass.getName().replace('.', '/');
    }

    public static String buildUiResourceUriPrefixPath(Class<? extends Service> klass) {
        return UriUtils.buildUriPath("/user-interface/resources", Utils.buildServicePath(klass));
    }

    public static String buildUiResourceUriPrefixPath(Service service) {
        return Utils.buildUiResourceUriPrefixPath(service.getClass());
    }

    public static String buildCustomUiResourceUriPrefixPath(Service service) {
        return UriUtils.buildUriPath("/user-interface/resources", service.getDocumentTemplate().documentDescription.userInterfaceResourcePath);
    }

    public static Object setJsonProperty(Object body, String fieldName, String fieldValue) {
        JsonObject jo = body instanceof JsonObject ? (JsonObject)body : new JsonParser().parse((String)body).getAsJsonObject();
        jo.remove(fieldName);
        if (fieldValue != null) {
            jo.addProperty(fieldName, fieldValue);
        }
        return jo;
    }

    public static void setTimeComparisonEpsilonMicros(long micros) {
        timeComparisonEpsilonMicros = micros;
    }

    public static long getTimeComparisonEpsilonMicros() {
        return timeComparisonEpsilonMicros;
    }

    public static String validateServiceOption(EnumSet<Service.ServiceOption> options, Service.ServiceOption option) {
        Object error;
        EnumSet<Service.ServiceOption> reqs = null;
        EnumSet<Service.ServiceOption> antiReqs = null;
        switch (option) {
            case CONCURRENT_UPDATE_HANDLING: {
                antiReqs = EnumSet.of(Service.ServiceOption.OWNER_SELECTION, Service.ServiceOption.STRICT_UPDATE_CHECKING);
                break;
            }
            case OWNER_SELECTION: {
                reqs = EnumSet.of(Service.ServiceOption.REPLICATION);
                antiReqs = EnumSet.of(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING);
                break;
            }
            case STRICT_UPDATE_CHECKING: {
                antiReqs = EnumSet.of(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING);
                break;
            }
            case URI_NAMESPACE_OWNER: {
                antiReqs = EnumSet.of(Service.ServiceOption.PERSISTENCE, Service.ServiceOption.REPLICATION);
                break;
            }
            case PERIODIC_MAINTENANCE: {
                break;
            }
            case PERSISTENCE: {
                break;
            }
            case REPLICATION: {
                break;
            }
            case DOCUMENT_OWNER: {
                break;
            }
            case IDEMPOTENT_POST: {
                break;
            }
            case FACTORY: {
                break;
            }
            case FACTORY_ITEM: {
                break;
            }
            case HTML_USER_INTERFACE: {
                break;
            }
            case INSTRUMENTATION: {
                break;
            }
            case LIFO_QUEUE: {
                break;
            }
            case NONE: {
                break;
            }
            case UTILITY: {
                break;
            }
        }
        if (!options.contains((Object)option)) {
            return null;
        }
        if (reqs == null && antiReqs == null) {
            return null;
        }
        if (reqs != null) {
            EnumSet<Service.ServiceOption> missingReqs = EnumSet.noneOf(Service.ServiceOption.class);
            for (Service.ServiceOption r : reqs) {
                if (options.contains((Object)r)) continue;
                missingReqs.add(r);
            }
            if (!missingReqs.isEmpty()) {
                error = String.format("%s missing required options: %s", new Object[]{option, missingReqs});
                return error;
            }
        }
        EnumSet<Service.ServiceOption> conflictReqs = EnumSet.noneOf(Service.ServiceOption.class);
        for (Service.ServiceOption r : antiReqs) {
            if (!options.contains((Object)r)) continue;
            conflictReqs.add(r);
        }
        if (!conflictReqs.isEmpty()) {
            error = String.format("%s conflicts with options: %s", new Object[]{option, conflictReqs});
            return error;
        }
        return null;
    }

    public static String getOsName(SystemHostInfo systemInfo) {
        return systemInfo.properties.get("os.name");
    }

    public static SystemHostInfo.OsFamily determineOsFamily(String osName) {
        String string = osName = osName == null ? "" : osName.toLowerCase(Locale.ENGLISH);
        if (osName.contains("mac")) {
            return SystemHostInfo.OsFamily.MACOS;
        }
        if (osName.contains("win")) {
            return SystemHostInfo.OsFamily.WINDOWS;
        }
        if (osName.contains("nux")) {
            return SystemHostInfo.OsFamily.LINUX;
        }
        return SystemHostInfo.OsFamily.OTHER;
    }

    public static boolean isReachable(SystemHostInfo systemInfo, InetAddress addr, long timeoutMs) throws IOException {
        if (systemInfo.osFamily == SystemHostInfo.OsFamily.WINDOWS) {
            return Utils.isReachableByPing(systemInfo, addr, timeoutMs);
        }
        return addr.isReachable((int)timeoutMs);
    }

    public static boolean isReachableByPing(SystemHostInfo systemInfo, InetAddress addr, long timeoutMs) throws IOException {
        try {
            Process process = new ProcessBuilder("ping", "-n", "1", "-w", Long.toString(timeoutMs), Utils.getNormalizedHostAddress(systemInfo, addr)).start();
            boolean completed = process.waitFor(50L + timeoutMs, TimeUnit.MILLISECONDS);
            return completed && process.exitValue() == 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static String getNormalizedHostAddress(SystemHostInfo systemInfo, InetAddress addr) {
        String addrStr = addr.getHostAddress();
        if (systemInfo.osFamily == SystemHostInfo.OsFamily.WINDOWS && addr instanceof Inet6Address && addr.isLinkLocalAddress()) {
            Inet6Address ip6Addr = (Inet6Address)addr;
            int pct = addrStr.lastIndexOf(37);
            if (pct > -1) {
                addrStr = addrStr.substring(0, pct) + '%' + ip6Addr.getScopeId();
            }
        }
        return addrStr;
    }

    public static byte[] encodeBody(Operation op) throws Throwable {
        byte[] data = null;
        String contentType = op.getContentType();
        if (!op.hasBody()) {
            op.setContentLength(0L);
            return null;
        }
        Object body = op.getBodyRaw();
        if (body instanceof String) {
            data = ((String)body).getBytes("UTF-8");
            op.setContentLength(data.length);
        } else if (body instanceof byte[]) {
            data = (byte[])body;
            if (contentType == null) {
                op.setContentType("application/octet-stream");
            }
            if (op.getContentLength() == 0L || op.getContentLength() > (long)data.length) {
                op.setContentLength(data.length);
            }
        }
        if (data == null) {
            if (contentType == null || contentType.contains("application/json")) {
                String encodedBody;
                if (op.getAction() == Service.Action.GET) {
                    encodedBody = Utils.toJsonHtml(body);
                } else {
                    encodedBody = Utils.toJson(body);
                    if (contentType == null) {
                        op.setContentType("application/json");
                    }
                }
                data = encodedBody.getBytes("UTF-8");
                op.setContentLength(data.length);
            } else {
                throw new IllegalArgumentException("Unrecognized content type: " + contentType);
            }
        }
        return data;
    }

    public static void decodeBody(Operation op, ByteBuffer buffer) {
        if (op.getContentLength() == 0L) {
            op.setContentType("application/json").complete();
            return;
        }
        try {
            String contentType = op.getContentType();
            Object body = Utils.decodeIfText(buffer, contentType);
            if (body == null) {
                byte[] data = new byte[(int)op.getContentLength()];
                buffer.get(data);
                body = data;
            }
            op.setBodyNoCloning(body).complete();
        }
        catch (Throwable e) {
            op.fail(e);
        }
    }

    public static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeIfText(ByteBuffer buffer, String contentType) throws CharacterCodingException {
        String body = null;
        if (contentType == null) {
            return null;
        }
        if (contentType.contains("application/json") || contentType.contains("text") || contentType.contains("css") || contentType.contains("script") || contentType.contains("html") || contentType.contains("xml")) {
            body = Charset.forName("UTF-8").newDecoder().decode(buffer).toString();
        } else if (contentType.contains("application/x-www-form-urlencoded")) {
            body = Charset.forName("UTF-8").newDecoder().decode(buffer).toString();
            try {
                body = URLDecoder.decode(body, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return body;
    }

    public static Path getServiceUiResourcePath(Service s) {
        ServiceDocument sd = s.getDocumentTemplate();
        ServiceDocumentDescription sdd = sd.documentDescription;
        if (sdd != null && sdd.userInterfaceResourcePath != null) {
            String resourcePath = sdd.userInterfaceResourcePath;
            if (!resourcePath.isEmpty()) {
                return Paths.get(resourcePath, new String[0]);
            }
        } else {
            String servicePath = Utils.buildServicePath(s.getClass());
            return Paths.get(UI_DIRECTORY_NAME, servicePath);
        }
        Utils.log(Utils.class, Utils.class.getSimpleName(), Level.SEVERE, "UserInterface resource path field empty for service document %s", s.getClass().getSimpleName());
        return null;
    }

    public static <K, V> V atomicGetOrCreate(ConcurrentMap<K, V> map, K key, Callable<V> ctor) {
        Object value = map.get(key);
        if (value == null) {
            try {
                value = ctor.call();
            }
            catch (Exception e) {
                throw new RuntimeException("Element constructor should now throw an exception", e);
            }
            V existing = map.putIfAbsent(key, value);
            if (existing != null) {
                return existing;
            }
        }
        return value;
    }

    public static <T extends ServiceDocument> boolean mergeWithState(ServiceDocumentDescription desc, T source, T patch) {
        Class<?> clazz = source.getClass();
        if (!patch.getClass().equals(clazz)) {
            throw new IllegalArgumentException("Source object and patch object types mismatch");
        }
        boolean modified = false;
        for (ServiceDocumentDescription.PropertyDescription prop : desc.propertyDescriptions.values()) {
            Object o;
            if (prop.usageOptions == null || !prop.usageOptions.contains((Object)ServiceDocumentDescription.PropertyUsageOption.AUTO_MERGE_IF_NOT_NULL) || (o = ReflectionUtils.getPropertyValue(prop, patch)) == null || o.equals(ReflectionUtils.getPropertyValue(prop, source))) continue;
            ReflectionUtils.setPropertyValue(prop, source, o);
            modified = true;
        }
        return modified;
    }

    public static ServiceDocumentQueryResult mergeQueryResults(List<ServiceDocumentQueryResult> dataSources, boolean isAscOrder) {
        ServiceDocumentQueryResult result = new ServiceDocumentQueryResult();
        result.documents = new HashMap<String, Object>();
        result.documentCount = 0L;
        int[] indices = new int[dataSources.size()];
        block0: while (true) {
            String documentLinkPicked = null;
            ArrayList<Integer> sourcesPicked = new ArrayList<Integer>();
            for (int i = 0; i < dataSources.size(); ++i) {
                if ((long)indices[i] >= dataSources.get((int)i).documentCount) continue;
                String documentLink = dataSources.get((int)i).documentLinks.get(indices[i]);
                if (documentLinkPicked == null) {
                    documentLinkPicked = documentLink;
                    sourcesPicked.add(i);
                    continue;
                }
                if (isAscOrder && documentLink.compareTo(documentLinkPicked) < 0 || !isAscOrder && documentLink.compareTo(documentLinkPicked) > 0) {
                    documentLinkPicked = documentLink;
                    sourcesPicked.clear();
                    sourcesPicked.add(i);
                    continue;
                }
                if (!documentLink.equals(documentLinkPicked)) continue;
                sourcesPicked.add(i);
            }
            if (documentLinkPicked == null) break;
            result.documentLinks.add(documentLinkPicked);
            ServiceDocumentQueryResult partialResult = dataSources.get((Integer)sourcesPicked.get(0));
            if (partialResult.documents != null) {
                result.documents.put(documentLinkPicked, partialResult.documents.get(documentLinkPicked));
            }
            Object object = result;
            Long l = ((ServiceDocumentQueryResult)object).documentCount;
            Long l2 = ((ServiceDocumentQueryResult)object).documentCount = Long.valueOf(((ServiceDocumentQueryResult)object).documentCount + 1L);
            object = sourcesPicked.iterator();
            while (true) {
                int i;
                if (!object.hasNext()) continue block0;
                int n = i = ((Integer)object.next()).intValue();
                indices[n] = indices[n] + 1;
            }
            break;
        }
        return result;
    }
}

