/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.TransactionService;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TransactionServiceHelper {
    static void handleGetWithinTransaction(StatefulService s, Operation get, Handler h, FailRequest fr) {
        QueryTask.Query selfLinkClause = new QueryTask.Query().setTermPropertyName("documentSelfLink").setTermMatchValue(s.getSelfLink());
        QueryTask.Query txClause = new QueryTask.Query();
        if (get.isWithinTransaction()) {
            txClause.setTermPropertyName("documentTransactionId");
            txClause.setTermMatchValue(get.getTransactionId());
        } else {
            txClause.setTermPropertyName("documentTransactionId");
            txClause.setTermMatchValue("*");
            txClause.setTermMatchType(QueryTask.QueryTerm.MatchType.WILDCARD);
            txClause.occurance = QueryTask.Query.Occurance.MUST_NOT_OCCUR;
        }
        QueryTask.QuerySpecification q = new QueryTask.QuerySpecification();
        q.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT, QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
        q.query.addBooleanClause(selfLinkClause);
        q.query.addBooleanClause(txClause);
        QueryTask task = QueryTask.create(q).setDirect(true);
        URI uri = UriUtils.buildUri(s.getHost(), ServiceUriPaths.CORE_QUERY_TASKS);
        Operation startPost = Operation.createPost(uri).setBody(task).setCompletion((o, f) -> TransactionServiceHelper.handleTransactionQueryCompletion(s, o, f, get, h, fr));
        s.sendRequest(startPost);
    }

    static void handleTransactionQueryCompletion(StatefulService s, Operation o, Throwable f, Operation original, Handler h, FailRequest fr) {
        if (f != null) {
            s.logInfo(f.toString(), new Object[0]);
            original.fail(f);
            return;
        }
        QueryTask response = o.getBody(QueryTask.class);
        if (response.results.documentLinks.isEmpty()) {
            if (original.isWithinTransaction()) {
                h.handler(original);
            } else {
                original.setStatusCode(404);
                fr.failRequest(original, new IllegalStateException("Latest state not found"), false);
            }
            return;
        }
        List<String> dl = response.results.documentLinks;
        String latest = dl.get(0);
        Object obj = response.results.documents.get(latest);
        original.setBodyNoCloning(obj).complete();
        original.complete();
    }

    static void notifyTransactionCoordinator(Service s, Set<String> txCoordinatorLinks, Operation op, Throwable e) {
        Operation.TransactionContext operationsLogRecord = new Operation.TransactionContext();
        operationsLogRecord.action = op.getAction();
        operationsLogRecord.coordinatorLinks = txCoordinatorLinks;
        operationsLogRecord.isSuccessful = e == null;
        URI txCoordinator = UriUtils.buildTransactionUri(s.getHost(), op.getTransactionId());
        txCoordinatorLinks.add(txCoordinator.toString());
        s.sendRequest(Operation.createPut(txCoordinator).setBody(operationsLogRecord));
    }

    static void notifyTransactionCoordinatorOfNewService(FactoryService factoryService, Service childService, Operation op) {
        childService.setHost(factoryService.getHost());
        URI childServiceUri = op.getUri().normalize();
        String childServicePath = UriUtils.normalizeUriPath(childServiceUri.getPath()).intern();
        childService.setSelfLink(childServicePath);
        TransactionServiceHelper.notifyTransactionCoordinator(childService, new HashSet<String>(), op, null);
    }

    static void abortTransactions(StatefulService service, Set<String> coordinators) {
        if (coordinators == null || coordinators.isEmpty()) {
            return;
        }
        TransactionService.ResolutionRequest resolution = new TransactionService.ResolutionRequest();
        resolution.kind = TransactionService.ResolutionKind.ABORT;
        for (String coordinator : coordinators) {
            service.sendRequest(Operation.createPatch(UriUtils.buildUri(coordinator)).setBodyNoCloning(resolution));
        }
    }

    static boolean handleOperationInTransaction(StatefulService s, Class<? extends ServiceDocument> st, Set<String> txCoordinatorLinks, Operation request) {
        if (request.getRequestHeader("x-xenon-tx-phase") == null) {
            return false;
        }
        if (request.getRequestHeader("x-xenon-tx-phase").equals("commit")) {
            if (txCoordinatorLinks != null) {
                txCoordinatorLinks.remove(request.getReferer().toString());
            }
            QueryTask.QuerySpecification q = new QueryTask.QuerySpecification();
            q.query.setTermPropertyName("documentTransactionId");
            q.query.setTermMatchValue(UriUtils.getLastPathSegment(request.getReferer()));
            q.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT, QueryTask.QuerySpecification.QueryOption.INCLUDE_ALL_VERSIONS);
            QueryTask task = QueryTask.create(q).setDirect(true);
            URI uri = UriUtils.buildUri(s.getHost(), ServiceUriPaths.CORE_QUERY_TASKS);
            Operation startPost = Operation.createPost(uri).setBody(task).setCompletion((o, f) -> TransactionServiceHelper.unshadowQueryCompletion(s, st, o, f, request));
            s.sendRequest(startPost);
        } else if (request.getRequestHeader("x-xenon-tx-phase").equals("abort")) {
            if (txCoordinatorLinks != null) {
                txCoordinatorLinks.remove(request.getReferer().toString());
            }
            request.complete();
        } else {
            request.fail(new IllegalArgumentException("Transaction control message, but none of {commit, abort}"));
        }
        return true;
    }

    static void unshadowQueryCompletion(StatefulService s, Class<? extends ServiceDocument> st, Operation o, Throwable f, Operation original) {
        if (f != null) {
            s.logInfo(f.toString(), new Object[0]);
            original.fail(f);
            return;
        }
        QueryTask response = o.getBody(QueryTask.class);
        if (response.results.documentLinks.isEmpty()) {
            original.fail(new IllegalStateException("There should be at least one shadowed, but none was found"));
            return;
        }
        List<String> dl = response.results.documentLinks;
        String latest = dl.get(0);
        Object obj = response.results.documents.get(latest);
        ServiceDocument sd = Utils.fromJson((String)obj, st);
        sd.documentTransactionId = null;
        s.setState(original, sd);
        original.complete();
    }

    static interface FailRequest {
        public void failRequest(Operation var1, Throwable var2, boolean var3);
    }

    static interface Handler {
        public void handler(Operation var1);
    }
}

